/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridFilteringModelImpl;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridSortingModelImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseTableGridDataHookUp
extends DatabaseGridDataHookUp {
    private static final Logger LOG = Logger.getInstance(DatabaseTableGridDataHookUp.class);
    protected final VirtualFile myFile;
    private final GridFilteringModelImpl myFilteringModel;
    private final GridSortingModelImpl<DataConsumer.Row, DataConsumer.Column> mySortingModel;
    private boolean myInitialized;

    DatabaseTableGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull VirtualFile file, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (department == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session2, department);
        this.myFile = file;
        this.myFilteringModel = new GridFilteringModelImpl();
        GridSortingModelImpl gridSortingModelImpl = this.mySortingModel = this.getDbms().isCassandra() ? null : new GridSortingModelImpl();
        if (this.mySortingModel != null) {
            this.mySortingModel.setSortingEnabled(true);
            this.mySortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    DatabaseTableGridDataHookUp.this.myLoader.invalidateQuery();
                }
            }, this);
        }
        this.updateFilterPSI();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myFile.getPresentableName();
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public GridFilteringModel getFilteringModel() {
        GridFilteringModelImpl gridFilteringModelImpl = this.myFilteringModel;
        if (gridFilteringModelImpl == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(5);
        }
        return gridFilteringModelImpl;
    }

    @Override
    @Nullable
    public GridSortingModel<DataConsumer.Row, DataConsumer.Column> getSortingModel() {
        return this.mySortingModel;
    }

    @Override
    public boolean isReadOnly() {
        ObjectKind kind = DbImplUtil.getKind(this.myFile);
        return !DbImplUtil.isEditableTable(this.getDbms(), kind) || !this.myFile.isWritable() || super.isReadOnly();
    }

    @Override
    protected void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean isSucceeded, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(6);
        }
        if (isSucceeded && source.phase == GridRequestSource.Phase.FIRST && this.isTwoPhaseRequest()) {
            source.phase = GridRequestSource.Phase.LOAD_VALUES_USING_KEYS;
            this.getLoader().reloadCurrentPage(source, reloadPolicy);
            return;
        }
        super.requestFinished(source, isSucceeded, reloadPolicy);
    }

    private boolean isTwoPhaseRequest() {
        DasTable table = this.getDatabaseTable();
        return table != null && this.getDatabaseDialect().isTwoPhaseSelect(table);
    }

    @Override
    protected int getPageSizeForRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(7);
        }
        return this.isTwoPhaseRequest() && !DbImplUtil.isPageSizeUnlimited(this.myPageModel.getPageSize()) && source.phase == GridRequestSource.Phase.FIRST ? this.myPageModel.getPageSize() + 1 : this.myPageModel.getPageSize();
    }

    @Override
    @Nullable
    public String getUnlimitedQueryText(boolean ordered) {
        com.intellij.openapi.util.Pair<String, Boolean> pair = ((DatabaseGridDataHookUp.DatabaseLoader)this.myLoader).createQueryTextPure(DataBusGridDataHookUp.QueryAttributes.unlimited(ordered), null);
        return pair == null ? super.getUnlimitedQueryText(ordered) : (String)pair.getFirst();
    }

    @Override
    @Nullable
    public DasTable getDatabaseTable() {
        DasTable table = super.getDatabaseTable();
        if (table == null && this.myFile.isValid()) {
            table = (DasTable)ObjectUtils.tryCast((Object)DbImplUtil.findElement(this.getProject(), this.myFile), DasTable.class);
            this.setDatabaseTable(table);
        }
        return table;
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        return new DatabaseTableLoader();
    }

    private void updateFilterPSI() {
        DbDataSource dataSource2 = this.getDataSource();
        String queryText2 = this.getQueryText();
        Document document = this.myFilteringModel.getFilterDocument();
        String filterText = document.getText();
        PsiCodeFragment fragment = GridHelper.get(this.getDbms()).createFilterCodeFragment(this.getProject(), filterText, queryText2, dataSource2, this.getDatabaseTable());
        if (fragment == null) {
            fragment = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)filterText);
        }
        ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.getProject())).associatePsi(document, (PsiFile)fragment);
        this.myFilteringModel.firePSIUpdated();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @Override
    protected void processRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull DataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(9);
        }
        if (request == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(10);
        }
        this.initialize().onProcessed(__ -> super.processRequest(source, request, reloadPolicy));
    }

    @NotNull
    private Promise<Void> initialize() {
        if (this.myInitialized) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(11);
            }
            return promise;
        }
        this.myInitialized = true;
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        DasNamespace object = DbImplUtil.getSearchPathObject(dialect, (DasObject)this.getDatabaseTable());
        if (object == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(12);
            }
            return promise;
        }
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)this.getDataSource());
        SearchPath path = DbImplUtil.getAutoSwitchPath(dataSource2, ObjectPaths.searchPathOf((DasObject)object));
        if (path == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(13);
            }
            return promise;
        }
        DataRequest request = DataRequest.newSchemaSwitchRequest(this, path, false);
        this.getMessageBus().getDataProducer().processRequest(request);
        AsyncPromise<Void> asyncPromise = request.getPromise();
        if (asyncPromise == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteringModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPageSizeForRequest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DatabaseTableLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private DatabaseTableLoader() {
        }

        @Override
        protected void queryTextUpdated() {
            DatabaseTableGridDataHookUp.this.updateFilterPSI();
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                DatabaseTableLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DatabaseTableLoader.$$$reportNull$$$0(1);
            }
            boolean columnsChanged = !this.sameColumnsAsInModel(columns);
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
            if (columnsChanged) {
                DatabaseTableGridDataHookUp.this.updateFilterPSI();
            }
        }

        @Override
        protected boolean canCountRows(@Nullable String query) {
            return true;
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(2);
            }
            this.invalidateQuery();
            super.loadFirstPage(source);
        }

        @Override
        public void loadLastPage(final @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            int offset;
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(3);
            }
            this.invalidateQuery();
            int pageSize = DatabaseTableGridDataHookUp.this.myPageModel.getPageSize();
            int n = offset = pageSize > 0 ? -pageSize : -100;
            if (DbImplUtil.supportsOffset(DatabaseTableGridDataHookUp.this.getDbms()) && Registry.is((String)"database.grid.paging.offset")) {
                AsyncFutureResult<Long> result = CountRowsAction.countRows(DatabaseTableGridDataHookUp.this);
                result.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Long>(){

                    public void onSuccess(Long rowsCount) {
                        DatabaseTableLoader.this.load(source, Math.max(0, (int)(rowsCount + (long)offset)));
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LOG.error(t);
                        DatabaseTableLoader.this.load(source, offset - 1);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader$1", "onFailure"));
                    }
                });
            } else {
                this.load(source, offset - 1);
            }
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(4);
            }
            this.invalidateQuery();
            super.reloadCurrentPage(source);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(5);
            }
            this.invalidateQuery();
            super.loadNextPage(source);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(6);
            }
            this.invalidateQuery();
            super.loadPreviousPage(source);
        }

        @Override
        protected void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int offset, @Nullable DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(7);
            }
            this.invalidateQuery();
            super.load(source, offset, reloadPolicy);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(8);
            }
            this.invalidateQuery();
            this.invalidateRowCount();
            this.loadFirstPage(source);
        }

        @Override
        @NotNull
        protected SelectTask.Companion.Builder selectTask(@NotNull DasTable dbTable) {
            if (dbTable == null) {
                DatabaseTableLoader.$$$reportNull$$$0(9);
            }
            SelectTask.Companion.Builder builder = super.selectTask(dbTable).keysOnly(DatabaseTableGridDataHookUp.this.isTwoPhaseRequest());
            if (builder == null) {
                DatabaseTableLoader.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(11);
            }
            source.phase = GridRequestSource.Phase.COUNT;
            DasTable table = DatabaseTableGridDataHookUp.this.getDatabaseTable();
            if (table == null || !DatabaseTableGridDataHookUp.this.isTwoPhaseRequest()) {
                super.updateTotalRowCount(source);
                return;
            }
            SelectTask task = this.selectTask(table).keysOnly(false).build();
            String unlimitedQuery = DmlUtilKt.dmlGenerator(DatabaseTableGridDataHookUp.this.getDbms()).generate(DbImplUtil.createBuilderForUIExec(DatabaseTableGridDataHookUp.this.getDatabaseDialect(), (DasObject)table), task).getStatement();
            this.updateTotalRowCount(source, unlimitedQuery);
        }

        @Override
        protected void setTotalRowCount(@Nullable GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int total) {
            int realPageEnd;
            boolean isFirstPhaseOfTwo = source != null && source.phase == GridRequestSource.Phase.FIRST && DatabaseTableGridDataHookUp.this.isTwoPhaseRequest();
            int n = realPageEnd = isFirstPhaseOfTwo ? DatabaseTableGridDataHookUp.this.myPageModel.getPageEnd() - 1 : DatabaseTableGridDataHookUp.this.myPageModel.getPageEnd();
            if ((long)total > DatabaseTableGridDataHookUp.this.myPageModel.getTotalRowCount() || realPageEnd == total) {
                DatabaseTableGridDataHookUp.this.myPageModel.setTotalRowCount(total, realPageEnd >= total);
            }
        }

        @Override
        @Nullable
        protected OrderBy getOrderBy() {
            if (DatabaseTableGridDataHookUp.this.mySortingModel == null) {
                return null;
            }
            List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering = DatabaseTableGridDataHookUp.this.mySortingModel.getOrdering();
            ArrayList<Pair> o = new ArrayList<Pair>();
            for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : ordering) {
                DataConsumer.Column column2 = DatabaseTableGridDataHookUp.this.myModel.getColumn(order.getColumn());
                if (column2 == null || order.getOrder() != RowSortOrder.Type.DESC && order.getOrder() != RowSortOrder.Type.ASC) continue;
                o.add(new Pair((Object)column2.name, (Object)order.getOrder()));
            }
            return o.isEmpty() ? null : new ColumnsOrderBy(o);
        }

        @Override
        protected WhereClause getWhereClause() {
            String filter2 = DatabaseTableGridDataHookUp.this.myFilteringModel.getAppliedText();
            boolean emptyFilter = StringUtil.isEmptyOrSpaces((String)filter2) || filter2.startsWith("--") || filter2.startsWith("#") || filter2.startsWith("//") || filter2.startsWith("/*");
            return emptyFilter ? null : new PlainWhereClause(filter2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbTable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFirstPage";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLastPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reloadCurrentPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadNextPage";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "loadPreviousPage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFilter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTask";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

