/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataGrid
extends Grid<DataConsumer.Row, DataConsumer.Column>,
Disposable {
    public boolean isEmpty();

    public boolean isReady();

    public void insertRow();

    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> var1);

    public ActionCallback submit();

    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> var1);

    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> var1);

    public void insertColumn();

    public void cloneColumn(@NotNull ModelIndex<DataConsumer.Column> var1);

    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> var1);

    public boolean isColumnsMutationSupported();

    public boolean isFilteringSupported();

    public boolean isFilteringEnabled();

    public boolean toggleFiltering();

    public void setFilterText(String var1, int var2);

    public void applyFilter();

    @NotNull
    public GridFilterPanel getFilterPanel();

    public void resetFilters();

    public boolean isSortViaOrderBySupported();

    public boolean isSortViaOrderBy();

    public void setSortViaOrderBy(boolean var1);

    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> var1);

    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> var1);

    public void sortColumns(List<ModelIndex<DataConsumer.Column>> var1, RowSortOrder.Type var2);

    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> var1);

    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> var1, @NotNull Language var2);

    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn();

    public ObjectFormatter getObjectFormatter();

    public void addDataGridListener(DataGridListener var1, Disposable var2);

    public void resetLayout();

    public void loadingDelayDisabled();

    public void loadingDelayed();

    public void fireValueEdited(@Nullable Object var1);

    @NotNull
    public ResultView getResultView();

    public void setPresentationMode(@NotNull GridPresentationMode var1);

    @NotNull
    public GridPresentationMode getPresentationMode();

    @NotNull
    public DataExtractorFactory.Text getExtractorFactory();

    public void setExtractorFactory(@NotNull DataExtractorFactory.Text var1);

    @NotNull
    public DatabaseSettings.BooleanMode getBooleanMode();
}

