/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BestDriverValidator
extends DatabaseConfigValidator<LocalDataSource> {
    private static final String APPROVED_DRIVER = "APPROVED_DRIVER";

    @Override
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, final @NotNull LocalDataSource dataSource2, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor) {
        Dbms dsDbms;
        DatabaseDriver driver;
        if (project == null) {
            BestDriverValidator.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            BestDriverValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            BestDriverValidator.$$$reportNull$$$0(2);
        }
        if ((driver = dataSource2.getDatabaseDriver()) == null || !driver.isPredefined() || driver.getId().equals(dataSource2.getAdditionalJdbcProperties().get(APPROVED_DRIVER))) {
            return;
        }
        Dbms driverDbms = DbImplUtil.getDbms(driver);
        if (driverDbms == (dsDbms = dataSource2.getDbms())) {
            return;
        }
        final DatabaseDriver bestDriver = DbImplUtil.guessDatabaseDriver(dsDbms);
        if (bestDriver == null || !bestDriver.isPredefined()) {
            return;
        }
        String description = DatabaseBundle.message((String)"BestDriverValidator.message", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)bestDriver.getName())});
        Runnable ignore = () -> {
            DataSourceConfigurable configurable;
            DataSourceConfigurable dataSourceConfigurable = configurable = editor == null ? null : editor.getConfigurable(dataSource2, true, DataSourceConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.setExtraProperty(APPROVED_DRIVER, driver.getId());
        };
        NamedProgressive fix = editor == null ? null : new NamedProgressive(DatabaseBundle.message((String)"BestDriverValidator.switch.driver", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                UIUtil.invokeAndWaitIfNeeded(() -> {
                    DataSourceConfigurable configurable = editor.getConfigurable(dataSource2, true, DataSourceConfigurable.class);
                    if (configurable == null) {
                        return;
                    }
                    configurable.setDriver(bestDriver);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/BestDriverValidator$1", "run"));
            }
        };
        DataSourceProblem.Navigate navigate = new DataSourceProblem.Navigate(bestDriver);
        DataSourceProblem.HyperText text2 = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"BestDriverValidator.title", (Object[])new Object[0]), description + DatabaseBundle.message((String)"BestDriverValidator.switch.driver.2", (Object[])new Object[0]), description, navigate, ignore, fix);
        problems.consume((Object)new DataSourceProblem(dataSource2, APPROVED_DRIVER, DataSourceProblem.Level.WARNING, text2, fix));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problems";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/validation/BestDriverValidator";
        objectArray[2] = "collectProblems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

