/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StringReader;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseAuthPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final LocalDataSource myAccumulator;
    private final DatabaseCredentials myCredentials;
    private JBLabel myAuthLabel;
    private ComboBox<DatabaseAuthProvider> myAuthComboBox;
    private JComponent myAuthPanel;
    private DatabaseAuthProvider.AuthWidget myWidget;
    private Runnable myFieldsListener;

    public DatabaseAuthPanel(@NotNull Project project, LocalDataSource dataSource2, DatabaseCredentials credentials) {
        if (project == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDataSource = dataSource2;
        this.myAccumulator = this.myDataSource.copy(true);
        this.myCredentials = credentials;
        this.createAuthBox();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myAuthPanel;
        if (jComponent == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Object object = this.myWidget == null ? this.myAuthComboBox : this.myWidget.getPreferredFocusedComponent();
        if (object == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(2);
        }
        return object;
    }

    public void addListeners(Runnable fieldsListener, final UrlEditorModelBase.StateChangeListener authTypeListener) {
        this.myFieldsListener = fieldsListener;
        if (this.myWidget != null) {
            this.myWidget.onChanged(this.myFieldsListener);
        }
        this.myAuthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                authTypeListener.stateChanged(null);
            }
        });
    }

    private void createAuthBox() {
        this.myAuthLabel = new JBLabel(DatabaseBundle.message((String)"authentication.type", (Object[])new Object[0]));
        this.myAuthComboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(DatabaseAuthProvider.getApplicable(this.myDataSource), null));
        this.myAuthComboBox.setRenderer((ListCellRenderer)new SimpleListCellRenderer<DatabaseAuthProvider>(){

            public void customize(@NotNull JList<? extends DatabaseAuthProvider> list, DatabaseAuthProvider value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setText(value2 == null ? "" : value2.getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel$2", "customize"));
            }
        });
        this.myAuthPanel = new JPanel();
        this.validateAuthPanel();
        this.myAuthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseAuthProvider item = (DatabaseAuthProvider)DatabaseAuthPanel.this.myAuthComboBox.getSelectedItem();
                if (item != null) {
                    DatabaseAuthPanel.this.applyAuthProvider(item);
                }
            }
        });
    }

    private void applyAuthProvider(@NotNull DatabaseAuthProvider provider) {
        if (provider == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(3);
        }
        if (this.myWidget != null) {
            this.myWidget.save(this.myAccumulator, true);
        }
        this.myWidget = provider.createWidget(this.myProject, this.myCredentials, this.myDataSource);
        if (this.myWidget != null) {
            this.myWidget.reset(this.myAccumulator, false);
        }
        if (this.myFieldsListener != null && this.myWidget != null) {
            this.myWidget.onChanged(this.myFieldsListener);
        }
        this.validateAuthPanel();
    }

    private void validateAuthPanel() {
        GridLayoutManager l = (GridLayoutManager)ObjectUtils.tryCast((Object)this.myAuthPanel.getLayout(), GridLayoutManager.class);
        boolean authVisible = this.myAuthComboBox.getItemCount() > 1;
        int rowCount = (authVisible ? 1 : 0) + (this.myWidget == null ? 0 : 1);
        if (l != null && l.getRowCount() == rowCount && (this.myWidget == null || this.myWidget.getComponent().getParent() == this.myAuthPanel)) {
            return;
        }
        this.myAuthPanel.removeAll();
        this.myAuthPanel.setLayout((LayoutManager)new GridLayoutManager(Math.max(rowCount, 1), 6));
        if (authVisible) {
            this.myAuthPanel.add((Component)this.myAuthLabel, UrlPropertiesPanel.createLabelConstraints(0, 0, this.myAuthLabel.getPreferredSize().width));
            this.myAuthPanel.add((Component)this.myAuthComboBox, UrlPropertiesPanel.createAlignedConstraints(0, 1, 5, 10));
        }
        if (this.myWidget != null) {
            this.myAuthPanel.add((Component)this.myWidget.getComponent(), UrlPropertiesPanel.createSimpleConstraints(rowCount - 1, 0, 6));
        }
        this.myAuthPanel.revalidate();
        this.myAuthPanel.repaint();
    }

    public void save(@NotNull LocalDataSource dataSource2, boolean copyCredentials) {
        DatabaseAuthProvider item;
        if (dataSource2 == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(4);
        }
        dataSource2.setAuthProviderId(((item = (DatabaseAuthProvider)this.myAuthComboBox.getSelectedItem()) == null ? DatabaseAuthProvider.getDefault(dataSource2) : item).getId());
        if (this.myWidget != null) {
            this.myWidget.save(dataSource2, copyCredentials);
        }
    }

    public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
        if (dataSource2 == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(5);
        }
        this.myAccumulator.deserialize(this.myProject, new StringReader(dataSource2.copySettings(this.myProject).toString()));
        this.validateAuthTypes(dataSource2);
        this.myAuthComboBox.setSelectedItem((Object)this.getAuthProvider(dataSource2));
        if (this.myWidget != null) {
            this.myWidget.reset(dataSource2, resetCredentials);
        }
    }

    @NotNull
    protected DatabaseAuthProvider getAuthProvider(@NotNull LocalDataSource dataSource2) {
        DatabaseAuthProvider item;
        if (dataSource2 == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(6);
        }
        DatabaseAuthProvider databaseAuthProvider = (item = DatabaseAuthProvider.get(dataSource2.getAuthProviderId())) == null ? DatabaseAuthProvider.getDefault(dataSource2) : item;
        if (databaseAuthProvider == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(7);
        }
        return databaseAuthProvider;
    }

    public void validateAuthTypes(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(8);
        }
        List<DatabaseAuthProvider> applicable = DatabaseAuthProvider.getApplicable(dataSource2);
        DatabaseAuthProvider sel = (DatabaseAuthProvider)this.myAuthComboBox.getSelectedItem();
        this.myAuthComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(applicable, (Object)sel));
        if (!applicable.contains(sel)) {
            this.myAuthComboBox.setSelectedItem((Object)DatabaseAuthProvider.getDefault(dataSource2));
        }
        this.validateAuthPanel();
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.myWidget;
    }

    public boolean isNeeded() {
        return this.myAuthComboBox.getItemCount() > 1 || this.myWidget != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyAuthProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAuthProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateAuthTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

