/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessTextDecompositionBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StatelessTextDecomposition
implements StatelessParametersHolder {
    private final ListChoiceNode myNode;
    private final Map<String, ParameterNode> myParameters;

    public static StatelessTextDecomposition build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns3) throws InvalidTemplateException {
        if (template == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(0);
        }
        if (patterns3 == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(1);
        }
        return new StatelessTextDecomposition(StatelessTextDecompositionBuilder.build(template, patterns3));
    }

    private StatelessTextDecomposition(@NotNull Node node) throws InvalidTemplateException {
        if (node == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(2);
        }
        this.myNode = new ListChoiceNode(node);
        this.myParameters = new LinkedHashMap<String, ParameterNode>();
        this.findParameters(this.myNode);
    }

    public ListChoiceNode getNode() {
        return this.myNode;
    }

    public boolean isTextValid(@NotNull String text2) {
        if (text2 == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(3);
        }
        return this.myNode.compilePattern().matcher(text2).matches();
    }

    private void findParameters(@NotNull Node node) throws InvalidTemplateException {
        ParameterNode param;
        if (node == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(4);
        }
        if ((param = (ParameterNode)ObjectUtils.tryCast((Object)node, ParameterNode.class)) != null && param.getName() != null && null != this.myParameters.put(param.getName(), param)) {
            throw new InvalidTemplateException("Duplicate parameter: " + param.getName());
        }
        for (Node c2 : node.getChildren()) {
            this.findParameters(c2);
        }
    }

    @Override
    public boolean isParameterValueValid(@NotNull String key, @NotNull String value2) {
        ParameterNode param;
        if (key == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(6);
        }
        return (param = this.myParameters.get(key)) != null && param.compilePattern().matcher(value2).matches();
    }

    @Override
    @Nullable
    public String getParameterType(@NotNull String key) {
        ParameterNode param;
        if (key == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(7);
        }
        return (param = this.myParameters.get(key)) == null ? null : param.getType();
    }

    @Override
    @Nullable
    public String getParameterDefValue(@NotNull String key) {
        ParameterNode param;
        if (key == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(8);
        }
        return (param = this.myParameters.get(key)) == null ? null : param.getDefValue();
    }

    @Override
    @NotNull
    public Collection<String> getParameters() {
        Set<String> set = this.myParameters.keySet();
        if (set == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    @TestOnly
    public String getPattern() {
        String string = this.myNode.getPattern();
        if (string == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameterConfig(@NotNull String key) {
        ParameterNode param;
        if (key == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(11);
        }
        return (param = this.myParameters.get(key)) == null ? null : param.getConfiguration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTextValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findParameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParameterValueValid";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDefValue";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidTemplateException
    extends Exception {
        public InvalidTemplateException(@NotNull String msg) {
            if (msg == null) {
                InvalidTemplateException.$$$reportNull$$$0(0);
            }
            super(msg);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$InvalidTemplateException", "<init>"));
        }
    }

    public static final class FollowBuilder {
        Map<Node, Set<String>> myFirsts;
        Map<Node, Set<String>> myFollows;
        Map<Node, Boolean> myCanBeEmpty;

        public static void buildFollow(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(0);
            }
            new FollowBuilder(node);
        }

        private FollowBuilder(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(1);
            }
            this.myFirsts = new HashMap<Node, Set<String>>();
            this.myFollows = new HashMap<Node, Set<String>>();
            this.myCanBeEmpty = new HashMap<Node, Boolean>();
            this.addFollow(node, Collections.singleton("$"));
            this.collectChildFollows(node);
            this.assignIncrementalPatterns(node);
        }

        public boolean assignIncrementalPatterns(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(2);
            }
            boolean greedyRecover = false;
            for (Node c2 : node.getChildren()) {
                greedyRecover = this.assignIncrementalPatterns(c2);
            }
            greedyRecover |= node instanceof ListNode;
            PatternBuilder lookahead = PatternBuilder.build("");
            boolean first2 = true;
            Set<String> follow = this.getFollow(node);
            for (String s2 : follow) {
                if (!first2) {
                    lookahead.append("|");
                } else {
                    first2 = false;
                }
                lookahead.append(s2);
            }
            lookahead.positiveLookahead();
            PatternBuilder incremental = PatternBuilder.build(node.getPattern()).group();
            if (!(node instanceof TextNode)) {
                incremental.append(lookahead);
            }
            node.setIncrementalPattern(incremental.toString());
            String recover = greedyRecover ? ".*" : ".*?";
            node.setRecoverPattern(PatternBuilder.build(recover).group().append(lookahead).toString());
            return greedyRecover;
        }

        public void collectChildFollows(@NotNull Node parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(3);
            }
            if (parent2.getClass() == CompositeNode.class) {
                this.collectChildFollows((CompositeNode)parent2);
            } else if (parent2.getClass() == OptionalNode.class) {
                this.collectChildFollows((OptionalNode)parent2);
            } else if (parent2.getClass() == ParameterNode.class) {
                this.collectChildFollows((ParameterNode)parent2);
            } else if (parent2.getClass() == TextNode.class) {
                this.collectChildFollows((TextNode)parent2);
            } else if (parent2.getClass() == ListChoicesNode.class) {
                this.collectChildFollows((ListChoicesNode)parent2);
            } else if (parent2.getClass() == ListChoiceNode.class) {
                this.collectChildFollows((ListChoiceNode)parent2);
            } else if (parent2.getClass() == ListNode.class) {
                this.collectChildFollows((ListNode)parent2);
            } else if (parent2.getClass() == AntiNode.class) {
                this.collectChildFollows((AntiNode)parent2);
            } else assert (false);
        }

        public void collectChildFollows(@NotNull AntiNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(4);
            }
            this.addFollow(parent2.getChildren()[0], this.getFollow(parent2));
            this.collectChildFollows(parent2.getChildren()[0]);
            Set<String> filter2 = this.getFirst(parent2.getChildren()[0]);
            this.setCanBeEmpty(parent2, true);
            this.filterFirst(parent2, filter2);
            this.filterFollow(parent2, filter2);
        }

        public void collectChildFollows(@NotNull ParameterNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(5);
            }
            this.setCanBeEmpty(parent2, parent2.compilePattern().matcher("").matches());
            this.addFirst(parent2, Collections.singleton(parent2.getPattern()));
        }

        public void collectChildFollows(@NotNull ListChoiceNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(6);
            }
            Node node = parent2.getChildren()[0];
            this.addFollow(node, this.getFollow(parent2));
            this.collectChildFollows(node);
            this.setCanBeEmpty(parent2, this.canBeEmpty(node));
            this.addFirst(parent2, this.getFirst(node));
        }

        public void collectChildFollows(@NotNull TextNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(7);
            }
            this.setCanBeEmpty(parent2, StringUtil.isEmpty((String)parent2.getText()));
            this.addFirst(parent2, Collections.singleton(parent2.getPattern()));
        }

        public void collectChildFollows(@NotNull OptionalNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(8);
            }
            this.addFollow(parent2.getChildren()[0], this.getFollow(parent2));
            this.collectChildFollows(parent2.getChildren()[0]);
            this.setCanBeEmpty(parent2, true);
            this.addFirst(parent2, this.getFirst(parent2.getChildren()[0]));
        }

        public void collectChildFollows(@NotNull ListChoicesNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(9);
            }
            Node[] children2 = parent2.getChildren();
            for (int i2 = children2.length - 1; i2 >= 0; --i2) {
                Node node = children2[i2];
                this.addFollow(node, this.getFollow(parent2));
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = false;
            for (Node child : children2) {
                this.addFirst(parent2, this.getFirst(child));
                if (canBeEmpty || !this.canBeEmpty(child)) continue;
                canBeEmpty = true;
            }
            this.setCanBeEmpty(parent2, canBeEmpty);
        }

        public void collectChildFollows(@NotNull ListNode parent2) {
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(10);
            }
            this.addFollow(parent2.getChoice(), Collections.singleton(Pattern.quote(parent2.getSeparator())));
            this.addFollow(parent2.getChoice(), Collections.singleton("$"));
            this.collectChildFollows(parent2.getChoice());
            this.setCanBeEmpty(parent2, this.canBeEmpty(parent2.getChoice()));
            this.addFirst(parent2, this.getFirst(parent2.getChoice()));
        }

        public void collectChildFollows(@NotNull CompositeNode parent2) {
            Node[] children2;
            if (parent2 == null) {
                FollowBuilder.$$$reportNull$$$0(11);
            }
            if ((children2 = parent2.getChildren()).length != 0) {
                Node last = children2[children2.length - 1];
                this.addFollow(last, this.getFollow(parent2));
                this.collectChildFollows(last);
            }
            for (int i2 = children2.length - 2; i2 >= 0; --i2) {
                Node node = children2[i2];
                Node next = children2[i2 + 1];
                this.addFollow(node, this.getFirst(next));
                if (this.canBeEmpty(next)) {
                    this.addFollow(node, this.getFollow(next));
                }
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = true;
            for (Node child : children2) {
                this.addFirst(parent2, this.getFirst(child));
                if (this.canBeEmpty(child)) continue;
                canBeEmpty = false;
                break;
            }
            this.setCanBeEmpty(parent2, canBeEmpty);
        }

        private void addFirst(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(12);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(13);
            }
            FollowBuilder.addToMap(this.myFirsts, node, add);
        }

        private void filterFirst(@NotNull Node node, @NotNull Collection<String> filter2) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(14);
            }
            if (filter2 == null) {
                FollowBuilder.$$$reportNull$$$0(15);
            }
            FollowBuilder.filterMap(this.myFirsts, node, filter2);
        }

        private void addFollow(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(16);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(17);
            }
            FollowBuilder.addToMap(this.myFollows, node, add);
        }

        private void filterFollow(@NotNull Node node, @NotNull Collection<String> filter2) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(18);
            }
            if (filter2 == null) {
                FollowBuilder.$$$reportNull$$$0(19);
            }
            FollowBuilder.filterMap(this.myFollows, node, filter2);
        }

        @NotNull
        private Set<String> getFirst(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(20);
            }
            Set<String> set = Objects.requireNonNull(this.myFirsts.get(node));
            if (set == null) {
                FollowBuilder.$$$reportNull$$$0(21);
            }
            return set;
        }

        @NotNull
        private Set<String> getFollow(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(22);
            }
            Set<String> set = Objects.requireNonNull(this.myFollows.get(node));
            if (set == null) {
                FollowBuilder.$$$reportNull$$$0(23);
            }
            return set;
        }

        private void setCanBeEmpty(@NotNull Node node, boolean can) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(24);
            }
            this.myCanBeEmpty.put(node, can);
        }

        private boolean canBeEmpty(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(25);
            }
            return this.myCanBeEmpty.get(node);
        }

        private static void addToMap(@NotNull Map<Node, Set<String>> map2, @NotNull Node node, @NotNull Collection<String> add) {
            Set<String> subset;
            if (map2 == null) {
                FollowBuilder.$$$reportNull$$$0(26);
            }
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(27);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(28);
            }
            if ((subset = map2.get(node)) == null) {
                subset = new HashSet<String>();
                map2.put(node, subset);
            }
            subset.addAll(add);
        }

        private static void filterMap(@NotNull Map<Node, Set<String>> map2, @NotNull Node node, @NotNull Collection<String> filter2) {
            Set<String> subset;
            if (map2 == null) {
                FollowBuilder.$$$reportNull$$$0(29);
            }
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(30);
            }
            if (filter2 == null) {
                FollowBuilder.$$$reportNull$$$0(31);
            }
            if ((subset = map2.get(node)) == null) {
                subset = new HashSet<String>();
                map2.put(node, subset);
            }
            subset.removeAll(filter2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 21: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 21: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 13: 
                case 17: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "add";
                    break;
                }
                case 15: 
                case 19: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder";
                    break;
                }
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirst";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFollow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFollow";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "assignIncrementalPatterns";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "collectChildFollows";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addFirst";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFirst";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addFollow";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFollow";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getFirst";
                    break;
                }
                case 21: 
                case 23: {
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getFollow";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "setCanBeEmpty";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEmpty";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "addToMap";
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "filterMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 21: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ListNode
    extends Node {
        private final String mySeparator;

        public ListNode(@NotNull ListChoicesNode choice, @NotNull String separator) {
            if (choice == null) {
                ListNode.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                ListNode.$$$reportNull$$$0(1);
            }
            super(new Node[]{choice}, ListNode.createPattern(choice.getPattern(), separator), 2 * PatternBuilder.countGroups(choice.getPattern()) + 1, false);
            this.mySeparator = separator;
        }

        @NotNull
        public String getSeparator() {
            String string = this.mySeparator;
            if (string == null) {
                ListNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public ListChoicesNode getChoice() {
            ListChoicesNode listChoicesNode = (ListChoicesNode)this.getChildren()[0];
            if (listChoicesNode == null) {
                ListNode.$$$reportNull$$$0(3);
            }
            return listChoicesNode;
        }

        private static String createPattern(@NotNull String p2, @NotNull String sep) {
            if (p2 == null) {
                ListNode.$$$reportNull$$$0(4);
            }
            if (sep == null) {
                ListNode.$$$reportNull$$$0(5);
            }
            return PatternBuilder.build(p2).group().push().append(sep).quote().push().append(p2).group().pop().group().any().pop().matchingGroup().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "choice";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChoice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createPattern";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ListChoicesNode
    extends Node {
        public ListChoicesNode(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(0);
            }
            super(choices, ListChoicesNode.createPattern(choices), ListChoicesNode.countGroups(choices), false);
        }

        private static String createPattern(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(1);
            }
            PatternBuilder b2 = PatternBuilder.build("");
            boolean first2 = true;
            for (ListChoiceNode choice : choices) {
                if (!first2) {
                    b2.append("|");
                } else {
                    first2 = false;
                }
                b2.append(choice.getPattern());
            }
            return b2.toString();
        }

        private static int countGroups(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(2);
            }
            int g = 0;
            for (ListChoiceNode choice : choices) {
                g += choice.getContainingGroups();
            }
            return g;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "choices";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoicesNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ListChoiceNode
    extends Node {
        public ListChoiceNode(@NotNull Node child) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, ListChoiceNode.createPattern(child), ListChoiceNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups() + (child instanceof OptionalNode ? 1 : 0);
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(2);
            }
            PatternBuilder builder = PatternBuilder.build(child.getPattern());
            if (child instanceof OptionalNode) {
                builder.matchingGroup();
            }
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoiceNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CompositeNode
    extends Node {
        public CompositeNode(@NotNull Node[] children2) {
            if (children2 == null) {
                CompositeNode.$$$reportNull$$$0(0);
            }
            super(children2, CompositeNode.createPattern(children2), CompositeNode.countGroups(children2), CompositeNode.allEarlyMatchable(children2));
        }

        private static String createPattern(@NotNull Node[] children2) {
            if (children2 == null) {
                CompositeNode.$$$reportNull$$$0(1);
            }
            PatternBuilder b2 = PatternBuilder.build("");
            for (Node child : children2) {
                b2.append(child.getPattern());
            }
            return b2.matchingGroup().toString();
        }

        private static boolean allEarlyMatchable(@NotNull Node[] children2) {
            if (children2 == null) {
                CompositeNode.$$$reportNull$$$0(2);
            }
            boolean earlyMatchable = true;
            for (Node child : children2) {
                earlyMatchable &= child.isEarlyMatchable();
            }
            return earlyMatchable;
        }

        private static int countGroups(@NotNull Node[] children2) {
            if (children2 == null) {
                CompositeNode.$$$reportNull$$$0(3);
            }
            int g = 0;
            for (Node child : children2) {
                g += PatternBuilder.countGroups(child.getPattern());
            }
            return g + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "children";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "allEarlyMatchable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OptionalNode
    extends Node {
        public OptionalNode(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, OptionalNode.createPattern(child), OptionalNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(2);
            }
            return PatternBuilder.build(child.getPattern()).opt().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$OptionalNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ParameterNode
    extends Node {
        private final String myName;
        private final String myType;
        private final String myDefValue;
        private final String myConfiguration;

        public ParameterNode(@Nullable String name, @NotNull String type, @Nullable String defValue, @Nullable String configuration, @NotNull Pattern pattern) {
            if (type == null) {
                ParameterNode.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                ParameterNode.$$$reportNull$$$0(1);
            }
            super(NO_CHILDREN, PatternBuilder.build(pattern).matchingGroup().toString(), PatternBuilder.countGroups(pattern) + 1, true);
            this.myName = name;
            this.myType = type;
            this.myDefValue = defValue;
            this.myConfiguration = configuration;
        }

        @NotNull
        public String getType() {
            String string = this.myType;
            if (string == null) {
                ParameterNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getDefValue() {
            return this.myDefValue;
        }

        @Nullable
        public String getConfiguration() {
            return this.myConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AntiNode
    extends Node {
        public AntiNode(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, AntiNode.createPattern(child), AntiNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(2);
            }
            return PatternBuilder.build(child.getPattern()).negativeLookahead().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$AntiNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextNode
    extends Node {
        private final String myText;

        public TextNode(@NotNull String text2) {
            if (text2 == null) {
                TextNode.$$$reportNull$$$0(0);
            }
            super(NO_CHILDREN, PatternBuilder.build(text2).quote().matchingGroup().toString(), 1, true);
            this.myText = text2;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                TextNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Node {
        protected static final Node[] NO_CHILDREN = new Node[0];
        private final Node[] children;
        private final String myPattern;
        private String myIncrementalPattern;
        private String myRecoverPattern;
        private final int myContainingGroups;
        private final boolean myEarlyMatchable;

        public Node(@NotNull Node[] children2, @NotNull String pattern, int groups, boolean earlyMatchable) {
            if (pattern == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.children = children2;
            this.myPattern = pattern;
            this.myContainingGroups = groups;
            this.myEarlyMatchable = earlyMatchable;
        }

        public boolean isEarlyMatchable() {
            return this.myEarlyMatchable;
        }

        @NotNull
        public Node[] getChildren() {
            if (this.children == null) {
                Node.$$$reportNull$$$0(2);
            }
            return this.children;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Pattern compilePattern() {
            Pattern pattern = PatternBuilder.compile(this.getPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(4);
            }
            return pattern;
        }

        @NotNull
        public String getIncrementalPattern() {
            String string = this.myIncrementalPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(5);
            }
            return string;
        }

        public int getContainingGroups() {
            return this.myContainingGroups;
        }

        private void setIncrementalPattern(String incrementalPattern) {
            this.myIncrementalPattern = incrementalPattern;
        }

        @NotNull
        public String getRecoverPattern() {
            String string = this.myRecoverPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public Pattern compileIncrementalPattern() {
            Pattern pattern = PatternBuilder.compile(this.getIncrementalPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(7);
            }
            return pattern;
        }

        @NotNull
        public Pattern compileRecoverPattern() {
            Pattern pattern = PatternBuilder.compile(this.getRecoverPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(8);
            }
            return pattern;
        }

        private void setRecoverPattern(String recoverPattern) {
            this.myRecoverPattern = recoverPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compilePattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncrementalPattern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecoverPattern";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compileIncrementalPattern";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compileRecoverPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum NodeType {
            TEXT,
            OPTIONAL,
            COMPOSITE,
            PARAMETER,
            PROPERTIES;

        }
    }
}

