/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModificationSession;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbSrcModelStorage
implements ModelTextStorage {
    private static final Logger LOG = Logger.getInstance(DbSrcModelStorage.class);
    private static boolean ourCheckStorage = true;
    private final DbSrcStorage myStorage;
    @Nullable
    private final Project myProject;
    private volatile DbSrcModificationSession myModSession;
    private final Alarm myInvalidUsageReporter;
    public static final ModelFactory DUMB_FACTORY = new ModelFactory(BlackHoleTextStorage.INSTANCE);
    private static final int MESSAGE_DELAY = 500;

    private DbSrcModelStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcModelStorage.$$$reportNull$$$0(0);
        }
        this.myStorage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
        this.myProject = project;
        this.myInvalidUsageReporter = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
    }

    @NotNull
    public GuardedRef<?> startWriteSession(@Nullable Project currentProject, final @NotNull BasicModel model, @NotNull ModalityState modality, final boolean asyncRefresh) {
        DbSrcModificationSession session2;
        if (model == null) {
            DbSrcModelStorage.$$$reportNull$$$0(1);
        }
        if (modality == null) {
            DbSrcModelStorage.$$$reportNull$$$0(2);
        }
        this.checkRegistered();
        DbSrcModificationSession prev = this.myModSession;
        if (prev != null) {
            LOG.error("Parallel storage modification prevented");
            throw new ProcessCanceledException();
        }
        this.myModSession = session2 = new DbSrcModificationSession((Project)ObjectUtils.chooseNotNull((Object)this.myProject, (Object)currentProject), this.myProject == null, this.myStorage, modality);
        return new GuardedRef<DbSrcModificationSession>(session2){

            @Override
            protected void close(@NotNull DbSrcModificationSession ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    session2.regenSources((BasicModModel)model);
                    session2.waitForWriteFinished(asyncRefresh);
                }
                finally {
                    if (session2 == DbSrcModelStorage.this.myModSession) {
                        DbSrcModelStorage.this.myModSession = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage$1", "close"));
            }
        };
    }

    private void checkRegistered() {
        if (!ApplicationManager.getApplication().isUnitTestMode() || !ourCheckStorage) {
            return;
        }
        LocalDataSource dataSource2 = DbSrcUtils.findDataSource(this.myProject, this.myStorage.getDataSourceId());
        if (dataSource2 == null) {
            LOG.error("Data source " + this.myStorage.getDataSourceId() + " is not in storage. There would be no dialect...");
        }
    }

    @Nullable
    private DbSrcModificationSession getModSession() {
        LOG.assertTrue(this.myModSession != null, (Object)"Session not started");
        return this.myModSession;
    }

    @Override
    public void save(@NotNull BasicSourceAware element2, @Nullable CompositeText text2) {
        DbSrcModificationSession session2;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(3);
        }
        if ((session2 = this.getModSession()) != null) {
            session2.save(element2, text2);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element2) {
        DbSrcModificationSession session2;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(4);
        }
        if ((session2 = this.getModSession()) != null) {
            session2.queueDelete(element2);
        }
    }

    @Override
    public void flushQueues() {
        DbSrcModificationSession session2 = this.myModSession;
        if (session2 == null) {
            return;
        }
        session2.beginWrite();
        session2.endWrite();
    }

    @Override
    public void handleRename(@NotNull BasicElement e, @NotNull String oldName) {
        DbSrcModificationSession session2;
        if (e == null) {
            DbSrcModelStorage.$$$reportNull$$$0(5);
        }
        if (oldName == null) {
            DbSrcModelStorage.$$$reportNull$$$0(6);
        }
        if ((session2 = this.getModSession()) != null) {
            session2.queueRename(e, oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSession(@NotNull BasicModModel model, @NotNull Runnable runnable) {
        DbSrcModificationSession session2;
        if (model == null) {
            DbSrcModelStorage.$$$reportNull$$$0(7);
        }
        if (runnable == null) {
            DbSrcModelStorage.$$$reportNull$$$0(8);
        }
        if ((session2 = this.getModSession()) != null) {
            session2.beginWrite();
            try {
                runnable.run();
            }
            finally {
                session2.endWrite();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element2) {
        DbSrcModificationSession session2;
        CompositeText src;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(9);
        }
        CompositeText compositeText = src = (session2 = this.myModSession) == null ? null : session2.getTmpSource(element2);
        if (src != null) {
            return src;
        }
        return this.inspectAndGetSources(element2, session2);
    }

    @Nullable
    private CompositeText inspectAndGetSources(@NotNull BasicSourceAware element2, DbSrcModificationSession session2) {
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(10);
        }
        ObjectPath srcPath = ObjectPaths.of(element2, (CasingProvider)element2.getModel());
        String text2 = this.getOriginalContent(srcPath, session2 != null);
        DbSrcStorageDsMetadata.MetaData md = this.myStorage.getMetaData(srcPath);
        if (session2 == null) {
            this.inspect(element2, text2, md);
        }
        if (text2 == null) {
            return null;
        }
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText((CharSequence)text2, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text2, md.offsets, md.kinds, null);
    }

    private void inspect(@NotNull BasicSourceAware element2, String text2, DbSrcStorageDsMetadata.MetaData md) {
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            if (element2.getSourceTextLength() != 0) {
                this.markAsInvalid(element2);
                this.queueInvalidSourceUsageReport(element2);
            }
        } else if (DbSrcModelStorage.isOutdated(element2, md)) {
            this.markAsInvalid(element2);
            this.queueInvalidSourceUsageReport(element2);
        }
    }

    private void markAsInvalid(@NotNull BasicSourceAware element2) {
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(12);
        }
        try {
            ObjectPath srcPath = ObjectPaths.of(element2, (CasingProvider)element2.getModel());
            while (srcPath != null) {
                DbSrcStorageDsMetadata.MetaData md = this.myStorage.getMetaData(srcPath);
                if (md != null && md.srcVersion != null) {
                    this.myStorage.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(md, null));
                }
                srcPath = srcPath.parent;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean isOutdated(@NotNull BasicSourceAware element2, DbSrcStorageDsMetadata.MetaData md) {
        BasicModel model;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(13);
        }
        Dbms rdbms = (model = element2.getModel()) == null ? Dbms.UNKNOWN : model.getDbms();
        return md != null && md.introContentVersion != DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(rdbms, element2.getKind());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalContent(ObjectPath srcPath, boolean forceLoad) {
        if (!forceLoad) {
            DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
            VirtualFile file = fs.findFileByPath(DbSrcFileSystem.getPathFromNormalized(this.myProject, this.myStorage.getDataSourceId(), srcPath, (DbSrcFileSystem.ItemTypeOrFolder)DbSrcFileSystem.ItemType.SRC));
            VirtualFile virtualFile = file = file == null ? null : fs.getBaseFile(file, false);
            if (file != null) {
                return DbSrcFileStatus.Companion.getContent(file, false);
            }
        }
        try (InputStream is = this.myStorage.getContentInputStream(srcPath, DbSrcFileSystem.ItemType.ORIG);){
            String string;
            if (is == null) {
                string = null;
                return string;
            }
            string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)));
            return string;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element2) {
        ObjectPath srcPath;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(14);
        }
        return this.myStorage.getSrcAttributes(srcPath = ObjectPaths.of(element2), DbSrcFileSystem.ItemType.ORIG, true) != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement element2) {
        ObjectPath srcPath;
        DbSrcStorageDsMetadata.MetaData data;
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(15);
        }
        return (data = this.myStorage.getMetaData(srcPath = ObjectPaths.of(element2))) == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement element2, Long version) {
        if (element2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(16);
        }
        ObjectPath srcPath = ObjectPaths.of(element2);
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        try {
            this.myStorage.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(17);
        }
        return DbSrcModelStorage.createFactory(dataSource2.isGlobal() ? null : project, dataSource2.getUniqueId());
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        if (dataSourceId == null) {
            ModelFactory modelFactory = DUMB_FACTORY;
            if (modelFactory == null) {
                DbSrcModelStorage.$$$reportNull$$$0(18);
            }
            return modelFactory;
        }
        return new ModelFactory(DbSrcModelStorage.createStorage(project, dataSourceId));
    }

    @NotNull
    public static DbSrcModelStorage createStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcModelStorage.$$$reportNull$$$0(19);
        }
        return new DbSrcModelStorage(project, dataSourceId);
    }

    private void queueInvalidSourceUsageReport(@NotNull BasicSourceAware object) {
        if (object == null) {
            DbSrcModelStorage.$$$reportNull$$$0(20);
        }
        if (!DbSrcValidator.isEnabled()) {
            return;
        }
        this.myInvalidUsageReporter.cancelAllRequests();
        this.myInvalidUsageReporter.addRequest(this::reportInvalidSourceUsage, 500);
    }

    private void reportInvalidSourceUsage() {
        Project project;
        LocalDataSource dataSource2 = DbSrcUtils.findDataSource(this.myProject, this.myStorage.getDataSourceId());
        if (dataSource2 == null) {
            return;
        }
        Project project2 = project = this.myProject == null ? DbImplUtil.getAnyProject() : this.myProject;
        if (project == null) {
            return;
        }
        DbSrcValidator.suggestIntrospecting(project, Collections.singletonList(dataSource2));
    }

    @TestOnly
    public static void doNotCheckStorage(@NotNull Disposable d2) {
        if (d2 == null) {
            DbSrcModelStorage.$$$reportNull$$$0(21);
        }
        ourCheckStorage = false;
        Disposer.register((Disposable)d2, () -> {
            ourCheckStorage = true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startWriteSession";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeSession";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inspectAndGetSources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markAsInvalid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isOutdated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasExistingSources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFactory";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createStorage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "queueInvalidSourceUsageReport";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doNotCheckStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

