/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.ObjectPath;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DbSrcChangesTracker
implements Disposable {
    public static final VcsRevisionNumber LOCAL = VcsRevisionNumber.NULL;
    public static final VcsRevisionNumber REMOTE = new TextRevisionNumber("Remote");
    public static final VcsRevisionNumber BEFORE = new TextRevisionNumber("Before");
    protected final Map<String, DbSrcChangeList> myChangeLists = new HashMap<String, DbSrcChangeList>();
    private final EventDispatcher<ModificationTrackerListener<DbSrcChangesTracker>> myDispatcher = DataSourceUiUtil.eventDispatcher(ModificationTrackerListener.class);
    protected final Project myProject;

    @NotNull
    public static DbSrcChangesTracker getInstance(@Nullable Project project) {
        DbSrcChangesTracker dbSrcChangesTracker = project == null ? (DbSrcChangesTracker)ApplicationManager.getApplication().getService(App.class) : (DbSrcChangesTracker)ServiceManager.getService((Project)project, Prj.class);
        if (dbSrcChangesTracker == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(0);
        }
        return dbSrcChangesTracker;
    }

    public DbSrcChangesTracker(@Nullable Project project) {
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public abstract DbSrcFileStatus getFileStatus();

    public boolean isDisposed() {
        return this.myProject != null ? this.myProject.isDisposed() : ApplicationManager.getApplication().isDisposed();
    }

    public void addListener(@NotNull ModificationTrackerListener<DbSrcChangesTracker> listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener(listener2, parent2);
    }

    protected void invokeLater(@NotNull Runnable r) {
        if (r == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(3);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(r, this.myProject == null ? app.getDisposed() : this.myProject.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DbSrcChangeList> getChangeLists() {
        ArrayList<DbSrcChangeList> changeLists;
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            changeLists = new ArrayList<DbSrcChangeList>(this.myChangeLists.values());
        }
        if (this.myProject != null) {
            changeLists.addAll(DbSrcChangesTracker.getInstance(null).getChangeLists());
        }
        ArrayList<DbSrcChangeList> arrayList = changeLists;
        if (arrayList == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DbSrcChangeList getChangeList(@NotNull String dataSource2) {
        if (dataSource2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(5);
        }
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            return this.myChangeLists.get(dataSource2);
        }
    }

    @Nullable
    public static Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(6);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return null;
        }
        DbSrcChangeList list = DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<DbSrcChangeList>(){

            @Override
            public DbSrcChangeList processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystem.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                return type != DbSrcFileSystem.ItemType.SRC ? null : DbSrcChangesTracker.getInstance(project).getChangeList(dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            return null;
        }
        for (Change change : list.getChanges()) {
            DbContentRevision rev = (DbContentRevision)((Object)ObjectUtils.tryCast((Object)change.getAfterRevision(), DbContentRevision.class));
            if (rev == null || !file.equals(rev.getVirtualFile())) continue;
            return change;
        }
        return null;
    }

    @TestOnly
    public static boolean isChanged(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(7);
        }
        ((App)ApplicationManager.getApplication().getService(App.class)).distributeUpdates(Collections.singletonList(file));
        return DbSrcChangesTracker.getChange(file) != null;
    }

    public static void flushAndUpdateFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            FileDocumentManager docManager = FileDocumentManager.getInstance();
            for (VirtualFile file : files) {
                Document document = docManager.getDocument(file);
                if (document != null) {
                    docManager.saveDocument(document);
                }
                DbSrcFileSystem.getInstance().getBaseFile(file, false, true);
            }
        });
        ((App)ApplicationManager.getApplication().getService(App.class)).distributeUpdates(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(9);
        }
        if (!files.isEmpty()) {
            HashMap changeLists = new HashMap();
            MultiMap byDataSource = MultiMap.createLinkedSet();
            Map<String, DbSrcChangeList> map2 = this.myChangeLists;
            synchronized (map2) {
                this.myChangeLists.forEach((key, value2) -> changeLists.put(key, value2));
            }
            DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
            for (VirtualFile file : files) {
                if (DbSrcChangesTracker.addByDataSource((MultiMap<String, VirtualFile>)byDataSource, dbFs, file)) continue;
                for (VirtualFile child : file.getChildren()) {
                    DbSrcChangesTracker.addByDataSource((MultiMap<String, VirtualFile>)byDataSource, dbFs, child);
                }
            }
            for (Map.Entry entry : byDataSource.entrySet()) {
                DbSrcChangeList list = (DbSrcChangeList)changeLists.get(entry.getKey());
                if (list == null) continue;
                list.updateChanges((Iterable)entry.getValue());
            }
        }
        if (this.myProject != null) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
        ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
    }

    private static boolean addByDataSource(MultiMap<String, VirtualFile> byDataSource, DbSrcFileSystem dbFs, VirtualFile file) {
        String ds = DbSrcUtils.getDataSource(file);
        if (ds != null) {
            VirtualFile base = dbFs.getBaseFile(file, true, false, true);
            byDataSource.putValue((Object)ds, (Object)(base == null ? file : base));
            return true;
        }
        return false;
    }

    public static void updateIndexLater(@NotNull Set<Project> projects, @Nullable Runnable extra) {
        if (projects == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(10);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            Collection<Object> toProcess = projects.contains(null) ? Arrays.asList(ProjectUtil.getOpenProjects()) : projects;
            for (Project project : toProcess) {
                if (project.isDisposed() || ProjectManagerImpl.isLight((Project)project)) continue;
                ((Prj)ServiceManager.getService((Project)project, Prj.class)).updateIndex();
            }
            if (extra != null) {
                extra.run();
            }
        }, app.getDisposed());
    }

    public static DbSrcFileStatus getFileStatuses() {
        return DbSrcChangesTracker.getInstance(null).getFileStatus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "flushAndUpdateFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateIndexLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbSrcDiffRequestProvider
    implements ChangeDiffRequestProvider {
        @NotNull
        public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
            if (change1 == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(0);
            }
            if (change2 == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(1);
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(2);
            }
            return threeState;
        }

        public boolean canCreate(@Nullable Project project, @NotNull Change change) {
            if (change == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(3);
            }
            return change instanceof DbConflictChange;
        }

        @NotNull
        public DiffRequest process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            if (presentable == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(4);
            }
            if (context == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(6);
            }
            Project project = presentable.getProject();
            DbConflictChange change = (DbConflictChange)presentable.getChange();
            FilePath file = change.getAfterRevision() == null ? null : change.getAfterRevision().getFile();
            ContentRevision centerRevision = change.getAfterRevision();
            ContentRevision leftRevision = change.getBeforeRevision();
            ContentRevision rightRevision = change.myDbRevision;
            SimpleDiffRequest res2 = new SimpleDiffRequest(ChangeDiffRequestProducer.getRequestTitle((Change)change), ChangeDiffRequestProducer.createContent((Project)project, (ContentRevision)leftRevision, (UserDataHolder)context, (ProgressIndicator)indicator), ChangeDiffRequestProducer.createContent((Project)project, (ContentRevision)centerRevision, (UserDataHolder)context, (ProgressIndicator)indicator), ChangeDiffRequestProducer.createContent((Project)project, (ContentRevision)rightRevision, (UserDataHolder)context, (ProgressIndicator)indicator), ChangeDiffRequestProducer.getBaseVersion(), ChangeDiffRequestProducer.getYourVersion(), ChangeDiffRequestProducer.getServerVersion());
            MergeData data = new MergeData();
            data.ORIGINAL = DbSrcDiffRequestProvider.getBytes(centerRevision);
            data.ORIGINAL_REVISION_NUMBER = centerRevision == null ? null : centerRevision.getRevisionNumber();
            data.ORIGINAL_FILE_PATH = null;
            data.LAST = DbSrcDiffRequestProvider.getBytes(rightRevision);
            data.LAST_REVISION_NUMBER = rightRevision == null ? null : rightRevision.getRevisionNumber();
            data.LAST_FILE_PATH = file;
            data.CURRENT = DbSrcDiffRequestProvider.getBytes(leftRevision);
            data.CURRENT_REVISION_NUMBER = leftRevision == null ? null : leftRevision.getRevisionNumber();
            data.CURRENT_FILE_PATH = null;
            MergeUtils.putRevisionInfos((DiffRequest)res2, (MergeData)data);
            SimpleDiffRequest simpleDiffRequest = res2;
            if (simpleDiffRequest == null) {
                DbSrcDiffRequestProvider.$$$reportNull$$$0(7);
            }
            return simpleDiffRequest;
        }

        private static byte[] getBytes(@Nullable ContentRevision revision) {
            byte[] bytes = null;
            if (revision != null) {
                try {
                    bytes = ((ByteBackedContentRevision)revision).getContentAsBytes();
                }
                catch (VcsException e) {
                    e.printStackTrace();
                }
            }
            return (byte[])ObjectUtils.notNull(bytes, (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change2";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcDiffRequestProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcDiffRequestProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isEquals";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquals";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreate";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDataSourceListener
    implements DataSourceStorage.Listener {
        private final DbSrcChangesTracker myTracker;

        MyDataSourceListener(@NotNull DbSrcChangesTracker tracker) {
            if (tracker == null) {
                MyDataSourceListener.$$$reportNull$$$0(0);
            }
            this.myTracker = tracker;
            for (LocalDataSource localDataSource : this.getDataSources()) {
                this.dataSourceAdded(localDataSource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MyDataSourceListener.$$$reportNull$$$0(1);
            }
            if (!this.isGlobalAccepted() && dataSource2.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource2.getUniqueId();
                if (!this.myTracker.myChangeLists.containsKey(id)) {
                    this.myTracker.myChangeLists.put(id, new DbSrcChangeList(this.myTracker.myProject, id));
                }
            }
        }

        private boolean isGlobalAccepted() {
            return this.myTracker.myProject == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MyDataSourceListener.$$$reportNull$$$0(2);
            }
            if (!this.isGlobalAccepted() && dataSource2.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource2.getUniqueId();
                this.myTracker.myChangeLists.remove(id);
            }
        }

        @NotNull
        private List<? extends LocalDataSource> getDataSources() {
            if (this.myTracker.myProject != null) {
                List<LocalDataSource> list = DataSourceStorage.getProjectStorage(this.myTracker.myProject).getDataSources();
                if (list == null) {
                    MyDataSourceListener.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
            if (list == null) {
                MyDataSourceListener.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceRemoved";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Prj
    extends DbSrcChangesTracker {
        private final Alarm myAlarm;

        public Prj(@NotNull Project project) {
            if (project == null) {
                Prj.$$$reportNull$$$0(0);
            }
            super(project);
            ((App)ApplicationManager.getApplication().getService(App.class)).validate(project);
            this.myAlarm = new Alarm((Disposable)this);
            project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceListener(this));
        }

        private void updateIndex() {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)this.myProject).queueTask(new DumbModeTask(this.myProject){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!myProject.isDisposed()) {
                            UnindexedFilesUpdater updater = new UnindexedFilesUpdater(myProject);
                            Disposer.register((Disposable)this, (Disposable)updater);
                            updater.performInDumbMode(indicator);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Prj$1", "performInDumbMode"));
                    }
                });
            }, 5000, ModalityState.NON_MODAL);
        }

        @Override
        @NotNull
        public DbSrcFileStatus getFileStatus() {
            DbSrcFileStatus dbSrcFileStatus = ((App)ApplicationManager.getApplication().getService(App.class)).getFileStatus();
            if (dbSrcFileStatus == null) {
                Prj.$$$reportNull$$$0(1);
            }
            return dbSrcFileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Prj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Prj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class App
    extends DbSrcChangesTracker {
        private final DbSrcFileStatus myFileStatus = new DbSrcFileStatus();
        private final Set<VirtualFile> myDirtyFiles = new HashSet<VirtualFile>();
        private final Alarm myAlarm = new Alarm();
        private final AtomicReference<Disposable> myAdded = new AtomicReference();
        private final DocumentListener myListener = new DocumentListener(){
            private final FileDocumentManager documentManager = FileDocumentManager.getInstance();

            public void documentChanged(@NotNull DocumentEvent event) {
                VirtualFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtils.isDbSrcFile(file = this.documentManager.getFile(event.getDocument()))) {
                    this.fileDirty(file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$1", "documentChanged"));
            }
        };

        public App() {
            super(null);
            MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    HashSet<Project> projects = new HashSet<Project>();
                    for (VFileEvent vFileEvent : events) {
                        Ref<Project> project;
                        if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                        this.fileDirty(vFileEvent.getFile());
                        if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileContentChangeEvent) || (project = DbSrcUtils.getProject(vFileEvent.getPath())) == null) continue;
                        projects.add((Project)project.get());
                    }
                    if (!projects.isEmpty()) {
                        DbSrcChangesTracker.updateIndexLater(projects, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$2", "after"));
                }
            });
            appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.ensureListenerAdded();
                }

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                        this.ensureListenerRemoved();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectOpened";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (ProjectUtil.getOpenProjects().length > 0) {
                this.ensureListenerAdded();
            }
            appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceListener(this));
            this.validate(null);
        }

        private void validate(@Nullable Project project) {
            VirtualFile root2 = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
            this.fileDirty(root2);
        }

        public void ensureListenerAdded() {
            Disposable disposable2;
            if (this.myAdded.get() == null && this.myAdded.compareAndSet(null, disposable2 = Disposer.newDisposable())) {
                Disposer.register((Disposable)this, (Disposable)disposable2);
                EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, disposable2);
            }
        }

        public void ensureListenerRemoved() {
            Disposable disposable2 = this.myAdded.getAndSet(null);
            if (disposable2 != null) {
                Disposer.dispose((Disposable)disposable2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fileDirty(@Nullable VirtualFile file) {
            if (!DbSrcUtils.isDbSrcFile(file)) {
                return;
            }
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                this.myDirtyFiles.add(file);
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this::update, 1000, ModalityState.defaultModalityState());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            ArrayList<VirtualFile> files;
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                files = new ArrayList<VirtualFile>(this.myDirtyFiles);
                this.myDirtyFiles.clear();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.distributeUpdates(files));
        }

        private void distributeUpdates(List<VirtualFile> files) {
            MultiMap byProject = MultiMap.create();
            for (VirtualFile file : files) {
                Ref<Project> p2 = DbSrcUtils.getProject(file.getPath());
                if (p2 == null) continue;
                byProject.putValue((Object)((Project)p2.get()), (Object)file);
            }
            if (byProject.containsKey(null)) {
                this.updateFiles(byProject.get(null));
                for (Iterator<Object> iterator : ProjectManager.getInstance().getOpenProjects()) {
                    DbSrcChangesTracker.getInstance(iterator).updateFiles(byProject.get(iterator));
                }
            } else {
                for (Map.Entry entry : byProject.entrySet()) {
                    if (!((Project)entry.getKey()).isOpen()) continue;
                    DbSrcChangesTracker.getInstance((Project)entry.getKey()).updateFiles((Collection)entry.getValue());
                }
            }
        }

        @Override
        @NotNull
        public DbSrcFileStatus getFileStatus() {
            DbSrcFileStatus dbSrcFileStatus = this.myFileStatus;
            if (dbSrcFileStatus == null) {
                App.$$$reportNull$$$0(0);
            }
            return dbSrcFileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App", "getFileStatus"));
        }
    }

    public static final class DbContentRevision
    extends CurrentContentRevision {
        private final VirtualFile myContent;
        private final VcsRevisionNumber myRevision;

        public DbContentRevision(@NotNull VirtualFile content, @NotNull DbFilePath file, @NotNull VcsRevisionNumber revision) {
            if (content == null) {
                DbContentRevision.$$$reportNull$$$0(0);
            }
            if (file == null) {
                DbContentRevision.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                DbContentRevision.$$$reportNull$$$0(2);
            }
            super((FilePath)file);
            this.myContent = content;
            this.myRevision = revision;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myContent;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                DbContentRevision.$$$reportNull$$$0(3);
            }
            return vcsRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbFilePath
    extends LocalFilePath {
        private final VirtualFile myFile;

        public DbFilePath(@NotNull VirtualFile file) {
            if (file == null) {
                DbFilePath.$$$reportNull$$$0(0);
            }
            super(file.getPath(), file.isDirectory());
            this.myFile = file;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbFilePath", "<init>"));
        }
    }

    public static class DbConflictChange
    extends Change {
        private final ContentRevision myDbRevision;

        public DbConflictChange(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @Nullable ContentRevision dbRevision, @Nullable FileStatus fileStatus) {
            super(beforeRevision, afterRevision, fileStatus);
            this.myDbRevision = dbRevision;
        }
    }

    public static class DbSrcChangeList
    implements ChangeList {
        private final String myDataSourceId;
        private final Project myProject;
        private volatile Map<VirtualFile, Change> myChanges;
        private String myName;

        public DbSrcChangeList(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                DbSrcChangeList.$$$reportNull$$$0(0);
            }
            this.myChanges = Collections.emptyMap();
            this.myProject = project;
            this.myDataSourceId = dataSourceId;
            this.updateName();
        }

        public Collection<Change> getChanges() {
            return this.myChanges == null ? Collections.emptyList() : this.myChanges.values();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DbSrcChangeList.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getComment() {
            return null;
        }

        private void updateName() {
            LocalDataSource source = this.getDataSource();
            this.myName = source == null ? "invalid" : source.getName();
        }

        @Nullable
        public LocalDataSource getDataSource() {
            return DbSrcUtils.findDataSource(this.myProject, this.myDataSourceId);
        }

        public void updateChanges(@NotNull Iterable<VirtualFile> files) {
            if (files == null) {
                DbSrcChangeList.$$$reportNull$$$0(2);
            }
            final DbSrcFileStatus fileStatus = DbSrcChangesTracker.getInstance(null).getFileStatus();
            Map<VirtualFile, Change> old = this.myChanges;
            final ContainerUtil.ImmutableMapBuilder newChanges = ContainerUtil.immutableMapBuilder();
            for (Map.Entry<VirtualFile, Change> entry : old.entrySet()) {
                if (fileStatus.getStatus(entry.getKey()).getStatus() == null) continue;
                newChanges.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            for (VirtualFile file : files) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        DbSrcFileStatus.StatusEntry status = fileStatus.getStatus(file);
                        if (status.getStatus() != null) {
                            DbFilePath path = new DbFilePath(file);
                            ContentRevision originalRevision = this.getContentRevision(path, status.getOriginalFileUrl(), REMOTE);
                            ContentRevision baseRevision = Objects.equals(status.getBaseFileUrl(), status.getOriginalFileUrl()) ? null : this.getContentRevision(path, status.getBaseFileUrl(), BEFORE);
                            DbContentRevision modifiedRevision = new DbContentRevision(file, path, LOCAL);
                            Change change = baseRevision == null ? new Change(originalRevision, (ContentRevision)modifiedRevision, status.getStatus()) : new DbConflictChange(baseRevision, (ContentRevision)modifiedRevision, originalRevision, status.getStatus());
                            newChanges.put((Object)file, (Object)change);
                        }
                        return true;
                    }

                    @Nullable
                    private ContentRevision getContentRevision(@NotNull DbFilePath path, @Nullable String url, @NotNull VcsRevisionNumber revision) {
                        if (path == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (revision == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        VirtualFile file = url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                        return file == null ? null : new DbContentRevision(file, path, revision);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "path";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "revision";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitFile";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getContentRevision";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            this.updateName();
            this.myChanges = newChanges.build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

