/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDataSourceManager
extends DefaultDbPsiManager {
    private static final String LRU_KEY = "DatabaseDriversLRU";
    private final DataSourceStorage myProjectStorage;

    @NotNull
    public static LocalDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(0);
        }
        LocalDataSourceManager localDataSourceManager = Objects.requireNonNull((LocalDataSourceManager)((Object)ContainerUtil.findInstance((Iterable)EP_NAME.getExtensions((AreaInstance)project), LocalDataSourceManager.class)));
        if (localDataSourceManager == null) {
            LocalDataSourceManager.$$$reportNull$$$0(1);
        }
        return localDataSourceManager;
    }

    public LocalDataSourceManager(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(2);
        }
        super(project, DataSourceStorage.getProjectStorage(project).getDataSources());
        this.myProjectStorage = DataSourceStorage.getProjectStorage(project);
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDataSourceManager.this.attachDataSource(dataSource2);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalDataSourceManager.this.detachDataSource(dataSource2);
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    LocalDataSourceManager.this.resetElementMap(LocalDataSourceManager.this.myProjectStorage.getDataSources());
                } else {
                    LocalDataSourceManager.this.updateDataSource(dataSource2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void addDataSource(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myProjectStorage.addDataSource(element2);
    }

    public void removeDataSource(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(4);
        }
        this.myProjectStorage.removeDataSource(element2);
    }

    public void renameDataSource(@NotNull LocalDataSource element2, @NotNull String name) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LocalDataSourceManager.$$$reportNull$$$0(6);
        }
        element2.setName(name);
        this.myProjectStorage.updateDataSource(element2);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(7);
        }
        return new DataSourceConfigurable(this, element2, this.myProject);
    }

    @NotNull
    public AnAction getCreateDataSourceAction(@NotNull Consumer<LocalDataSource> consumer2) {
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(8);
        }
        List<AnAction> actions = this.getCreateDataSourceActions(DatabaseDriverManager.getInstance().getDrivers(), consumer2);
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup((Supplier)DatabaseBundle.messagePointer((String)"default.datasource.name", (Object[])new Object[0]));
        group.addAll(actions);
        group.getTemplatePresentation().setIcon(DatabaseIcons.Dbms);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            LocalDataSourceManager.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public List<AnAction> getCreateDataSourceActions(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull Consumer<LocalDataSource> consumer2) {
        if (allDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(11);
        }
        List<String> lruNames = DatabaseViewActions.getLRUNames(this.myProject, LRU_KEY);
        final Function keyProvider = o -> o.isPredefined() ? LocalDataSourceManager.predefinedDriverKey(o) : o.getId();
        @NlsActions.ActionText Function displayNameProvider = LocalDataSourceManager::getDisplayDriverName;
        JBIterable drivers = JBIterable.from(allDrivers).unique(keyProvider).collect();
        Condition isPredefined = DatabaseDriver::isPredefined;
        Condition isInLRU = o -> lruNames.contains(keyProvider.fun(o));
        Comparator<DatabaseDriver> comparator2 = Comparator.comparing(arg_0 -> ((Function)displayNameProvider).fun(arg_0));
        Comparator<DatabaseDriver> lruComparator = Comparator.comparingInt(o -> lruNames.indexOf(keyProvider.fun(o))).thenComparing(o -> (String)displayNameProvider.fun(o));
        Function toAction = driver -> new DumbAwareAction((String)displayNameProvider.fun(driver), null, driver.getIcon(0), (DatabaseDriver)driver, (Consumer)consumer2){
            final /* synthetic */ DatabaseDriver val$driver;
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$driver = databaseDriver;
                this.val$consumer = consumer2;
                super(arg0, arg1, arg2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DatabaseViewActions.addToLRUNames(LocalDataSourceManager.this.myProject, 5, LocalDataSourceManager.LRU_KEY, (String)keyProvider.fun((Object)this.val$driver));
                this.val$consumer.consume((Object)this.val$driver.createDataSource(null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/LocalDataSourceManager$2", "actionPerformed"));
            }
        };
        List list = drivers.filter(isInLRU).sort(lruComparator).map(toAction).append((Object)Separator.getInstance()).append((Iterable)drivers.filter(isPredefined).filter(Conditions.not((Condition)isInLRU)).sort(comparator2).map(toAction)).append((Object)Separator.getInstance()).append((Iterable)drivers.filter(Conditions.not((Condition)isPredefined)).filter(Conditions.not((Condition)isInLRU)).sort(comparator2).map(toAction)).toList();
        if (list == null) {
            LocalDataSourceManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static String predefinedDriverKey(DatabaseDriver o) {
        String beforeDot = StringUtil.notNullize((String)StringUtil.substringBefore((String)o.getId(), (String)"."), (String)o.getId());
        return StringUtil.trimEnd((String)beforeDot, (String)"_aurora");
    }

    @NlsActions.ActionText
    @NotNull
    private static String getDisplayDriverName(DatabaseDriver o) {
        if (!o.isPredefined()) {
            String string = o.getName();
            if (string == null) {
                LocalDataSourceManager.$$$reportNull$$$0(13);
            }
            return string;
        }
        Dbms dbms = DbImplUtil.getDbms(o);
        String string = dbms == Dbms.UNKNOWN ? o.getName() : dbms.getDisplayName();
        if (string == null) {
            LocalDataSourceManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public LocalDataSource copyDataSource(@NotNull String newName, @NotNull LocalDataSource copyFrom) {
        if (newName == null) {
            LocalDataSourceManager.$$$reportNull$$$0(15);
        }
        if (copyFrom == null) {
            LocalDataSourceManager.$$$reportNull$$$0(16);
        }
        LocalDataSource result = copyFrom.copy(false);
        result.setName(StringUtil.notNullize((String)newName));
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(17);
        }
        return localDataSource;
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            LocalDataSourceManager.$$$reportNull$$$0(18);
        }
        for (VirtualFile file : files) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<LocalDataSource> createDataSourceByFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            LocalDataSourceManager.$$$reportNull$$$0(19);
        }
        final ArrayList<LocalDataSource> result = new ArrayList<LocalDataSource>();
        DataSourceRegistry registry = new DataSourceRegistry(this.myProject);
        registry.setImportedFlag(false);
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DasDataSource dataSource2) {
                if (dataSource2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                result.add((LocalDataSource)dataSource2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/LocalDataSourceManager$3", "onCreated"));
            }
        };
        for (VirtualFile file : files) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType)) continue;
            Dbms dbms = ((DbStorageFileType)fileType).getDbms();
            String defaultName = DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)file.getNameWithoutExtension());
            final String path = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
            DataSourceConfigUtil.buildDataSource(dbms, defaultName, null, null, new DataSourceConfiguration(){

                @Override
                public String getDatabase() {
                    return path;
                }
            }, registry.getBuilder().withCallback(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myProject, registry, true, true);
        DataSourceConfigUtil.refreshTablesInBackground(this.myProject, registry.getDataSources());
        ArrayList<LocalDataSource> arrayList = result;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(21);
        }
        this.myProjectStorage.updateDataSource(dataSource2);
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(22);
        }
        return DbImplUtil.guessDatabaseDialect(element2);
    }

    @Override
    @Nullable
    public Language getQueryLanguage(LocalDataSource element2) {
        return DbSqlUtil.findLanguage(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceActions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceActions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

