/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="LocalDatabaseDriverManager", storages={@Storage(value="databaseDrivers.xml")})
public class DatabaseDriverManagerImpl
extends DatabaseDriverManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverManagerImpl.class);
    private static final String VERSION_PRE_141 = null;
    private static final String VERSION_141 = "141+";
    private static final String VERSION_LATEST = "201";
    private final Map<String, DatabaseDriverImpl> myDrivers;
    private final Map<String, DatabaseDriverImpl> myPredefinedDrivers;
    private final EventDispatcher<DatabaseDriverListener> myDispatcher;
    private static final Map<String, String> MIGRATION_MAP = ContainerUtil.newHashMap((Pair)Pair.create((Object)"sqlite.zentus", (Object)"sqlite.xerial"), (Pair[])new Pair[]{Pair.create((Object)"h2.embedded", (Object)"h2.unified"), Pair.create((Object)"h2.in-memory", (Object)"h2.unified"), Pair.create((Object)"h2.remote", (Object)"h2.unified"), Pair.create((Object)"hsqldb.embedded", (Object)"hsqldb.local"), Pair.create((Object)"hsqldb.in-memory", (Object)"hsqldb.local")});
    public static final ExtensionPointName<ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.driversConfig");

    @TestOnly
    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<DatabaseDriverImpl> drivers = new ArrayList<DatabaseDriverImpl>(this.getDrivers());
        drivers.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())));
        for (DatabaseDriverImpl driver : drivers) {
            driver.dump(sb);
            sb.append("\n----\n");
        }
    }

    @TestOnly
    public static DatabaseDriverManagerImpl create(@NotNull String file) throws MalformedURLException {
        if (file == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(1);
        }
        return new DatabaseDriverManagerImpl(Collections.singletonList(Pair.create(null, (Object)new File(file).toURI().toURL())));
    }

    @TestOnly
    public static DatabaseDriverManagerImpl create(@NotNull List<ConfigUrlBean> beans) {
        if (beans == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return new DatabaseDriverManagerImpl((Iterable<Pair<PluginDescriptor, URL>>)JBIterable.from(beans).flatten(DatabaseDriverManagerImpl::extractUrls));
    }

    public DatabaseDriverManagerImpl() {
        this((Iterable<Pair<PluginDescriptor, URL>>)JBIterable.from((Iterable)CONFIG_EP.getExtensionList()).flatten(DatabaseDriverManagerImpl::extractUrls));
    }

    @NotNull
    private static JBIterable<Pair<PluginDescriptor, URL>> extractUrls(ConfigUrlBean bean) {
        JBIterable jBIterable = JBIterable.once((Iterator)ContainerUtil.iterate(ConfigUrlBean.enumerateUrls(bean))).map(url -> Pair.create((Object)bean.getPluginDescriptor(), (Object)url));
        if (jBIterable == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NonInjectable
    private DatabaseDriverManagerImpl(@NotNull Iterable<Pair<PluginDescriptor, URL>> urls) {
        if (urls == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(4);
        }
        this.myDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
        this.myPredefinedDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
        this.myDispatcher = EventDispatcher.create(DatabaseDriverListener.class);
        for (Pair<PluginDescriptor, URL> url : urls) {
            try {
                this.loadLatest(JDOMUtil.load((URL)((URL)url.getSecond())), true, true, VERSION_LATEST, (PluginDescriptor)url.getFirst());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            if (!driver.isPredefined()) continue;
            DatabaseDriverImpl backup = new DatabaseDriverImpl(driver.getId(), true);
            backup.loadState(driver.getState(null), false, true, Integer.MAX_VALUE);
            this.myPredefinedDrivers.put(backup.getId(), backup);
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.getMessageBus().connect().subscribe(DatabaseArtifactManager.TOPIC, v -> {
                ArrayList<DatabaseDriverImpl> values2 = new ArrayList<DatabaseDriverImpl>(this.myDrivers.values());
                for (DatabaseDriverImpl driver : values2) {
                    boolean affected;
                    if (driver.getArtifacts().isEmpty() || !(affected = v == null || ContainerUtil.exists(driver.getArtifacts(), a -> DatabaseDriverImpl.matches(a, v)))) continue;
                    ((DatabaseDriverListener)this.myDispatcher.getMulticaster()).driverUpdated(driver);
                }
            });
        }
    }

    @NotNull
    private DatabaseDriverImpl addDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(5);
        }
        this.myDrivers.put(driver.getId(), driver);
        ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverAdded(driver);
        DatabaseDriverImpl databaseDriverImpl = driver;
        if (databaseDriverImpl == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(6);
        }
        return databaseDriverImpl;
    }

    private void removeDriver(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(7);
        }
        if ((driver = this.myDrivers.remove(id)) != null) {
            ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverRemoved(driver);
        }
    }

    @NotNull
    private static List<Element> getDrivers(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(8);
        }
        List list = state.getChildren("driver");
        if (list == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static String getDriverId(@NotNull Element state) {
        String id;
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmpty((String)(id = state.getAttributeValue("id"))) || id.equals("odbc.sun") ? null : id;
    }

    @Nullable
    private DatabaseDriverImpl getOrCreateDriver(@NotNull String id, boolean predefined, boolean create) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(11);
        }
        if ((driver = this.myDrivers.get(id)) == null && create) {
            driver = this.addDriver(new DatabaseDriverImpl(id, predefined));
        }
        return driver;
    }

    private void loadLatest(@NotNull Element state, boolean merge, boolean predefined, String version, @Nullable PluginDescriptor descriptor2) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(12);
        }
        int ver = DatabaseDriverManagerImpl.parseVersion(version);
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = id == null ? null : this.getOrCreateDriver(id, predefined, true);
            if (driver == null) continue;
            driver.loadState(driverState, merge, true, ver, descriptor2);
        }
    }

    private static int parseVersion(String version) {
        Matcher matcher = Pattern.compile("\\d+").matcher(version);
        try {
            if (matcher.find()) {
                return Integer.parseInt(version);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    private void loadPre141(@NotNull Element state, boolean merge, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(13);
        }
        this.loadPre141Impl(state, merge, new ArrayList<Element>(), predefined);
    }

    private void loadPre141Impl(@NotNull Element state, boolean merge, @NotNull List<Element> parents2, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(14);
        }
        if (parents2 == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(15);
        }
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            boolean instantiable;
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = null;
            boolean bl = instantiable = driverState.getChild("driver") == null && !MIGRATION_MAP.containsKey(id);
            if (id != null) {
                driver = this.getOrCreateDriver(id, predefined, instantiable);
            }
            parents2.add(driverState);
            if (driver != null) {
                boolean submerge = merge;
                for (Element parent2 : parents2) {
                    driver.loadState(parent2, submerge, false, 0);
                    submerge = true;
                }
            }
            this.loadPre141Impl(driverState, merge, parents2, predefined);
            parents2.remove(parents2.size() - 1);
        }
    }

    EventDispatcher<DatabaseDriverListener> getDispatcher() {
        return this.myDispatcher;
    }

    @Nullable
    public Element getState() {
        Element result = new Element("LocalDatabaseDriverManager");
        result.setAttribute("version", VERSION_LATEST);
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            result.addContent(driver.getState(this.myPredefinedDrivers.get(driver.getId())));
        }
        return result;
    }

    public void loadState(@NotNull Element state) {
        String version;
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(16);
        }
        if (Objects.equals(version = state.getAttributeValue("version"), VERSION_PRE_141)) {
            this.loadPre141(state, true, false);
        } else {
            this.loadLatest(state, true, false, version, null);
        }
    }

    public Collection<DatabaseDriverImpl> getDrivers() {
        return Collections.unmodifiableCollection(this.myDrivers.values());
    }

    @Override
    public DatabaseDriverImpl getDriver(String id) {
        return this.myDrivers.get(StringUtil.notNullize((String)MIGRATION_MAP.get(id), (String)id));
    }

    @Override
    @NotNull
    public DatabaseDriverImpl createDriver(String name, String driverClass, UrlTemplate urlTemplate) {
        String driverId = driverClass;
        if (this.getDriver(driverId) != null) {
            driverId = null;
        }
        return new DatabaseDriverImpl(driverId, name, driverClass, urlTemplate);
    }

    @Override
    public void resetToPredefined(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(17);
        }
        DatabaseDriverImpl result = (DatabaseDriverImpl)driver;
        DatabaseDriverImpl backup = this.myPredefinedDrivers.get(driver.getId());
        ArrayList<SimpleClasspathElement> classPath = new ArrayList<SimpleClasspathElement>(result.getAdditionalClasspathElements());
        result.loadState(backup.getState(null), false, true, Integer.MAX_VALUE);
        result.setAdditionalClasspathElements(classPath);
    }

    @Override
    public boolean isInPredefinedState(@NotNull DatabaseDriver driver) {
        DatabaseDriverImpl backup;
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(18);
        }
        return (backup = this.myPredefinedDrivers.get(driver.getId())) == null || ((DatabaseDriverImpl)driver).equalConfiguration(backup, true);
    }

    @Override
    @Nullable
    public String getPredefinedArtifact(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(19);
        }
        DatabaseDriver.ArtifactRef ref = (driver = this.myPredefinedDrivers.get(id)) == null ? null : (DatabaseDriver.ArtifactRef)ContainerUtil.getFirstItem(driver.getArtifacts());
        return ref == null ? null : ref.getId();
    }

    @Override
    public void updateDriver(@NotNull DatabaseDriver driver) {
        DatabaseDriverImpl driverImpl;
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(20);
        }
        if (!this.myDrivers.containsKey((driverImpl = (DatabaseDriverImpl)driver).getId())) {
            this.addDriver(driverImpl);
        }
    }

    @Override
    public void removeDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(21);
        }
        if (this.myDrivers.containsKey(driver.getId())) {
            this.removeDriver(driver.getId());
        }
    }

    @Override
    public void addDriverListener(@NotNull DatabaseDriverListener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(22);
        }
        if (parent2 == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(23);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addDriver";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrivers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDriver";
                break;
            }
            case 7: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeDriver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDrivers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDriverId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDriver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadLatest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141Impl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetToPredefined";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInPredefinedState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedArtifact";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateDriver";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addDriverListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigUrlBean
    extends AbstractExtensionPointBean {
        @Attribute(value="config")
        public String configUrl;

        @NotNull
        public static List<URL> getUrls(@NotNull List<ConfigUrlBean> beans) {
            if (beans == null) {
                ConfigUrlBean.$$$reportNull$$$0(0);
            }
            ArrayList<URL> res2 = new ArrayList<URL>();
            for (ConfigUrlBean configBean : beans) {
                Enumeration<URL> enumeration = ConfigUrlBean.enumerateUrls(configBean);
                while (enumeration.hasMoreElements()) {
                    res2.add(enumeration.nextElement());
                }
            }
            ArrayList<URL> arrayList = res2;
            if (arrayList == null) {
                ConfigUrlBean.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @NotNull
        public static Enumeration<URL> enumerateUrls(@NotNull ConfigUrlBean configBean) {
            block7: {
                Enumeration<URL> enumeration;
                if (configBean == null) {
                    ConfigUrlBean.$$$reportNull$$$0(2);
                }
                ClassLoader loader = configBean.getLoaderForClass();
                try {
                    Enumeration<URL> enumeration2 = loader.getResources(configBean.configUrl);
                    if (enumeration2 == null || !enumeration2.hasMoreElements()) {
                        LOG.warn(configBean.getPluginId() + ": " + configBean.configUrl + " was not found");
                        break block7;
                    }
                    enumeration = enumeration2;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (enumeration == null) {
                    ConfigUrlBean.$$$reportNull$$$0(3);
                }
                return enumeration;
            }
            Enumeration<URL> enumeration = Collections.emptyEnumeration();
            if (enumeration == null) {
                ConfigUrlBean.$$$reportNull$$$0(4);
            }
            return enumeration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beans";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl$ConfigUrlBean";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl$ConfigUrlBean";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "enumerateUrls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "enumerateUrls";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

