/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDriver
extends Iconable {
    public static final Option<Boolean> OPTION_AUTO_COMMIT = new Option<Boolean>(false, "auto-commit", true);
    public static final Option<Boolean> OPTION_AUTO_SYNC = new Option<Boolean>(false, "auto-sync", true);
    public static final Option<Boolean> OPTION_FORMAT_SOURCES_ON_SYNC = new Option<Boolean>(false, "format-sources-on-sync", true);
    public static final Option<Boolean> OPTION_SEND_APP_INFO = new Option<Boolean>(false, "send-app-info", true);
    public static final Option<SchemaControl> OPTION_SCHEMA_CONTROL = new Option<SchemaControl>(false, "schema-control", SchemaControl.AUTOMATIC);
    public static final Option<DBIntrospectionOptions.SourceLoading> OPTION_SOURCE_LOADING = new Option<DBIntrospectionOptions.SourceLoading>(false, "source-loading", DBIntrospectionOptions.SourceLoading.USER_SOURCES);

    public boolean isPredefined();

    public String getId();

    @NlsSafe
    @NotNull
    public String getName();

    @Nullable
    public String getDriverClass();

    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers();

    @Nullable
    public Bounds getConnectionBounds();

    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations();

    public boolean matchesUrl(@NotNull String var1);

    @NotNull
    public String getSampleUrl();

    public String getSqlDialect();

    public Map<String, String> getDriverProperties();

    public Map<String, String> getVmEnv();

    public <T> T getOption(@NotNull Option<T> var1);

    public <T> void setOption(@NotNull Option<T> var1, T var2);

    @Nullable
    public String getVmOptions();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    default public ArtifactRef getArtifact() {
        return (ArtifactRef)ContainerUtil.getFirstItem(this.getArtifacts());
    }

    @NotNull
    public List<ArtifactRef> getArtifacts();

    public List<SimpleClasspathElement> getNativeLibraryPaths();

    public List<SimpleClasspathElement> getClasspathElements();

    public List<SimpleClasspathElement> getAdditionalClasspathElements();

    public LocalDataSource createDataSource(@Nullable String var1);

    public static enum SchemaControl {
        AUTOMATIC,
        MANUAL,
        FORBID;

    }

    public static interface ArtifactRef {
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        @NotNull
        default public String getName() {
            String string = this.getId();
            if (string == null) {
                ArtifactRef.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        @Nullable
        default public String getVersion() {
            Version version = this.getArtifactVersion();
            return version == null ? null : version.toString();
        }

        @NotNull
        public String getId();

        @Nullable
        public Version getArtifactVersion();

        public String getChannel();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriver$ArtifactRef", "getName"));
        }
    }

    public static class Bounds {
        public boolean inReadOnlyMode = false;
        @NotNull
        public ObjectKind boundTo = ObjectKind.DATABASE;
        @NotNull
        public List<Pair<String, Boolean>> rewriteParameters = new SmartList();
        @Nullable
        public String defaultValue = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            return this.inReadOnlyMode == bounds.inReadOnlyMode && this.boundTo.equals(bounds.boundTo) && this.rewriteParameters.equals(bounds.rewriteParameters) && Objects.equals(this.defaultValue, bounds.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.inReadOnlyMode, this.boundTo, this.rewriteParameters, this.defaultValue);
        }
    }

    public static class Option<T> {
        private static final Map<String, Option<?>> ourInstances = new LinkedHashMap();
        private final String myName;
        private final T myDef;
        private final boolean myFixed;

        @Nullable
        public static Option byName(String name) {
            return ourInstances.get(name);
        }

        @NotNull
        public static Collection<? extends Option<?>> enumerate() {
            Collection<Option<?>> collection = ourInstances.values();
            if (collection == null) {
                Option.$$$reportNull$$$0(0);
            }
            return collection;
        }

        Option(boolean fixed, String name, T def) {
            this.myName = name;
            this.myDef = def;
            this.myFixed = fixed;
            ourInstances.put(name, this);
        }

        public String getName() {
            return this.myName;
        }

        public T getDefault() {
            return this.myDef;
        }

        public boolean isFixed() {
            return this.myFixed;
        }

        public T get(@Nullable DatabaseDriver driver) {
            return driver != null ? driver.getOption(this) : this.myDef;
        }

        public T fromString(String value2) {
            if (value2 == null) {
                return this.myDef;
            }
            if (this.myDef instanceof String) {
                return (T)value2;
            }
            if (this.myDef instanceof Boolean) {
                return (T)Boolean.valueOf(value2);
            }
            if (this.myDef instanceof Enum) {
                return (T)Enum.valueOf(((Enum)this.myDef).getClass(), value2);
            }
            throw new AssertionError((Object)(this + "!=" + value2));
        }

        public String toString() {
            return this.myName + "(" + this.myDef + (this.myFixed ? ", fixed" : "") + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriver$Option", "enumerate"));
        }
    }
}

