/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface DatabaseAuthProvider
extends DatabaseConnectionInterceptor {
    @NonNls
    @NotNull
    public String getId();

    @Nls
    @NotNull
    public String getDisplayName();

    @Nullable
    default public AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource2) {
        if (credentials == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(1);
        }
        return this.createWidget(credentials, dataSource2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    default public AuthWidget createWidget(@NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource2) {
        if (credentials == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean isApplicable(@NotNull LocalDataSource var1);

    default public boolean isApplicableAsDefault(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(4);
        }
        return this.isApplicable(dataSource2);
    }

    default public void setNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto, String newPass) {
    }

    @Override
    @Nullable
    default public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull SQLException e, boolean silent, int attempt) {
        if (proto == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(5);
        }
        if (e == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(6);
        }
        return DatabaseCredentialsAuthProvider.handleCredentialsFailure(proto, e, silent, attempt);
    }

    @NotNull
    public static List<DatabaseAuthProvider> getApplicable(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(7);
        }
        List list = JBIterable.from((Iterable)EP_NAME.getExtensionsIfPointIsRegistered()).filter(DatabaseAuthProvider.class).filter(ap -> ap.isApplicable(dataSource2)).toList();
        if (list == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static DatabaseAuthProvider getDefault(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(9);
        }
        DatabaseAuthProvider databaseAuthProvider = (DatabaseAuthProvider)Objects.requireNonNull((DatabaseConnectionInterceptor)EP_NAME.findFirstSafe(e -> e instanceof DatabaseAuthProvider && ((DatabaseAuthProvider)e).isApplicableAsDefault(dataSource2)));
        if (databaseAuthProvider == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(10);
        }
        return databaseAuthProvider;
    }

    @Nullable
    public static DatabaseAuthProvider get(@NotNull String id) {
        if (id == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(11);
        }
        return (DatabaseAuthProvider)EP_NAME.findFirstSafe(e -> e instanceof DatabaseAuthProvider && ((DatabaseAuthProvider)e).getId().equals(id));
    }

    @NotNull
    public static DatabaseAuthProvider get(@NotNull LocalDataSource dataSource2) {
        DatabaseAuthProvider provider;
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(12);
        }
        DatabaseAuthProvider databaseAuthProvider = (provider = DatabaseAuthProvider.get(dataSource2.getAuthProviderId())) == null ? DatabaseAuthProvider.getDefault(dataSource2) : provider;
        if (databaseAuthProvider == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(13);
        }
        return databaseAuthProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseAuthProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseAuthProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableAsDefault";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApplicable";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AuthWidget {
        default public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                AuthWidget.$$$reportNull$$$0(0);
            }
            this.onChanged((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget$1", "textChanged"));
                }
            });
        }

        @Deprecated
        default public void onChanged(@NotNull DocumentListener r) {
            if (r == null) {
                AuthWidget.$$$reportNull$$$0(1);
            }
        }

        public void save(@NotNull LocalDataSource var1, boolean var2);

        public void reset(@NotNull LocalDataSource var1, boolean var2);

        public boolean isPasswordChanged();

        public void hidePassword();

        public void reloadCredentials();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        public void forceSave();

        public void updateFromUrl(@NotNull ParametersHolder var1);

        public void updateUrl(@NotNull MutableParametersHolder var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget", "onChanged"));
        }
    }
}

