/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.ZipUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@ApiStatus.Internal
public class DatabaseArtifactList {
    public static final String STABLE_CHANNEL = "stable";
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactList.class);
    public static final DatabaseArtifactList EMPTY = new DatabaseArtifactList(false, new URL[0]);
    private final Map<String, Artifact> myArtifacts;
    private final Map<String, Channel> myChannels;
    private final Channel myStableChannel;
    private static final File NATIVE_LIBS_ROOT = new File(PathManager.getSystemPath(), "jdbc-native-deps");
    public static final ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.artifactsConfig");

    public DatabaseArtifactList(boolean checkDuplicates, URL ... urls) {
        if (urls == null) {
            DatabaseArtifactList.$$$reportNull$$$0(0);
        }
        this.myArtifacts = new TreeMap<String, Artifact>();
        this.myChannels = new TreeMap<String, Channel>();
        this.myStableChannel = new Channel(STABLE_CHANNEL, "Latest stable");
        this.myChannels.put(this.myStableChannel.id, this.myStableChannel);
        for (URL url : urls) {
            this.loadList(url, checkDuplicates);
        }
    }

    @Nullable
    public Artifact getArtifact(@Nullable String id) {
        return id == null ? null : this.myArtifacts.get(id);
    }

    @Nullable
    public ArtifactVersion resolve(@NotNull String artifactId, @Nullable Version version) {
        Artifact artifact;
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(1);
        }
        if ((artifact = this.getArtifact(artifactId)) == null) {
            return null;
        }
        return version == null ? null : artifact.get(version);
    }

    @Nullable
    public ArtifactVersion resolve(@NotNull String artifactId, @Nullable Version version, @Nullable String channelId, @Nullable Condition<? super ArtifactVersion> filter2) {
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(2);
        }
        if (channelId != null) {
            Channel channel = this.getChannel(channelId);
            Artifact artifact = this.getArtifact(artifactId);
            return artifact == null || channel == null ? null : channel.getLatest(artifact, filter2);
        }
        return this.resolve(artifactId, version);
    }

    @Nullable
    public Channel getChannel(@Nullable String id) {
        return id == null ? null : this.myChannels.get(id);
    }

    @NotNull
    public Set<Artifact> getArtifacts() {
        return new LinkedHashSet<Artifact>(this.myArtifacts.values());
    }

    @NotNull
    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.myChannels.values());
    }

    public boolean isValid(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(3);
        }
        return DatabaseArtifactList.isValidFileList(version);
    }

    public boolean isValid(@NotNull String name, @NotNull Version version) {
        Artifact artifact;
        ArtifactVersion desc;
        if (name == null) {
            DatabaseArtifactList.$$$reportNull$$$0(4);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(5);
        }
        ArtifactVersion artifactVersion = desc = (artifact = this.getArtifact(name)) == null ? null : artifact.get(version);
        if (desc != null) {
            return this.isValid(desc);
        }
        return DatabaseArtifactList.getArtifactDir(name, version).exists();
    }

    public boolean isFreshFiles(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(6);
        }
        return DatabaseArtifactList.isAllDownloaded(version);
    }

    public static boolean isValidFileList(@NotNull ArtifactVersion desc) {
        if (desc == null) {
            DatabaseArtifactList.$$$reportNull$$$0(7);
        }
        return DatabaseArtifactList.isAllDownloaded(desc);
    }

    private static boolean isAllDownloaded(@NotNull ArtifactVersion artifact) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(8);
        }
        File dir = DatabaseArtifactList.getArtifactDir(artifact);
        for (Item item : artifact.items) {
            if (!item.os.applicable || item.type == Item.Type.LICENSE || DatabaseArtifactList.exists(dir, item)) continue;
            return false;
        }
        return true;
    }

    private static boolean exists(File dir, Item item) {
        if (item.type != Item.Type.MAVEN) {
            return new File(dir, item.name).exists();
        }
        Pair<List<File>, Boolean> state = item.getClassPathState(dir);
        if (!((Boolean)state.second).booleanValue()) {
            return false;
        }
        for (File file : (List)state.first) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public void downloadArtifact(@NotNull ArtifactVersion download) throws IOException {
        if (download == null) {
            DatabaseArtifactList.$$$reportNull$$$0(9);
        }
        File dir = DatabaseArtifactList.getArtifactDir(download);
        DownloadableFileSetDescription description = DatabaseArtifactList.asDownloadable(download);
        if (!description.getFiles().isEmpty()) {
            FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(description);
            downloader.download(dir);
        }
        try {
            this.downloadMavenItems(download, dir);
        }
        catch (Exception e) {
            throw new IOException("Download from maven failed", e);
        }
        DatabaseArtifactList.unpackNativeLibraries(download);
    }

    public void downloadMavenItems(@NotNull ArtifactVersion download, File dir) throws Exception {
        if (download == null) {
            DatabaseArtifactList.$$$reportNull$$$0(10);
        }
        for (Item item : download.items) {
            if (item.type != Item.Type.MAVEN) continue;
            DatabaseArtifactList.resolveMavenItem(dir, item, true);
            item.classpath = null;
            item.getClassPathState(dir);
        }
    }

    public static void unpackNativeLibraries(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(11);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        for (Item item : version.items) {
            if (!item.os.applicable || item.type != Item.Type.NATIVE) continue;
            File archive = new File(dir, item.name);
            DatabaseArtifactList.unpackLibraryIfNeeded(archive, version);
        }
    }

    public static List<File> getNativeLibraries(@NotNull ArtifactVersion version, @NotNull Bitness bitness) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(12);
        }
        if (bitness == null) {
            DatabaseArtifactList.$$$reportNull$$$0(13);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        ArrayList<File> paths = new ArrayList<File>();
        for (Item item : version.items) {
            File archive;
            File archPath;
            if (!item.os.applicable || item.type != Item.Type.NATIVE || (archPath = DatabaseArtifactList.getNativeLibrary(archive = new File(dir, item.name), version, bitness)) == null) continue;
            paths.add(archPath);
        }
        return paths;
    }

    public static File getNativeLibrary(@NotNull File archive, @Nullable ArtifactVersion version, @NotNull Bitness bitness) {
        File path;
        if (archive == null) {
            DatabaseArtifactList.$$$reportNull$$$0(14);
        }
        if (bitness == null) {
            DatabaseArtifactList.$$$reportNull$$$0(15);
        }
        if ((path = DatabaseArtifactList.unpackLibraryIfNeeded(archive, version)) == null) {
            return null;
        }
        return DatabaseArtifactList.chooseArchPath(path, bitness);
    }

    private static File chooseArchPath(File path, Bitness bitness) {
        File archFolder = new File(path, bitness.toString());
        if (!archFolder.exists()) {
            return path;
        }
        File sso = new File(archFolder, "SSO");
        if (sso.exists()) {
            return sso;
        }
        return archFolder;
    }

    private static void extractLibrary(File archive, File out, String name) {
        if (DatabaseArtifactList.isExtracted(out)) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2(DatabaseBundle.message((String)"progress.details.extracting", (Object[])new Object[]{name}));
        }
        try {
            ZipUtil.extract((File)archive, (File)out, null, (boolean)true);
        }
        catch (IOException e) {
            LOG.warn("Failed to extract " + name, (Throwable)e);
            FileUtil.delete((File)out);
        }
    }

    private static File unpackLibraryIfNeeded(@NotNull File archive, @Nullable ArtifactVersion version) {
        if (archive == null) {
            DatabaseArtifactList.$$$reportNull$$$0(16);
        }
        if (!archive.exists()) {
            return null;
        }
        File out = DatabaseArtifactList.getNativePath(archive, version);
        DatabaseArtifactList.extractLibrary(archive, out, archive.getName());
        return out;
    }

    private static boolean isExtracted(File out) {
        return out.exists() && !ArrayUtil.isEmpty((Object[])out.list());
    }

    @NotNull
    private static File getNativePath(File archive, @Nullable ArtifactVersion version) {
        String name = FileUtil.getNameWithoutExtension((File)archive);
        if (version != null) {
            return new File(new File(new File(NATIVE_LIBS_ROOT, version.artifact.id), version.version.toString()), name);
        }
        MessageDigest digest = DigestUtil.sha256();
        DigestUtil.updateContentHash((MessageDigest)digest, (Path)archive.toPath());
        String fileHash = StringUtil.toHexString((byte[])digest.digest());
        return new File(new File(NATIVE_LIBS_ROOT, "user-provided"), name + "-" + fileHash);
    }

    void loadList(@NotNull URL url, boolean checkDuplicates) {
        if (url == null) {
            DatabaseArtifactList.$$$reportNull$$$0(17);
        }
        try (InputStream stream = url.openStream();){
            this.loadList((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET), (XmlPullParser)new MXParser()), checkDuplicates);
        }
        catch (IOException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
            LOG.warn((Throwable)e);
        }
    }

    void loadList(@NotNull HierarchicalStreamReader reader, boolean checkDuplicates) throws IOException {
        if (reader == null) {
            DatabaseArtifactList.$$$reportNull$$$0(18);
        }
        if (!"artifacts".equals(reader.getNodeName())) {
            throw new IOException("Unexpected root: " + reader.getNodeName());
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "artifact": {
                    this.readArtifact(reader, checkDuplicates);
                    break;
                }
                case "channel": {
                    this.readChannel(reader);
                    break;
                }
                case "constraint": {
                    String id = reader.getAttribute("artifact-id");
                    if (id == null) {
                        throw new IOException("No artifact id for constraint");
                    }
                    Artifact artifact = this.getArtifact(id);
                    if (artifact == null) {
                        throw new IOException("Unable to find artifact " + id);
                    }
                    DatabaseArtifactList.readConstraint(reader, artifact);
                }
            }
            reader.moveUp();
        }
    }

    private static void readConstraint(HierarchicalStreamReader reader, @NotNull Artifact artifact) {
        Dbms dbms;
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(19);
        }
        Version from = Version.of((String)reader.getAttribute("from"));
        Version to = Version.of((String)reader.getAttribute("to"));
        String dbmsName = reader.getAttribute("dbms");
        Version dbForm = Version.of((String)reader.getAttribute("db-from"));
        Version dbTo = Version.of((String)reader.getAttribute("db-to"));
        Dbms dbms2 = dbms = dbmsName == null ? null : Dbms.byName((String)dbmsName);
        if (dbms == null && dbmsName != null) {
            return;
        }
        artifact.constraints.add(new Constraint(from, to, dbms, dbForm, dbTo));
    }

    private void readChannel(HierarchicalStreamReader reader) {
        String id = reader.getAttribute("id");
        String name = reader.getAttribute("name");
        Channel channel = new Channel(id, name);
        this.myChannels.put(channel.id, channel);
    }

    private void readArtifact(HierarchicalStreamReader reader, boolean checkDuplicates) throws IOException {
        Artifact artifact;
        String id = reader.getAttribute("id");
        String name = reader.getAttribute("name");
        if (id == null) {
            id = StringUtil.trimEnd((String)name.replaceAll("[^a-zA-Z0-9. _-]", ""), (String)" 8");
        }
        if ((artifact = this.myArtifacts.get(id)) == null) {
            artifact = new Artifact(id, name);
            this.checkIndexConsistency(artifact);
            this.myArtifacts.put(artifact.id, artifact);
        }
        this.myArtifacts.put(name, artifact);
        artifact.names.add(name);
        if (reader.getAttribute("version") == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                switch (reader.getNodeName()) {
                    case "version": {
                        DatabaseArtifactList.readArtifactVersion(reader, artifact, checkDuplicates);
                        break;
                    }
                    case "constraint": {
                        DatabaseArtifactList.readConstraint(reader, artifact);
                    }
                }
                reader.moveUp();
            }
        } else {
            DatabaseArtifactList.readArtifactVersion(reader, artifact, checkDuplicates);
        }
    }

    private void checkIndexConsistency(Artifact artifact) throws IOException {
        Artifact byName;
        Artifact byId = this.myArtifacts.get(artifact.id);
        if (byId != (byName = this.myArtifacts.get(artifact.name))) {
            throw new IOException("id/name inconsistency: " + (byId == null ? null : byId.id + ":" + byId.name) + "/" + (byName == null ? null : byName.id + ":" + byName.name));
        }
    }

    private static void readArtifactVersion(HierarchicalStreamReader reader, @NotNull Artifact artifact, boolean checkDuplicates) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(20);
        }
        Version version = Version.of((String)reader.getAttribute("version"));
        ArrayList<Item> items2 = new ArrayList<Item>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("item".equals(reader.getNodeName())) {
                items2.add(DatabaseArtifactList.readItem(reader));
            }
            reader.moveUp();
        }
        ArtifactVersion av = new ArtifactVersion(artifact, version, items2);
        if (!artifact.versions.add(av) && checkDuplicates) {
            LOG.error("Duplicate artifact version " + av.toString());
        }
    }

    private static Item readItem(HierarchicalStreamReader reader) {
        String osName;
        Item.OS os;
        String url = reader.getAttribute("url");
        String name = reader.getAttribute("name");
        if (name == null) {
            name = PathUtil.getFileName((String)url);
        }
        Item.OS oS = os = (osName = reader.getAttribute("os")) == null ? null : (Item.OS)((Object)ContainerUtil.find((Object[])Item.OS.values(), o -> o.name().equalsIgnoreCase(osName)));
        if (os == null) {
            os = name.contains("win") ? Item.OS.WIN : Item.OS.ANY;
        }
        String typeName = reader.getAttribute("type");
        Item.Type type = (Item.Type)((Object)ContainerUtil.find((Object[])Item.Type.values(), o -> o.name().equalsIgnoreCase(typeName)));
        if (type == null) {
            type = name.endsWith(".txt") ? Item.Type.LICENSE : ((name.startsWith("sqlserver") || name.startsWith("jtds")) && name.endsWith("win-auth.jar") ? Item.Type.NATIVE : Item.Type.JAR);
        }
        return new Item(name, url, os, type);
    }

    @NotNull
    private static File getArtifactDir(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(21);
        }
        return DatabaseArtifactList.getArtifactDir(version.artifact, version.version);
    }

    @NotNull
    static File getArtifactDir(@NotNull Artifact artifact, @NotNull Version version) {
        File expected;
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(22);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(23);
        }
        if ((expected = DatabaseArtifactList.getArtifactDirImpl(artifact.id, version)).exists()) {
            File file = expected;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(24);
            }
            return file;
        }
        File old = DatabaseArtifactList.getArtifactDirImpl(artifact.name, version);
        if (old.exists()) {
            File file = old;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(25);
            }
            return file;
        }
        if (artifact.id.equals("MySQL ConnectorJ") && (old = DatabaseArtifactList.getArtifactDirImpl("MySQL Connector/J 8", version)).exists()) {
            File file = old;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(26);
            }
            return file;
        }
        File file = expected;
        if (file == null) {
            DatabaseArtifactList.$$$reportNull$$$0(27);
        }
        return file;
    }

    @NotNull
    public static File getArtifactDir(@NotNull String name, @NotNull Version version) {
        File asIs;
        if (name == null) {
            DatabaseArtifactList.$$$reportNull$$$0(28);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(29);
        }
        if ((asIs = DatabaseArtifactList.getArtifactDirImpl(name, version)).exists()) {
            File file = asIs;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(30);
            }
            return file;
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        Artifact artifact = artifacts.getArtifact(name);
        return artifact == null ? asIs : DatabaseArtifactList.getArtifactDir(artifact, version);
    }

    @NotNull
    private static File getArtifactDirImpl(@NotNull String artifact, @NotNull Version version) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(31);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(32);
        }
        return new File(new File(DatabaseDriverImpl.getDownloadPath(), artifact), version.toString());
    }

    @NotNull
    private static DownloadableFileDescription asDownloadable(@NotNull Item item) {
        if (item == null) {
            DatabaseArtifactList.$$$reportNull$$$0(33);
        }
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(item.url, item.name);
        if (downloadableFileDescription == null) {
            DatabaseArtifactList.$$$reportNull$$$0(34);
        }
        return downloadableFileDescription;
    }

    @NotNull
    public static DownloadableFileSetDescription asDownloadable(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(35);
        }
        return new DownloadableFileSetDescriptionImpl(version.artifact.name, version.version.toString(), ContainerUtil.mapNotNull(version.items, item -> item.os.applicable && item.type != Item.Type.MAVEN ? DatabaseArtifactList.asDownloadable(item) : null));
    }

    @NotNull
    public static List<File> getClasspathElements(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(36);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        ArrayList<File> elements = new ArrayList<File>();
        for (Item item : version.items) {
            List<File> cp = item.getClassPath(dir);
            if (cp == null) continue;
            elements.addAll(cp);
        }
        ArrayList<File> arrayList = elements;
        if (arrayList == null) {
            DatabaseArtifactList.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<File> resolveMavenItem(File dir, Item item, boolean download) throws Exception {
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText(DatabaseBundle.message((String)"progress.text.choice.downloading.resolving", (Object[])new Object[]{download ? 0 : 1, item.url}));
        }
        ArtifactRepositoryManager manager = new ArtifactRepositoryManager(dir, ArtifactRepositoryManager.createDefaultRemoteRepositories(), indicator != null ? new ProgressConsumer(){

            public void consume(String message2) {
                indicator.setText2(message2);
            }

            public boolean isCanceled() {
                return indicator.isCanceled();
            }
        } : ProgressConsumer.DEAF, !download);
        List coords = StringUtil.split((String)item.url, (String)":");
        if (coords.size() != 3) {
            throw new IOException("Illegal maven coordinates " + item.url + " should be group:artifact:version");
        }
        Collection collection = manager.resolveDependency((String)coords.get(0), (String)coords.get(1), (String)coords.get(2), true, Collections.emptyList());
        if (collection == null) {
            DatabaseArtifactList.$$$reportNull$$$0(38);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "download";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitness";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactList";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactDir";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "asDownloadable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMavenItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFreshFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAllDownloaded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadMavenItems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unpackNativeLibraries";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraries";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibrary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unpackLibraryIfNeeded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readConstraint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readArtifactVersion";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDir";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: {
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDirImpl";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "asDownloadable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Constraint {
        @Nullable
        public final Version from;
        @Nullable
        public final Version to;
        @Nullable
        public final Dbms dbms;
        @Nullable
        public final Version dbFrom;
        @Nullable
        public final Version dbTo;

        public Constraint(@Nullable Version from, @Nullable Version to, @Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            this.from = from;
            this.to = to;
            this.dbms = dbms;
            this.dbFrom = dbFrom;
            this.dbTo = dbTo;
        }

        public boolean matches(@NotNull Version ver, @NotNull Dbms dbms, @Nullable Version dbVer) {
            if (ver == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                Constraint.$$$reportNull$$$0(1);
            }
            return this.matches(ver, dbms, dbVer, dbVer);
        }

        public boolean matches(@NotNull Version ver, @NotNull Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            if (ver == null) {
                Constraint.$$$reportNull$$$0(2);
            }
            if (dbms == null) {
                Constraint.$$$reportNull$$$0(3);
            }
            if (this.from != null && ver.less(this.from)) {
                return false;
            }
            if (this.to != null && ver.isOrGreater(this.to)) {
                return false;
            }
            if (this.dbms != null && this.dbms != dbms) {
                return false;
            }
            if (dbFrom != null && this.dbFrom != null && dbFrom.less(this.dbFrom)) {
                return false;
            }
            return dbTo == null || this.dbTo == null || !dbTo.isOrGreater(this.dbTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ver";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Constraint";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Channel
    implements VersionRef {
        public final String id;
        @NlsSafe
        public final String name;
        public final Map<String, Version> heads;

        public Channel(@NotNull String id, @NotNull String name) {
            if (id == null) {
                Channel.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Channel.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.name = name;
            this.heads = new LinkedHashMap<String, Version>();
        }

        public boolean contains(@NotNull ArtifactVersion version) {
            if (version == null) {
                Channel.$$$reportNull$$$0(2);
            }
            Version head = this.heads.getOrDefault(version.artifact.id, Version.INFINITY);
            return head.isOrGreater(version.version);
        }

        @Nullable
        public ArtifactVersion getLatest(@NotNull Artifact artifact, @Nullable Condition<? super ArtifactVersion> filter2) {
            if (artifact == null) {
                Channel.$$$reportNull$$$0(3);
            }
            Version head = this.heads.getOrDefault(artifact.id, Version.INFINITY);
            return (ArtifactVersion)ContainerUtil.find(artifact.versions, v -> head.isOrGreater(v.version) && (filter2 == null || filter2.value(v)));
        }

        @Override
        public String getVersionDisplayName() {
            return this.name;
        }

        public String toString() {
            return "Channel: " + this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Channel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLatest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ArtifactVersion
    implements Comparable<ArtifactVersion>,
    VersionRef {
        public final Artifact artifact;
        public final Version version;
        public final List<Item> items;

        public ArtifactVersion(@NotNull Artifact artifact, @NotNull Version version, @NotNull List<Item> items2) {
            if (artifact == null) {
                ArtifactVersion.$$$reportNull$$$0(0);
            }
            if (version == null) {
                ArtifactVersion.$$$reportNull$$$0(1);
            }
            if (items2 == null) {
                ArtifactVersion.$$$reportNull$$$0(2);
            }
            this.artifact = artifact;
            this.version = version;
            this.items = items2;
        }

        @Override
        public int compareTo(@NotNull ArtifactVersion o) {
            if (o == null) {
                ArtifactVersion.$$$reportNull$$$0(3);
            }
            return o.version.compareTo(this.version);
        }

        public boolean matches(@NotNull Dbms dbms, @Nullable Version version) {
            if (dbms == null) {
                ArtifactVersion.$$$reportNull$$$0(4);
            }
            return this.matches(dbms, version, version);
        }

        public boolean matches(@NotNull Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            Constraint constraint;
            if (dbms == null) {
                ArtifactVersion.$$$reportNull$$$0(5);
            }
            return (constraint = (Constraint)ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(this.version, dbms, dbFrom, dbTo))) != null || ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(this.version, dbms, null, null)) == null;
        }

        @Override
        @NlsSafe
        public String getVersionDisplayName() {
            return this.version.toString();
        }

        public String toString() {
            return this.artifact.name + ":" + this.version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$ArtifactVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface VersionRef {
        @Nls
        public String getVersionDisplayName();
    }

    public static final class Artifact {
        @NonNls
        public final String id;
        @NlsSafe
        public final String name;
        public final SortedSet<ArtifactVersion> versions;
        public final List<Constraint> constraints;
        final Set<String> names;

        public Artifact(@NotNull String id, @NotNull String name) {
            if (id == null) {
                Artifact.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Artifact.$$$reportNull$$$0(1);
            }
            this.names = new HashSet<String>();
            this.id = id;
            this.name = name;
            this.versions = new TreeSet<ArtifactVersion>();
            this.constraints = new ArrayList<Constraint>();
            this.names.add(id);
            this.names.add(name);
        }

        @Nullable
        public ArtifactVersion get(@NotNull Version version) {
            if (version == null) {
                Artifact.$$$reportNull$$$0(2);
            }
            return (ArtifactVersion)ContainerUtil.find(this.versions, v -> v.version.equals((Object)version));
        }

        public String toString() {
            return this.name;
        }

        public boolean isId(String id) {
            return this.names.contains(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Artifact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Item {
        public final String name;
        public final String url;
        public final OS os;
        public final Type type;
        public volatile Pair<List<File>, Boolean> classpath;

        public Item(@NotNull String name, @NotNull String url, @NotNull OS os, @NotNull Type type) {
            if (name == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (url == null) {
                Item.$$$reportNull$$$0(1);
            }
            if (os == null) {
                Item.$$$reportNull$$$0(2);
            }
            if (type == null) {
                Item.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.url = url;
            this.os = os;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }

        @Nullable
        public List<File> getClassPath(File dir) {
            return (List)this.getClassPathState((File)dir).first;
        }

        @NotNull
        private Pair<List<File>, Boolean> getClassPathState(File dir) {
            Pair<List<File>, Boolean> cp = this.classpath;
            if (cp != null) {
                Pair<List<File>, Boolean> pair = cp;
                if (pair == null) {
                    Item.$$$reportNull$$$0(4);
                }
                return pair;
            }
            Pair<List<File>, Boolean> newClasspath = this.resolveClassPath(dir);
            this.classpath = newClasspath;
            Pair<List<File>, Boolean> pair = newClasspath;
            if (pair == null) {
                Item.$$$reportNull$$$0(5);
            }
            return pair;
        }

        @NotNull
        private Pair<List<File>, Boolean> resolveClassPath(File dir) {
            if (this.type == Type.JAR) {
                Pair pair = Pair.create(Collections.singletonList(new File(dir, this.name)), (Object)true);
                if (pair == null) {
                    Item.$$$reportNull$$$0(6);
                }
                return pair;
            }
            if (this.type == Type.MAVEN) {
                Pair pair;
                try {
                    pair = Pair.create(new ArrayList<File>(DatabaseArtifactList.resolveMavenItem(dir, this, false)), (Object)true);
                }
                catch (ArtifactResolutionException ignore) {
                    Pair pair2 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair2 == null) {
                        Item.$$$reportNull$$$0(8);
                    }
                    return pair2;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    Pair pair3 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair3 == null) {
                        Item.$$$reportNull$$$0(9);
                    }
                    return pair3;
                }
                if (pair == null) {
                    Item.$$$reportNull$$$0(7);
                }
                return pair;
            }
            Pair pair = Pair.create(Collections.emptyList(), (Object)true);
            if (pair == null) {
                Item.$$$reportNull$$$0(10);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactList$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Item";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassPathState";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClassPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Type {
            JAR,
            NATIVE,
            LICENSE,
            MAVEN;

        }

        public static enum OS {
            ANY(true),
            LINUX(SystemInfo.isLinux),
            MAC(SystemInfo.isMac),
            WIN(SystemInfo.isWindows);

            public final boolean applicable;

            private OS(boolean applicable) {
                this.applicable = applicable;
            }
        }
    }
}

