/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.util.concurrent.Atomics;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorageLocal;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.json.AbstractJsonWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class DataSourceStorage
extends SimpleModificationTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DataSourceStorage.class);
    public static final Topic<Listener> TOPIC = new Topic(Listener.class);
    public static final String MULTIFILE_MODEL = "multifile-model";
    private boolean myMultiFileModel;
    @NonNls
    static final String STORAGE_ENTRY_NAME = "dataSources";
    @NonNls
    static final String STATE_FILE = "dataSources.xml";
    @NonNls
    static final String APP_STORAGE_FILE = "dataSources.ids";
    @NonNls
    static final String COMPONENT_NAME = "dataSourceStorage";
    @NonNls
    static final String COMPRESSED_ATTR_NAME = "compressed";
    @NonNls
    static final String FORMAT_ATTR_NAME = "format";
    @NotNull
    private final List<LocalDataSource> myDataSources;
    @NotNull
    private final AtomicReference<Promise<Void>> myLoadedPromise;
    private final Map<String, Object> myLocks;
    private Format myFormat;
    private final LocalDataSource.Listener myDataSourceListener;
    private final MessageBus myMessageBus;

    public static DataSourceStorage getStorage() {
        return (DataSourceStorage)((Object)ApplicationManager.getApplication().getService(App.class));
    }

    public static DataSourceStorage getProjectStorage(Project project) {
        return (DataSourceStorage)((Object)ServiceManager.getService((Project)project, Prj.class));
    }

    public DataSourceStorage(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            DataSourceStorage.$$$reportNull$$$0(0);
        }
        this.myMultiFileModel = true;
        this.myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadedPromise = Atomics.newReference((Object)Promises.resolvedPromise(null));
        this.myLocks = FactoryMap.create(key -> new Object((String)key){
            final /* synthetic */ String val$key;
            {
                this.val$key = string;
            }

            public String toString() {
                return this.val$key;
            }
        });
        this.myFormat = Format.XML;
        this.myMessageBus = messageBus;
        this.myDataSourceListener = o -> {
            if (this.myMessageBus.isDisposed()) {
                return;
            }
            this.incModificationCount();
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(o);
        };
    }

    @Nullable
    protected DataSourceStorage getParentStorage() {
        return null;
    }

    public void doWhenInitialized(@NotNull Runnable runnable) {
        DataSourceStorage parentStorage;
        if (runnable == null) {
            DataSourceStorage.$$$reportNull$$$0(1);
        }
        Promise promise = (parentStorage = this.getParentStorage()) == null ? this.myLoadedPromise.get() : Promises.all(Arrays.asList(parentStorage.myLoadedPromise.get(), this.myLoadedPromise.get()));
        promise.onSuccess(ignored -> runnable.run());
    }

    @NotNull
    public List<LocalDataSource> getOwnDataSources() {
        List<LocalDataSource> list = this.myDataSources;
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void addDataSourcesInner(@NotNull Iterable<LocalDataSource> dataSources2) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(3);
        }
        for (LocalDataSource dataSource2 : dataSources2) {
            this.addDataSourceInner(dataSource2);
        }
    }

    private void addDataSourceInner(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(4);
        }
        this.myDataSources.add(dataSource2);
        dataSource2.addListener(this.myDataSourceListener);
    }

    private boolean removeDataSourceInner(@NotNull LocalDataSource dataSource2) {
        boolean removed;
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(5);
        }
        if (removed = this.myDataSources.remove(dataSource2)) {
            dataSource2.removeListener(this.myDataSourceListener);
        }
        return removed;
    }

    private void removeAllDataSources() {
        ArrayList<LocalDataSource> existentDataSources = new ArrayList<LocalDataSource>(this.myDataSources);
        for (LocalDataSource dataSource2 : existentDataSources) {
            this.removeDataSourceInner(dataSource2);
        }
    }

    @NotNull
    public List<LocalDataSource> getDataSources() {
        List list = this.getDataSourcesImpl().toList();
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public JBIterable<LocalDataSource> getDataSourcesImpl() {
        DataSourceStorage parentStorage = this.getParentStorage();
        JBIterable jBIterable = JBIterable.from(this.myDataSources).append(parentStorage != null ? parentStorage.myDataSources : null);
        if (jBIterable == null) {
            DataSourceStorage.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public void addDataSource(LocalDataSource dataSource2) {
        LocalDataSource existing = this.getDataSourceById(dataSource2.getUniqueId());
        DataSourceStorage parentStorage = this.getParentStorage();
        if (existing != null) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): '%s' (%s@%d) has the same id: %s", parentStorage == null ? "global" : "project", dataSource2.getName(), dataSource2.getClass().getSimpleName(), dataSource2.hashCode(), existing.getName(), existing.getClass().getSimpleName(), existing.hashCode(), dataSource2.getUniqueId()));
        } else if (dataSource2.getDatabaseDriver() == null && ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): driver is not configured", parentStorage == null ? "global" : "project", dataSource2.getName(), dataSource2.getClass().getSimpleName(), dataSource2.hashCode()));
        } else if (dataSource2.isGlobal() && parentStorage != null) {
            parentStorage.addDataSource(dataSource2);
        } else {
            this.addDataSourceInner(dataSource2);
            this.incModificationCount();
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceAdded(dataSource2);
        }
    }

    @Nullable
    public LocalDataSource getDataSourceById(String id) {
        return DataSourceStorage.getDataSourcesByIdInner(id, this.getDataSources());
    }

    @Nullable
    private static <L extends AbstractDataSource> L getDataSourcesByIdInner(@Nullable String id, @NotNull Collection<? extends L> dataSources2) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(8);
        }
        for (AbstractDataSource dataSource2 : dataSources2) {
            if (!dataSource2.getUniqueId().equals(id)) continue;
            return (L)((Object)dataSource2);
        }
        return null;
    }

    public void removeDataSource(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(9);
        }
        if (this.removeDataSourceInner(dataSource2)) {
            this.incModificationCount();
            if (!this.myMessageBus.isDisposed()) {
                ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceRemoved(dataSource2);
            }
        } else {
            DataSourceStorage parentStorage = this.getParentStorage();
            if (parentStorage != null) {
                parentStorage.removeDataSource(dataSource2);
            }
        }
    }

    public void updateDataSource(LocalDataSource dataSource2) {
        dataSource2.incModificationCount();
        boolean isMy = this.myDataSources.contains(dataSource2);
        DataSourceStorage parentStorage = this.getParentStorage();
        if (parentStorage != null && dataSource2.isGlobal() == isMy) {
            this.removeDataSource(dataSource2);
            this.addDataSource(dataSource2);
        } else if (isMy) {
            this.incModificationCount();
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(dataSource2);
        } else if (parentStorage != null) {
            parentStorage.updateDataSource(dataSource2);
        }
    }

    public long getModificationCount() {
        DataSourceStorage parentStorage = this.getParentStorage();
        if (parentStorage != null) {
            return super.getModificationCount() + parentStorage.getModificationCount();
        }
        return super.getModificationCount();
    }

    public void dispose() {
    }

    public Element getState() {
        Element element2 = new Element(COMPONENT_NAME);
        this.writeState(null, element2);
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DataSourceStorage.$$$reportNull$$$0(10);
        }
        this.readState(null, state);
    }

    public void writeLocalState(@Nullable Project project) {
        Element element2 = new Element("dataSourceStorageLocal");
        JDomWriter serializer = new JDomWriter(element2);
        for (LocalDataSource dataSource2 : this.myDataSources) {
            dataSource2.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.LOCAL_CONFIG);
        }
        DataSourceStorageLocal.getInstance(project).loadState(element2);
    }

    private static void readLocalState(@Nullable Element element2, @Nullable Project project, boolean isGlobal, @NotNull Collection<LocalDataSource> dataSources2, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(11);
        }
        if (element2 == null) {
            for (LocalDataSource dataSource2 : dataSources2) {
                if (!StringUtil.isEmpty((String)dataSource2.getUsername())) continue;
                dataSource2.setPasswordStorage(LocalDataSource.Storage.NO);
            }
        } else {
            DataSourceStorage.readDataSources((HierarchicalStreamReader)new JDomReader(element2), LocalDataSource.SaveMode.LOCAL_CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> (LocalDataSource)DataSourceStorage.getDataSourcesByIdInner(uuid, dataSources2)), newDataSourcesConsumer);
        }
    }

    void readState(final @Nullable Project project, @NotNull Element element2) {
        Project anyProject;
        if (element2 == null) {
            DataSourceStorage.$$$reportNull$$$0(12);
        }
        if (project != null && project.isDefault()) {
            return;
        }
        this.myFormat = DataSourceStorage.readFormat(element2);
        this.myMultiFileModel = DataSourceStorage.isMultiFileModel(element2);
        final AsyncPromise promise = new AsyncPromise();
        this.myLoadedPromise.set((Promise<Void>)promise);
        this.incModificationCount();
        this.removeAllDataSources();
        boolean isGlobal = this.getParentStorage() == null;
        DataSourceStorageLocal storageLocal = DataSourceStorageLocal.getInstance(project);
        ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
        JDomReader domReader = new JDomReader(JDOMInterner.isInterned((Element)element2) ? element2.clone() : element2);
        DataSourceStorage.readDataSources((HierarchicalStreamReader)domReader, LocalDataSource.SaveMode.CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> null), (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
        DataSourceStorage.readLocalState(storageLocal.getState(), project, isGlobal, newDataSources, (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
        for (LocalDataSource dataSource2 : newDataSources) {
            dataSource2.setLoading(true);
            dataSource2.resolveDriver();
            if (dataSource2.getDatabaseDriver() != null && dataSource2.getOwnClasspath().isEmpty()) continue;
            dataSource2.ensureDriverConfigured();
        }
        this.addDataSourcesInner(newDataSources);
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
        Project project2 = anyProject = project != null ? project : DbImplUtil.getAnyProject();
        if (anyProject == null) {
            throw new AssertionError((Object)"Shall not be called until a project is opened");
        }
        Task.Backgroundable task = new Task.Backgroundable(anyProject, DatabaseBundle.message((String)"loading.data.sources", (Object[])new Object[0]), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                Ref finished = Ref.create((Object)false);
                Disposable disposable2 = () -> {
                    if (!((Boolean)finished.get()).booleanValue()) {
                        indicator.cancel();
                    }
                };
                Disposer.register((Disposable)DataSourceStorage.this, (Disposable)disposable2);
                try {
                    DataSourceStorage.this.readStateHeavy(project, (AsyncPromise<Void>)promise);
                    finished.set((Object)true);
                }
                finally {
                    Disposer.dispose((Disposable)disposable2, (boolean)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceStorage$2", "run"));
            }
        };
        StartupManager.getInstance((Project)anyProject).runWhenProjectIsInitialized(() -> task.queue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStateHeavy(final @Nullable Project project, @NotNull AsyncPromise<Void> promise) {
        if (promise == null) {
            DataSourceStorage.$$$reportNull$$$0(13);
        }
        Application application = ApplicationManager.getApplication();
        Application disposable2 = project == null ? application : project;
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            ProgressManager.checkCanceled();
            this.loadModels(project, errorHandler, (PairConsumer<LocalDataSource, DasModel>)((PairConsumer)(arg_0, arg_1) -> this.lambda$readStateHeavy$7(promise, project, (ComponentManager)disposable2, arg_0, arg_1)));
        }
        catch (ProcessCanceledException e) {
            block15: {
                try {
                    if (promise != this.myLoadedPromise.get()) {
                        this.myLoadedPromise.get().processed(promise);
                        break block15;
                    }
                    promise.setError((Throwable)e);
                }
                catch (Throwable throwable) {
                    Runnable runnable = () -> {
                        final ArrayList<LocalDataSource> unsuccessful = new ArrayList<LocalDataSource>();
                        for (LocalDataSource dataSource2 : this.myDataSources) {
                            if (!dataSource2.isLoading()) continue;
                            dataSource2.setModel(DasUtil.emptyModel());
                            dataSource2.setLoading(false);
                            unsuccessful.add(dataSource2);
                        }
                        application.executeOnPooledThread(() -> {
                            Project anyProject;
                            if (project != null && project.isDisposed()) {
                                return;
                            }
                            Project project2 = anyProject = project != null ? project : DbImplUtil.getAnyProject();
                            if (anyProject == null) {
                                return;
                            }
                            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                                for (LocalDataSource dataSource2 : this.myDataSources) {
                                    AsyncTask<DataSourceSyncManager.SyncResult> task = DataSourceUiUtil.applyMappings(anyProject, dataSource2);
                                    if (task == null) continue;
                                    try {
                                        task.handle().toFuture().get(5L, TimeUnit.SECONDS);
                                    }
                                    catch (InterruptedException e) {
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                            }, (ProgressIndicator)new EmptyProgressIndicator());
                            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
                        });
                        promise.setResult(null);
                        FileContentUtil.reparseOpenedFiles();
                        String summary = errorHandler.getSummary();
                        if (StringUtil.isNotEmpty((String)summary)) {
                            String title = DatabaseBundle.message((String)"notification.title.data.sources.href.sync.refresh.required", (Object[])new Object[]{project == null ? "Global" : "Project"});
                            Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                                    Project anyProject;
                                    if (notification == null) {
                                        3.$$$reportNull$$$0(0);
                                    }
                                    if (e == null) {
                                        3.$$$reportNull$$$0(1);
                                    }
                                    Project project2 = anyProject = project != null ? project : DbImplUtil.getAnyProject();
                                    if (anyProject == null) {
                                        return;
                                    }
                                    for (LocalDataSource dataSource2 : unsuccessful) {
                                        DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(anyProject, dataSource2));
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "notification";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "e";
                                            break;
                                        }
                                    }
                                    objectArray[1] = "com/intellij/database/dataSource/DataSourceStorage$3";
                                    objectArray[2] = "hyperlinkActivated";
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            });
                            notification.notify(project);
                        }
                    };
                    if (promise == this.myLoadedPromise.get()) {
                        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)disposable2)).submit(runnable);
                        if (DbSrcValidator.isEnabled()) {
                            Project p2;
                            Project project2 = p2 = project == null ? DbImplUtil.getAnyProject() : project;
                            if (project != null) {
                                DataSourceStorage.validateModels(p2, this.myDataSources);
                            }
                        }
                    }
                    throw throwable;
                }
            }
            Runnable runnable = () -> {
                final ArrayList<LocalDataSource> unsuccessful = new ArrayList<LocalDataSource>();
                for (LocalDataSource dataSource2 : this.myDataSources) {
                    if (!dataSource2.isLoading()) continue;
                    dataSource2.setModel(DasUtil.emptyModel());
                    dataSource2.setLoading(false);
                    unsuccessful.add(dataSource2);
                }
                application.executeOnPooledThread(() -> {
                    Project anyProject;
                    if (project != null && project.isDisposed()) {
                        return;
                    }
                    Project project2 = anyProject = project != null ? project : DbImplUtil.getAnyProject();
                    if (anyProject == null) {
                        return;
                    }
                    ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                        for (LocalDataSource dataSource2 : this.myDataSources) {
                            AsyncTask<DataSourceSyncManager.SyncResult> task = DataSourceUiUtil.applyMappings(anyProject, dataSource2);
                            if (task == null) continue;
                            try {
                                task.handle().toFuture().get(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }, (ProgressIndicator)new EmptyProgressIndicator());
                    ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
                });
                promise.setResult(null);
                FileContentUtil.reparseOpenedFiles();
                String summary = errorHandler.getSummary();
                if (StringUtil.isNotEmpty((String)summary)) {
                    String title = DatabaseBundle.message((String)"notification.title.data.sources.href.sync.refresh.required", (Object[])new Object[]{project == null ? "Global" : "Project"});
                    Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new /* invalid duplicate definition of identical inner class */);
                    notification.notify(project);
                }
            };
            if (promise == this.myLoadedPromise.get()) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)disposable2)).submit(runnable);
                if (DbSrcValidator.isEnabled()) {
                    Project p3;
                    Project project3 = p3 = project == null ? DbImplUtil.getAnyProject() : project;
                    if (project != null) {
                        DataSourceStorage.validateModels(p3, this.myDataSources);
                    }
                }
            }
        }
        Runnable runnable = () -> {
            final ArrayList<LocalDataSource> unsuccessful = new ArrayList<LocalDataSource>();
            for (LocalDataSource dataSource2 : this.myDataSources) {
                if (!dataSource2.isLoading()) continue;
                dataSource2.setModel(DasUtil.emptyModel());
                dataSource2.setLoading(false);
                unsuccessful.add(dataSource2);
            }
            application.executeOnPooledThread(() -> {
                Project anyProject;
                if (project != null && project.isDisposed()) {
                    return;
                }
                Project project2 = anyProject = project != null ? project : DbImplUtil.getAnyProject();
                if (anyProject == null) {
                    return;
                }
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    for (LocalDataSource dataSource2 : this.myDataSources) {
                        AsyncTask<DataSourceSyncManager.SyncResult> task = DataSourceUiUtil.applyMappings(anyProject, dataSource2);
                        if (task == null) continue;
                        try {
                            task.handle().toFuture().get(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }, (ProgressIndicator)new EmptyProgressIndicator());
                ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
            });
            promise.setResult(null);
            FileContentUtil.reparseOpenedFiles();
            String summary = errorHandler.getSummary();
            if (StringUtil.isNotEmpty((String)summary)) {
                String title = DatabaseBundle.message((String)"notification.title.data.sources.href.sync.refresh.required", (Object[])new Object[]{project == null ? "Global" : "Project"});
                Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new /* invalid duplicate definition of identical inner class */);
                notification.notify(project);
            }
        };
        if (promise == this.myLoadedPromise.get()) {
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)disposable2)).submit(runnable);
            if (DbSrcValidator.isEnabled()) {
                Project p4;
                Project project4 = p4 = project == null ? DbImplUtil.getAnyProject() : project;
                if (project != null) {
                    DataSourceStorage.validateModels(p4, this.myDataSources);
                }
            }
        }
    }

    private static void migrateStorage(Project project, LocalDataSource source, DasModel model) {
        String dataSourceId;
        DbSrcStorageManager storageManager = DbSrcStorageManager.getInstance(project);
        if (!storageManager.isStoredInNewFormat(dataSourceId = source.getUniqueId())) {
            storageManager.migrate(dataSourceId, model);
        }
    }

    private static void validateModels(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(14);
        }
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(15);
        }
        if (project.isDisposed()) {
            return;
        }
        Couple<List<LocalDataSource>> result = new DbSrcValidator().collect(project, dataSources2);
        if (project.isDisposed() || ((List)result.first).isEmpty() && ((List)result.second).isEmpty()) {
            return;
        }
        if (!((List)result.second).isEmpty()) {
            DbSrcValidator.suggestIntrospecting(project, (List)result.second);
        }
        if (!((List)result.first).isEmpty()) {
            DbSrcValidator.regenerateSources(project, (List)result.first);
        }
    }

    private static boolean isMultiFileModel(Element element2) {
        return "true".equals(element2.getAttributeValue(MULTIFILE_MODEL));
    }

    private boolean loadModels(@Nullable Project project, @NotNull ErrorHandler errorHandler, @NotNull PairConsumer<LocalDataSource, DasModel> consumer2) {
        if (errorHandler == null) {
            DataSourceStorage.$$$reportNull$$$0(16);
        }
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>(this.myDataSources);
        Path path = DataSourceStorage.getStoragePath(project);
        boolean migrating = !this.myMultiFileModel && Files.exists(path, new LinkOption[0]);
        this.myMultiFileModel = true;
        boolean failed = migrating && this.loadFromDisk(project, path, LocalDataSource.SaveMode.SCHEMA, errorHandler) == null;
        for (LocalDataSource source : newDataSources) {
            try {
                boolean loaded = this.readModel(project, source, false, consumer2);
                if (!loaded) {
                    if (migrating && source.getModel() != DasUtil.emptyModel()) {
                        failed |= !this.writeModel(project, source);
                    } else if (!migrating && (loaded = this.readModel(project, source, true, consumer2))) {
                        failed |= !this.writeModel(project, source);
                    }
                }
                if (loaded) continue;
                consumer2.consume((Object)source, (Object)DasUtil.emptyModel());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (Exception e) {
                failed = true;
                String file = this.getModelPath(project, source, false);
                if (file != null) {
                    DataSourceStorage.processCorruption(Paths.get(file, new String[0]), e);
                }
                errorHandler.addError(e.getMessage(), e);
            }
        }
        if (failed) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        Condition expired = project == null ? app.getDisposed() : project.getDisposed();
        app.invokeLater(() -> app.runWriteAction(() -> this.cleanupOldFiles(project, newDataSources)), ModalityState.NON_MODAL, expired);
        app.executeOnPooledThread(() -> DbSrcValidator.checkOutdatedFiles(project));
        this.incModificationCount();
        return true;
    }

    private void cleanupOldFiles(@Nullable Project project, @NotNull List<LocalDataSource> newDataSources) {
        VirtualFile root2;
        if (newDataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(18);
        }
        String dir = DataSourceStorage.getStorageDir(project);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = root2 = dir == null ? null : lfs.refreshAndFindFileByPath(dir);
        if (root2 == null) {
            return;
        }
        HashSet toKeep = new HashSet();
        HashSet<String> uids = new HashSet<String>();
        for (LocalDataSource source : newDataSources) {
            uids.add(source.getUniqueId());
            if (source.getModel() == DasUtil.emptyModel()) continue;
            String path = this.getModelPath(project, source, false);
            ContainerUtil.addIfNotNull(toKeep, path == null ? null : lfs.findFileByPath(path));
        }
        Pattern filePattern = Pattern.compile("\\p{XDigit}{8}(?:-\\p{XDigit}{4}){3}-\\p{XDigit}{12}(?:\\.xml)?");
        Condition keep = f -> toKeep.contains(f) || uids.stream().anyMatch(uid -> f.getName().startsWith((String)uid));
        for (VirtualFile file : root2.getChildren()) {
            if (!filePattern.matcher(file.getName()).matches() || keep.value((Object)file)) continue;
            try {
                file.delete((Object)this);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    private static Format readFormat(@NotNull Element element2) {
        String formatAttr;
        if (element2 == null) {
            DataSourceStorage.$$$reportNull$$$0(19);
        }
        if ((formatAttr = element2.getAttributeValue(FORMAT_ATTR_NAME)) != null) {
            Format format;
            try {
                format = Format.valueOf(StringUtil.toUpperCase((String)formatAttr));
            }
            catch (IllegalArgumentException e) {
                Format format2 = Format.XML;
                if (format2 == null) {
                    DataSourceStorage.$$$reportNull$$$0(21);
                }
                return format2;
            }
            if (format == null) {
                DataSourceStorage.$$$reportNull$$$0(20);
            }
            return format;
        }
        String oldCompressedAttr = element2.getAttributeValue(COMPRESSED_ATTR_NAME);
        Format format = Boolean.parseBoolean(oldCompressedAttr) ? Format.COMPRESSED_XML : Format.XML;
        if (format == null) {
            DataSourceStorage.$$$reportNull$$$0(22);
        }
        return format;
    }

    void writeState(Project project, Element element2) {
        if (project != null && project.isDefault()) {
            return;
        }
        this.writeStateInner(project, element2);
    }

    @Nullable
    public static Path getStoragePath(@Nullable Project project) {
        if (project == null) {
            return Paths.get(PathManager.getOptionsPath(), APP_STORAGE_FILE);
        }
        if (project.isDisposed() || project.isDefault()) {
            return null;
        }
        if (ProjectKt.isDirectoryBased((Project)project)) {
            return ProjectKt.getStateStore((Project)project).getDirectoryStorePath().resolve(APP_STORAGE_FILE);
        }
        String projectFilePath = project.getProjectFilePath();
        if (projectFilePath == null) {
            return null;
        }
        return Paths.get(FileUtilRt.getNameWithoutExtension((String)projectFilePath) + ".ids", new String[0]);
    }

    @Nullable
    public static String getStorageDir(@Nullable Project project) {
        IProjectStore projectStore;
        Path path = DataSourceStorage.getStoragePath(project);
        if (project != null && !project.isDisposed() && path != null && (projectStore = ProjectKt.getStateStore((Project)project)).getStorageScheme() == StorageScheme.DEFAULT) {
            return path.getParent().toString() + "/.ideaDataSources";
        }
        return path == null ? null : path.getParent().toString() + "/dataSources";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeModel(@Nullable Project project, @NotNull LocalDataSource dataSource2) throws IOException {
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(23);
        }
        ProgressManager.checkCanceled();
        if (project != null && project.isDefault()) {
            return false;
        }
        String path = this.getModelPath(project, dataSource2, false);
        if (path == null) {
            return false;
        }
        if (DataSourceStorage.isReadonly(project, path)) {
            LOG.warn("Unable to save model. File is readonly: " + path);
            return false;
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        File file = new File(path);
        FileUtil.createParentDirs((File)file);
        DasModel model = dataSource2.getModel();
        if (model.getModelRoots().isEmpty()) {
            FileUtil.delete((File)file);
            return false;
        }
        Object object = this.lock(dataSource2);
        synchronized (object) {
            return DataSourceStorage.writeModel(file, dataSource2);
        }
    }

    private static boolean writeModel(@NotNull File file, @NotNull LocalDataSource dataSource2) throws IOException {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(24);
        }
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(25);
        }
        String name = dataSource2.getName();
        DasModel model = dataSource2.getModel();
        TreePattern scope = dataSource2.getIntrospectionScope();
        DataSourceStorage.writeModel(file, model, name, scope);
        return true;
    }

    public static void writeModel(@NotNull File file, DasModel model, String name, TreePattern scope) throws IOException {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(26);
        }
        DataSourceStorage.writeHugeFileSafe(file, (ThrowableConsumer<OutputStream, IOException>)((ThrowableConsumer)out -> {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);
            writer.startNode("dataSource");
            writer.addAttribute("name", name);
            ModelSerializerKt.serialize(model, (HierarchicalStreamWriter)writer, scope);
            writer.endNode();
            writer.close();
        }));
    }

    private static void writeHugeFileSafe(@NotNull File file, @NotNull ThrowableConsumer<OutputStream, IOException> consumer2) throws IOException {
        int bufferSize;
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(27);
        }
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(28);
        }
        SafeFileOutputStream safe2 = (bufferSize = Registry.intValue((String)"database.storage.output.buffer")) < 0 ? new SafeFileOutputStream(file) : new PreemptiveSafeFileOutputStream(file.toPath());
        try (Object out = bufferSize < 0 ? safe2 : new BufferedOutputStream((OutputStream)safe2, bufferSize);){
            consumer2.consume(out);
        }
        catch (Throwable t) {
            if (safe2 instanceof PreemptiveSafeFileOutputStream) {
                ((PreemptiveSafeFileOutputStream)safe2).abort();
            } else {
                safe2.abort();
            }
            throw t;
        }
    }

    private static boolean isReadonly(@Nullable Project project, @NotNull String path) {
        VirtualFile virtualFile;
        if (path == null) {
            DataSourceStorage.$$$reportNull$$$0(29);
        }
        VirtualFile virtualFile2 = virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        if (virtualFile == null) {
            return false;
        }
        boolean[] readOnly = new boolean[1];
        UIUtil.invokeAndWaitIfNeeded(() -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            readOnly[0] = !project.isDisposed() && !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        }));
        return readOnly[0];
    }

    public boolean readModel(@Nullable Project project, @NotNull LocalDataSource dataSource2, boolean oldMistakenFile, @NotNull PairConsumer<LocalDataSource, DasModel> consumer2) throws IOException {
        File file;
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(30);
        }
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(31);
        }
        ProgressManager.checkCanceled();
        if (project != null && project.isDefault()) {
            return false;
        }
        String path = this.getModelPath(project, dataSource2, oldMistakenFile);
        File file2 = file = path == null ? null : new File(path);
        if (file == null || !file.exists()) {
            return false;
        }
        DasModel model = DataSourceStorage.readModel(DbSrcModelStorage.createFactory(project, dataSource2), file, dataSource2.getName());
        if (model == null) {
            return false;
        }
        consumer2.consume((Object)dataSource2, (Object)model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DasModel readModel(@NotNull ModelFactory modelFactory, @NotNull File file, @Nullable String dataSourceName) throws IOException {
        if (modelFactory == null) {
            DataSourceStorage.$$$reportNull$$$0(32);
        }
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(33);
        }
        try (XppReader reader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), (XmlPullParser)new MXParser());){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("database-model".equals(reader.getNodeName())) {
                    BasicModModel basicModModel = ModelSerializerKt.deserialize((HierarchicalStreamReader)reader, modelFactory, dataSourceName);
                    return basicModModel;
                }
                reader.moveUp();
            }
        }
        return null;
    }

    @Nullable
    protected String getModelPath(@Nullable Project project, @NotNull LocalDataSource dataSource2, boolean oldMistakenPlace) {
        Object dir;
        if (dataSource2 == null) {
            DataSourceStorage.$$$reportNull$$$0(34);
        }
        if ((dir = DataSourceStorage.getStorageDir(project)) != null && project != null && oldMistakenPlace) {
            dir = PathUtil.getParentPath((String)dir) + "/" + project.getName();
        }
        return dir == null ? null : (String)dir + "/" + dataSource2.getUniqueId() + ".xml";
    }

    @TestOnly
    public Element getStateInner(@Nullable Project project) {
        Element element2 = new Element(COMPONENT_NAME);
        this.writeStateInner(project, element2);
        return element2;
    }

    private void writeStateInner(Project project, Element element2) {
        boolean notEmpty;
        boolean bl = notEmpty = !this.myDataSources.isEmpty();
        if (notEmpty || this.myFormat != Format.XML) {
            element2.setAttribute(FORMAT_ATTR_NAME, StringUtil.toLowerCase((String)this.myFormat.name()));
            if (this.myMultiFileModel) {
                element2.setAttribute(MULTIFILE_MODEL, "true");
            }
        }
        if (notEmpty) {
            JDomWriter serializer = new JDomWriter(element2);
            for (LocalDataSource dataSource2 : this.myDataSources) {
                dataSource2.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.CONFIG);
            }
        }
        this.writeLocalState(project);
    }

    private static void readDataSources(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource.SaveMode mode, @Nullable Project project, boolean isGlobal, @NotNull Function<String, LocalDataSource> dataSourceLocator, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (xmlReader == null) {
            DataSourceStorage.$$$reportNull$$$0(35);
        }
        if (mode == null) {
            DataSourceStorage.$$$reportNull$$$0(36);
        }
        if (dataSourceLocator == null) {
            DataSourceStorage.$$$reportNull$$$0(37);
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String source = xmlReader.getAttribute("source");
            if ("data-source".equals(xmlReader.getNodeName())) {
                LocalDataSource existingDataSource;
                String uuid = xmlReader.getAttribute("uuid");
                LocalDataSource localDataSource = existingDataSource = uuid == null ? null : (LocalDataSource)dataSourceLocator.fun((Object)uuid);
                if (existingDataSource != null || mode.includeConfig()) {
                    LocalDataSource dataSource2;
                    if (existingDataSource != null) {
                        dataSource2 = existingDataSource;
                    } else if (source == null || "LOCAL".equals(source)) {
                        dataSource2 = new LocalDataSource();
                    } else {
                        LOG.warn("Unsupported source: " + source);
                        dataSource2 = null;
                    }
                    if (dataSource2 != null) {
                        dataSource2.deserialize(project, xmlReader, mode);
                        dataSource2.setGlobal(isGlobal);
                        if (existingDataSource != dataSource2 && newDataSourcesConsumer != null) {
                            newDataSourcesConsumer.consume((Object)dataSource2);
                        }
                    }
                }
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToDisk(@Nullable Project project, @NotNull String storagePath, LocalDataSource.SaveMode mode) {
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(38);
        }
        File original = new File(PathUtil.toPresentableUrl((String)storagePath));
        if (this.myDataSources.isEmpty()) {
            FileUtil.delete((File)original);
            return true;
        }
        if (!original.exists()) {
            FileUtil.createParentDirs((File)original);
        }
        Object serializer = null;
        String errorMessage = null;
        try {
            Object os;
            SafeFileOutputStream safeStream = new SafeFileOutputStream(original);
            boolean compressed = this.myFormat == Format.COMPRESSED_XML || this.myFormat == Format.COMPRESSED_JSON;
            boolean isXml = this.myFormat == Format.XML || this.myFormat == Format.COMPRESSED_XML;
            Object object = os = compressed ? new ZipOutputStream((OutputStream)safeStream) : safeStream;
            if (os instanceof ZipOutputStream) {
                ((ZipOutputStream)os).putNextEntry(new ZipEntry(STORAGE_ENTRY_NAME + (isXml ? ".xml" : ".json")));
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
            if (isXml) {
                serializer = new PrettyPrintWriter((Writer)printWriter);
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                serializer = new JsonWriter(printWriter, new JsonWriter.Format(new char[]{' '}, new char[]{'\n'}, 2)){

                    protected void addValue(String value2, AbstractJsonWriter.Type type) {
                        super.addValue(value2, AbstractJsonWriter.Type.STRING);
                    }
                };
            }
            serializer.startNode("component");
            serializer.addAttribute("name", COMPONENT_NAME);
            for (LocalDataSource dataSource2 : this.myDataSources) {
                dataSource2.serialize(project, (HierarchicalStreamWriter)serializer, mode);
            }
            serializer.endNode();
            serializer.close();
        }
        catch (XStreamException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        finally {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            LOG.warn(errorMessage);
            DataSourceUiUtil.showNotification(project, "", DatabaseBundle.message((String)"notification.content.failed.to.save.data.sources.br", (Object[])new Object[]{errorMessage}), true);
            return false;
        }
        return true;
    }

    @TestOnly
    public void loadTestsStorage(@NotNull Project project, @NotNull String storagePath) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(39);
        }
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(40);
        }
        for (LocalDataSource dataSource2 : this.loadFromDisk(project, Paths.get(storagePath, new String[0]), LocalDataSource.SaveMode.ALL, null)) {
            this.addDataSourceInner(dataSource2);
            DbUIUtil.invokeOnPooledThreadSync(() -> DataSourceSnapshotManager.INSTANCE.apply(project, dataSource2));
        }
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
        this.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<LocalDataSource> loadFromDisk(@Nullable Project project, @NotNull Path file, LocalDataSource.SaveMode mode, @Nullable ErrorHandler errorHandler) {
        block23: {
            List<LocalDataSource> list;
            if (file == null) {
                DataSourceStorage.$$$reportNull$$$0(41);
            }
            if (file == null || !Files.exists(file, new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0])) {
                return null;
            }
            boolean isGlobal = this.getParentStorage() == null;
            Function dataSourceLocator = uuid -> DataSourceStorage.getDataSourcesByIdInner(uuid, this.myDataSources);
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
                boolean isReallyZip = false;
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    boolean isXml = Objects.equals(zipEntry.getName(), STATE_FILE);
                    if (isXml || Objects.equals(zipEntry.getName(), "dataSources.json")) {
                        List<LocalDataSource> list2 = DataSourceStorage.loadFromDisk(zis, isXml, mode, project, errorHandler, isGlobal, (Function<String, LocalDataSource>)dataSourceLocator);
                        return list2;
                    }
                    isReallyZip = true;
                    zipEntry = zis.getNextEntry();
                }
                if (isReallyZip) {
                    LOG.warn("No datasource entries found in: " + file);
                    break block23;
                }
                list = DataSourceStorage.loadFromDisk(Files.newInputStream(file, new OpenOption[0]), DataSourceStorage.checkXml(file), mode, project, errorHandler, isGlobal, (Function<String, LocalDataSource>)dataSourceLocator);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (AssertionError | Exception e) {
                DataSourceStorage.processCorruption(file, (Throwable)e);
                break block23;
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return list;
        }
        return null;
    }

    public static void processCorruption(@NotNull Path file, Throwable e) {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(42);
        }
        String reason = ExceptionUtil.getThrowableText((Throwable)e);
        String message2 = e.getMessage();
        if (message2 != null && message2.length() > 1024) {
            RuntimeException truncated = new RuntimeException(message2.substring(0, 1024) + "...");
            truncated.setStackTrace(e.getStackTrace());
            e = truncated;
        }
        LOG.warn(e);
        DataSourceStorage.backupCorruptedVersion(file, reason);
    }

    protected static boolean checkXml(@NotNull Path file) throws IOException {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(43);
        }
        try (InputStreamReader formatPicker = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            boolean bl = StringUtil.isNotEmpty((String)NanoXmlUtil.parseHeader((Reader)formatPicker).getRootTagLocalName());
            return bl;
        }
    }

    @TestOnly
    public static List<LocalDataSource> loadFromDisk(Project project, @NotNull InputStream stream, LocalDataSource.SaveMode mode, ErrorHandler handler) {
        if (stream == null) {
            DataSourceStorage.$$$reportNull$$$0(44);
        }
        return DataSourceStorage.loadFromDisk(stream, true, mode, project, handler, false, (Function<String, LocalDataSource>)((Function)uuid -> null));
    }

    protected static List<LocalDataSource> loadFromDisk(@NotNull InputStream stream, boolean isXml, LocalDataSource.SaveMode mode, @Nullable Project project, @Nullable ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        if (stream == null) {
            DataSourceStorage.$$$reportNull$$$0(45);
        }
        InputStreamReader fileReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        return DataSourceStorage.loadDataSources((HierarchicalStreamReader)(isXml ? new XppReader((Reader)fileReader) : new JettisonMappedXmlDriver().createReader((Reader)fileReader)), mode, project, errorHandler, isGlobal, dataSourceLocator);
    }

    private static void backupCorruptedVersion(@NotNull Path file, String reason) {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(46);
        }
        if (Files.exists(file, new LinkOption[0])) {
            try {
                String backupPrefix = FileUtilRt.getNameWithoutExtension((String)file.getFileName().toString()) + ".corrupted." + new SimpleDateFormat("yyyyMMdd-hhmmss").format(new Date(System.currentTimeMillis()));
                String backupName = backupPrefix + "." + FileUtilRt.getExtension((String)file.getFileName().toString());
                String backupReason = backupPrefix + ".reason.txt";
                File backup = file.getParent().resolve(backupName).toFile();
                FileUtil.rename((File)file.toFile(), (File)backup);
                FileUtil.writeToFile((File)file.getParent().resolve(backupReason).toFile(), (String)reason);
                String message2 = DatabaseBundle.message((String)"notification.content.corrupted.backup.copy.created", (Object[])new Object[]{file.toAbsolutePath().toString(), backup.getName()});
                Notification notification = new Notification("System Messages", DatabaseBundle.message((String)"notification.title.failed.to.load.data.sources", (Object[])new Object[0]), message2, NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<LocalDataSource> loadDataSources(HierarchicalStreamReader reader, LocalDataSource.SaveMode mode, Project project, final ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        MyReader wrapper = new MyReader(reader){

            public void appendErrors(ErrorWriter errorWriter) {
                super.appendErrors(errorWriter);
                if (errorHandler != null && errorWriter instanceof ConversionException) {
                    errorHandler.addError(((ConversionException)errorWriter).getShortMessage(), null);
                }
            }
        };
        try {
            if ("component".equals(reader.getNodeName())) {
                ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
                DataSourceStorage.readDataSources((HierarchicalStreamReader)wrapper, mode, project, isGlobal, dataSourceLocator, (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
                ArrayList<LocalDataSource> arrayList = newDataSources;
                return arrayList;
            }
            List<LocalDataSource> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    Listener createSavingListener(final @Nullable Project project) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            return null;
        }
        return new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                Map<String, Object> map2 = DataSourceStorage.this.myLocks;
                synchronized (map2) {
                    DataSourceStorage.this.myLocks.remove(dataSource2.getUniqueId());
                }
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    return;
                }
                this.saveDataSource(dataSource2);
            }

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                this.saveDataSource(dataSource2);
            }

            private void saveDataSource(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (dataSource2.isInBatch() || dataSource2.isLoading()) {
                    return;
                }
                if (!DataSourceStorage.this.myDataSources.contains(dataSource2)) {
                    return;
                }
                LOG.debug("Scheduling save " + dataSource2.getName());
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.save(dataSource2));
            }

            private void save(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                if (!DataSourceStorage.this.myDataSources.contains(dataSource2)) {
                    return;
                }
                if ((project == null ? ApplicationManager.getApplication() : project).isDisposed()) {
                    return;
                }
                try {
                    DataSourceStorage.this.writeModel(project, dataSource2);
                }
                catch (IOException e) {
                    LOG.error("Failed to save model for: " + dataSource2.getName(), (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "saveDataSource";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Object lock(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceStorage.$$$reportNull$$$0(47);
        }
        Map<String, Object> map2 = this.myLocks;
        // MONITORENTER : map2
        Object object = this.myLocks.get(ds.getUniqueId());
        // MONITOREXIT : map2
        if (object != null) return object;
        DataSourceStorage.$$$reportNull$$$0(48);
        return object;
    }

    @TestOnly
    public void prune() {
        this.removeAllDataSources();
    }

    private /* synthetic */ void lambda$readStateHeavy$7(AsyncPromise promise, Project project, ComponentManager disposable2, LocalDataSource dataSource2, DasModel model) {
        if (promise != this.myLoadedPromise.get()) {
            throw new ProcessCanceledException();
        }
        DataSourceStorage.migrateStorage(project, dataSource2, model);
        GuiUtils.invokeLaterIfNeeded(() -> {
            dataSource2.setModel(model);
            dataSource2.setLoading(false);
        }, (ModalityState)ModalityState.defaultModalityState(), (Condition)disposable2.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = STORAGE_ENTRY_NAME;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 23: 
            case 25: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 17: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDataSources";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceLocator";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnDataSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesImpl";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readFormat";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doWhenInitialized";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourcesInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourceInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSourceInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesByIdInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readLocalState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readStateHeavy";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateModels";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadModels";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanupOldFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readFormat";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeModel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeHugeFileSafe";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isReadonly";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readModel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModelPath";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readDataSources";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "writeToDisk";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadTestsStorage";
                break;
            }
            case 41: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDisk";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processCorruption";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkXml";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "backupCorruptedVersion";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReader
    extends ReaderWrapper {
        MyReader(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getNodeName() {
            return DbUtil.intern2((String)super.getNodeName());
        }

        public String getValue() {
            return DbUtil.intern2((String)super.getValue());
        }

        public String getAttribute(String name) {
            return DbUtil.intern2((String)super.getAttribute(name));
        }

        public String getAttribute(int index2) {
            return DbUtil.intern2((String)super.getAttribute(index2));
        }
    }

    @State(name="DataSourceManagerImpl", storages={@Storage(value="dataSources.xml")})
    public static class Prj
    extends DataSourceStorage
    implements PersistentStateComponent<Element> {
        private final Project myProject;

        public Prj(Project project) {
            super(project.getMessageBus());
            this.myProject = project;
            Listener listener2 = this.createSavingListener(null);
            if (listener2 != null) {
                project.getMessageBus().connect().subscribe(TOPIC, (Object)this.createSavingListener(this.myProject));
            }
        }

        @Override
        @Nullable
        protected DataSourceStorage getParentStorage() {
            return Prj.getStorage();
        }

        @Override
        public void doWhenInitialized(@NotNull Runnable runnable) {
            if (runnable == null) {
                Prj.$$$reportNull$$$0(0);
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> super.doWhenInitialized(runnable));
        }

        @Override
        public void updateDataSource(LocalDataSource dataSource2) {
            super.updateDataSource(dataSource2);
            TransactionGuard.submitTransaction((Disposable)this.myProject, () -> PsiDocumentManager.getInstance((Project)this.myProject).reparseFiles(Collections.emptyList(), true));
        }

        @Override
        public void loadState(@NotNull Element state) {
            if (state == null) {
                Prj.$$$reportNull$$$0(1);
            }
            this.readState(this.myProject, state);
        }

        @Override
        public Element getState() {
            Element element2 = new Element("DataSourceManagerImpl");
            this.writeState(this.myProject, element2);
            return element2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Prj";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doWhenInitialized";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="dataSourceStorage", storages={@Storage(value="dataSources.xml")})
    public static class App
    extends DataSourceStorage
    implements PersistentStateComponent<Element> {
        public App() {
            super(ApplicationManager.getApplication().getMessageBus());
            Application app = ApplicationManager.getApplication();
            Listener listener2 = this.createSavingListener(null);
            if (listener2 != null) {
                app.getMessageBus().connect((Disposable)app).subscribe(TOPIC, (Object)listener2);
            }
        }
    }

    private static enum Format {
        XML,
        JSON,
        COMPRESSED_XML,
        COMPRESSED_JSON;

    }

    public static interface Listener
    extends EventListener {
        default public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

