/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDomain
extends Domain {
    private final Cardinality.TextCardinality myCardinality;
    private final Length myLengthCaps;
    private final long myLength;

    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength) {
        if (name == null) {
            TextDomain.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(1);
        }
        this(name, descriptor2, maxLength, Length.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength, @NotNull OperationSupport operationSupport) {
        void supportChecker;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(3);
        }
        if (operationSupport == null) {
            TextDomain.$$$reportNull$$$0(4);
        }
        this(name, descriptor2, maxLength, Length.NONE, (OperationSupport)supportChecker);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength, long defaultValue, boolean bl, boolean bl2) {
        void variable;
        void narrowable;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(6);
        }
        this(name, descriptor2, maxLength, defaultValue, (boolean)narrowable, (boolean)variable, OperationSupport.DEFAULT_OPERATION_SUPPORT);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength, long defaultValue, boolean narrowable, boolean bl, @NotNull OperationSupport operationSupport) {
        void supportChecker;
        void variable;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(8);
        }
        if (operationSupport == null) {
            TextDomain.$$$reportNull$$$0(9);
        }
        this(name, descriptor2, maxLength, narrowable ? Length.optional(defaultValue == -1L ? maxLength : defaultValue, (boolean)variable) : Length.fixed(defaultValue), (OperationSupport)supportChecker);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength, Length length) {
        void lengthCaps;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(11);
        }
        this(name, descriptor2, maxLength, (Length)lengthCaps, OperationSupport.DEFAULT_OPERATION_SUPPORT);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long maxLength, Length lengthCaps, @NotNull OperationSupport operationSupport) {
        void operationSupport2;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(13);
        }
        if (operationSupport == null) {
            TextDomain.$$$reportNull$$$0(14);
        }
        super(descriptor2, PhysicalDomainType.TEXT, name, (OperationSupport)operationSupport2);
        this.myLength = maxLength;
        this.myCardinality = new Cardinality.TextCardinality(maxLength);
        this.myLengthCaps = lengthCaps;
    }

    public boolean isVariable() {
        return this.myLengthCaps.isVariable();
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(15);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? this.compareWithLength((BinaryDomain)domain) : (domain instanceof TextDomain ? (((TextDomain)domain).getEffectiveLength() <= this.getEffectiveLength() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.incompatibleLossless(this.cardinality(), TextDomain.getLogicalType(domain), this.getLogicType()));
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(16);
        }
        return compatibility;
    }

    @NotNull
    private static LogicalType getLogicalType(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(17);
        }
        LogicalType logicalType = domain instanceof TextPreferable ? ((TextPreferable)((Object)domain)).getFakeType() : domain.getLogicType();
        if (logicalType == null) {
            TextDomain.$$$reportNull$$$0(18);
        }
        return logicalType;
    }

    @NotNull
    private Compatibility compareWithLength(@NotNull BinaryDomain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(19);
        }
        Compatibility compatibility = domain.getEffectiveUpperBound() <= this.getEffectiveLength() ? Compatibility.incompatibleLossless(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(20);
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.TextCardinality textCardinality = this.myCardinality;
        if (textCardinality == null) {
            TextDomain.$$$reportNull$$$0(21);
        }
        return textCardinality;
    }

    public long getLength() {
        return this.myLength;
    }

    public long getEffectiveLength() {
        return this.myLengthCaps.getEffectiveLength(this.myLength);
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            TextDomain.$$$reportNull$$$0(22);
        }
        return this.getLength() != 0L && o instanceof String ? ((String)o).substring(0, (int)Math.min(this.getLength(), (long)((String)o).length())) : o;
    }

    public long getDefaultValue() {
        return this.myLengthCaps.defaultLength;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(23);
        }
        Domain domain2 = this.myLengthCaps.isNarrowable() && domain instanceof TextDomain ? this.create(Math.min(((TextDomain)domain).getEffectiveLength(), this.getEffectiveLength())) : this;
        if (domain2 == null) {
            TextDomain.$$$reportNull$$$0(24);
        }
        return domain2;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            TextDomain.$$$reportNull$$$0(25);
        }
        if (!this.myLengthCaps.isNarrowable()) {
            TextDomain textDomain = this;
            if (textDomain == null) {
                TextDomain.$$$reportNull$$$0(26);
            }
            return textDomain;
        }
        int size = provider.getSize();
        Domain domain = this.create(size > 0 ? Math.min((long)size, this.getEffectiveLength()) : this.myLengthCaps.defaultLength);
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(27);
        }
        return domain;
    }

    protected Domain create(long length) {
        return new TextDomain(this.simpleName(), this.getPoint(), length, this.myLengthCaps);
    }

    @Override
    @NotNull
    public String name() {
        Object object = this.myLengthCaps.shouldAddLength(this.getLength()) ? this.simpleName() + "(" + this.getEffectiveLength() + ")" : super.name();
        if (object == null) {
            TextDomain.$$$reportNull$$$0(28);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportChecker";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSupport";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithLength";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "compareWithLength";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Length {
        public final long defaultLength;
        public final Boolean hasCustomLength;
        public final boolean variable;
        public static final Length NONE = new Length(-1L, false, true);
        public static final Length MANDATORY = new Length(-1L, true, false);
        public static final Length MANDATORY_VAR = new Length(-1L, true, true);

        public static Length mandatory(boolean variable) {
            return variable ? MANDATORY_VAR : MANDATORY;
        }

        public static Length fixed(long length) {
            return length == -1L ? NONE : new Length(length, false, false);
        }

        public static Length mandatory(long fallbackLength, boolean variable) {
            return fallbackLength == -1L ? Length.mandatory(variable) : new Length(fallbackLength, true, variable);
        }

        public static Length optional(long length, boolean variable) {
            return length == -1L ? Length.mandatory(variable) : new Length(length, null, variable);
        }

        private Length(long defaultLength, Boolean hasCustomLength, boolean variable) {
            this.defaultLength = defaultLength;
            this.hasCustomLength = hasCustomLength;
            this.variable = variable;
        }

        public boolean isNarrowable() {
            return !this.isFixed();
        }

        public boolean isOptional() {
            return this.hasCustomLength == null;
        }

        public boolean isFixed() {
            return Boolean.FALSE.equals(this.hasCustomLength);
        }

        public boolean shouldAddLength(long length) {
            if (this.isFixed()) {
                return false;
            }
            if (this.isOptional()) {
                return length != this.defaultLength && length > 0L;
            }
            return true;
        }

        public long getEffectiveLength(long length) {
            return length > 0L ? length : this.defaultLength;
        }

        public boolean isVariable() {
            return this.variable;
        }
    }

    public static interface TextPreferable {
        @NotNull
        public LogicalType getFakeType();
    }
}

