/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomainRegistry {
    public static final DbmsExtension<DomainRegistry> EP = new DbmsExtension("com.intellij.database.domainRegistry");
    public static final Function<Domain, Comparator<Domain>> COMPARATOR_GENERATOR = domain -> (o1, o2) -> {
        Compatibility first2 = o1.getCompatibility((Domain)domain);
        Compatibility second = o2.getCompatibility((Domain)domain);
        return first2.compareTo(second);
    };
    private final Set<Domain> mySet = new LinkedHashSet<Domain>();

    protected DomainRegistry() {
    }

    @Nullable
    public Domain getDomain(@NotNull ColumnDescriptor descriptor2) {
        if (descriptor2 == null) {
            DomainRegistry.$$$reportNull$$$0(0);
        }
        return (Domain)ContainerUtil.find(this.mySet, domain -> domain.isSuitable(descriptor2));
    }

    @NotNull
    public Collection<Domain> getDomains() {
        Set<Domain> set = Collections.unmodifiableSet(this.mySet);
        if (set == null) {
            DomainRegistry.$$$reportNull$$$0(1);
        }
        return set;
    }

    public boolean isSuitable(@Nullable Version productVersion) {
        return true;
    }

    protected final void add(@NotNull Domain domain) {
        String name;
        if (domain == null) {
            DomainRegistry.$$$reportNull$$$0(2);
        }
        if (ContainerUtil.find(this.mySet, arg_0 -> DomainRegistry.lambda$add$3(name = domain.name(), arg_0)) != null) {
            throw new AssertionError((Object)("Already have domain " + name + " in " + this.getClass().getSimpleName()));
        }
        this.mySet.add(domain);
    }

    protected final void remove(@NotNull String name) {
        if (name == null) {
            DomainRegistry.$$$reportNull$$$0(3);
        }
        if (!this.mySet.removeIf(d2 -> d2.name().equals(name))) {
            throw new AssertionError((Object)("No domain " + name + " in " + this.getClass().getSimpleName()));
        }
    }

    @NotNull
    public static Domain getMostRecentDomain(@NotNull Domain domain, @NotNull Dbms dbms, @Nullable Version version) {
        DomainRegistry registry;
        if (domain == null) {
            DomainRegistry.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            DomainRegistry.$$$reportNull$$$0(5);
        }
        if ((registry = DomainRegistry.get(dbms, version)) == null) {
            Domain domain2 = Domain.EMPTY;
            if (domain2 == null) {
                DomainRegistry.$$$reportNull$$$0(6);
            }
            return domain2;
        }
        Collection<Domain> domains = registry.getDomains();
        Domain unwrapped = DataGridUtil.unwrap(domain);
        List filtered2 = ContainerUtil.filter(domains, current -> current.contains(unwrapped));
        Comparator domainComparator = (Comparator)COMPARATOR_GENERATOR.fun((Object)unwrapped);
        ContainerUtil.sort((List)filtered2, (Comparator)domainComparator);
        Domain item = (Domain)ContainerUtil.getFirstItem((List)filtered2);
        Domain domain3 = item == null ? Domain.EMPTY : item.narrow(unwrapped);
        if (domain3 == null) {
            DomainRegistry.$$$reportNull$$$0(7);
        }
        return domain3;
    }

    @Nullable
    public static DomainRegistry get(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            DomainRegistry.$$$reportNull$$$0(8);
        }
        for (DomainRegistry registry : EP.allForDbms(dbms)) {
            if (!registry.isSuitable(version)) continue;
            return registry;
        }
        return null;
    }

    @Nullable
    public static Domain getDomain(@NotNull Dbms dbms, @Nullable Version version, @NotNull ColumnDescriptor descriptor2, boolean raw) {
        DomainRegistry registry;
        Domain domain;
        if (dbms == null) {
            DomainRegistry.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            DomainRegistry.$$$reportNull$$$0(10);
        }
        Domain domain2 = domain = (registry = DomainRegistry.get(dbms, version)) == null ? null : registry.getDomain(descriptor2);
        return domain == null ? null : (raw ? domain : domain.narrow(descriptor2));
    }

    private static /* synthetic */ boolean lambda$add$3(String name, Domain d2) {
        return d2.name().equals(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/DomainRegistry";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/DomainRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomains";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostRecentDomain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDomain";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMostRecentDomain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CommonLimits {
        public static final double BIGINT_UNSIGNED_MAX = Math.pow(2.0, 64.0) - 1.0;
    }

    public static class Limits {
        private final Limit[] myLimits;

        public Limits(Limit ... limits) {
            if (limits == null) {
                Limits.$$$reportNull$$$0(0);
            }
            this.myLimits = limits;
            Arrays.sort(this.myLimits);
        }

        @NotNull
        public Number minValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(1);
            }
            return this.get(parameterValue, (Function<Limit, Number>)((Function)Limit::getMinValue));
        }

        @NotNull
        public Number maxValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(2);
            }
            return this.get(parameterValue, (Function<Limit, Number>)((Function)Limit::getMaxValue));
        }

        @NotNull
        public Number min() {
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMinValue();
            if (number == null) {
                Limits.$$$reportNull$$$0(3);
            }
            return number;
        }

        @NotNull
        public Number max() {
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxValue();
            if (number == null) {
                Limits.$$$reportNull$$$0(4);
            }
            return number;
        }

        @NotNull
        public Number parameterValueFromMax(@NotNull Number maxValue) {
            if (maxValue == null) {
                Limits.$$$reportNull$$$0(5);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxValue().doubleValue(), maxValue.doubleValue()) < 0) continue;
                Number number = limit.getMaxParameter();
                if (number == null) {
                    Limits.$$$reportNull$$$0(6);
                }
                return number;
            }
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxParameter();
            if (number == null) {
                Limits.$$$reportNull$$$0(7);
            }
            return number;
        }

        @NotNull
        public Number minParameterValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(8);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxParameter().doubleValue(), parameterValue.doubleValue()) < 0) continue;
                Number number = limit.getMaxParameter();
                if (number == null) {
                    Limits.$$$reportNull$$$0(9);
                }
                return number;
            }
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxParameter();
            if (number == null) {
                Limits.$$$reportNull$$$0(10);
            }
            return number;
        }

        @NotNull
        private Number get(@NotNull Number parameter, @NotNull Function<Limit, Number> getter) {
            if (parameter == null) {
                Limits.$$$reportNull$$$0(11);
            }
            if (getter == null) {
                Limits.$$$reportNull$$$0(12);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxParameter().doubleValue(), parameter.doubleValue()) <= 0) continue;
                Number number = (Number)getter.fun((Object)limit);
                if (number == null) {
                    Limits.$$$reportNull$$$0(13);
                }
                return number;
            }
            Number number = (Number)getter.fun((Object)((Limit)ArrayUtil.getFirstElement((Object[])this.myLimits)));
            if (number == null) {
                Limits.$$$reportNull$$$0(14);
            }
            return number;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "limits";
                    break;
                }
                case 1: 
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DomainRegistry$Limits";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DomainRegistry$Limits";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "min";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "max";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parameterValueFromMax";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "minParameterValue";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "minValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "maxValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parameterValueFromMax";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "minParameterValue";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Limit
    implements Comparable<Limit> {
        private final Number myMaxParameter;
        private final Number myMaxValue;
        private final Number myMinValue;

        public Limit(@NotNull Number maxParameter, @NotNull Number minValue, @NotNull Number maxValue) {
            if (maxParameter == null) {
                Limit.$$$reportNull$$$0(0);
            }
            if (minValue == null) {
                Limit.$$$reportNull$$$0(1);
            }
            if (maxValue == null) {
                Limit.$$$reportNull$$$0(2);
            }
            this.myMaxParameter = maxParameter;
            this.myMaxValue = maxValue;
            this.myMinValue = minValue;
        }

        @NotNull
        public Number getMaxParameter() {
            Number number = this.myMaxParameter;
            if (number == null) {
                Limit.$$$reportNull$$$0(3);
            }
            return number;
        }

        @NotNull
        public Number getMaxValue() {
            Number number = this.myMaxValue;
            if (number == null) {
                Limit.$$$reportNull$$$0(4);
            }
            return number;
        }

        @NotNull
        public Number getMinValue() {
            Number number = this.myMinValue;
            if (number == null) {
                Limit.$$$reportNull$$$0(5);
            }
            return number;
        }

        @Override
        public int compareTo(@NotNull Limit o) {
            if (o == null) {
                Limit.$$$reportNull$$$0(6);
            }
            return Double.compare(this.myMaxParameter.doubleValue(), o.myMaxParameter.doubleValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxParameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "minValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DomainRegistry$Limit";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DomainRegistry$Limit";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

