/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseLogViewService;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.SessionAuditService;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.TxIsolationAuditor;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.run.session.MessageBusSessionState;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u0000 U2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0005UVWXYB'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0014H\u0016J\b\u0010>\u001a\u00020<H\u0016J\u0010\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0014H\u0016J\b\u0010@\u001a\u00020<H\u0016J\u0018\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u0002H\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\fH\u0016J\b\u0010H\u001a\u00020\fH\u0016J\b\u0010I\u001a\u00020&H\u0016J\b\u0010J\u001a\u00020\bH\u0016J\b\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020\u001cH\u0016J\b\u0010N\u001a\u00020\u001cH\u0016J\u0010\u0010O\u001a\u00020<2\u0006\u0010P\u001a\u00020\u001cH\u0016J\u0010\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020DH\u0016J\u0010\u0010S\u001a\u00020<2\u0006\u0010T\u001a\u00020LH\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020)@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R(\u0010/\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/intellij/database/console/session/MessageBusSession;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable$Parent;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "kernel", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;Ljava/lang/String;)V", "auditService", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/AuditService;", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getClients", "()[Lcom/intellij/database/console/client/DatabaseSessionClient;", "clientsWithFile", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "getClientsWithFile", "()[Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "value", "", "isConnected", "()Z", "setConnected", "(Z)V", "isInternal", "isService", "getKernel", "()Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/run/session/MessageBusSessionState;", "state", "getState", "()Lcom/intellij/database/run/session/MessageBusSessionState;", "setState", "(Lcom/intellij/database/run/session/MessageBusSessionState;)V", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "view", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "getView", "()Lcom/intellij/database/console/session/DatabaseSessionLogView;", "wallet", "Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "wasPublicClient", "attach", "", "client", "beforeTreeDispose", "detach", "dispose", "exchange", "to", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getData", "", "dataId", "getDisplayName", "getMessageBus", "getTarget", "getTxIsolation", "", "isIdle", "isValid", "setAutoCommit", "autoCommit", "setCurrentTx", "marker", "setTxIsolation", "isolation", "Companion", "MessageBusSessionChangeEvent", "NaturalKernel", "SessionKernel", "Wallet", "intellij.database.impl"})
public class MessageBusSession
extends UserDataHolderBase
implements DatabaseSession,
DataProvider,
Disposable.Parent {
    @NotNull
    private String title;
    @NotNull
    private final AuditService auditService;
    private final boolean isService;
    private volatile boolean isConnected;
    @NotNull
    private MessageBusSessionState state;
    private final DataBus.Consuming messageBus;
    private final Wallet wallet;
    private boolean wasPublicClient;
    @NotNull
    private final Project project;
    private final LocalDataSource dataSource;
    @NotNull
    private final SessionKernel kernel;
    @NlsSafe
    @NotNull
    public static final String DEFAULT_SESSION_NAME = "default";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getTitle() {
        CharSequence charSequence = this.title;
        boolean bl = false;
        return charSequence.length() == 0 ? DEFAULT_SESSION_NAME : this.title;
    }

    @Override
    public void setTitle(@Nls @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        CharSequence charSequence = this.title;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        this.title = value2;
        MessageBusSession.Companion.syncPublisher().renamed(this);
    }

    @Override
    @NotNull
    public AuditService getAuditService() {
        return this.auditService;
    }

    @Override
    public boolean isService() {
        return this.isService;
    }

    @Override
    public boolean isInternal() {
        return !this.isService() && !this.wasPublicClient;
    }

    @Override
    @NotNull
    public DatabaseSessionLogView getView() {
        return DatabaseLogViewService.getView(this);
    }

    @Override
    @NotNull
    public DatabaseSessionClient[] getClients() {
        Collection $this$toTypedArray$iv = this.wallet.getAttached();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DatabaseSessionClient[] databaseSessionClientArray = thisCollection$iv.toArray(new DatabaseSessionClient[0]);
        if (databaseSessionClientArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return databaseSessionClientArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DatabaseSessionClientWithFile[] getClientsWithFile() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)this.wallet.getAttached(), DatabaseSessionClientWithFile.class);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSessionClientWithFile it2 = (DatabaseSessionClientWithFile)element$iv$iv;
            boolean bl = false;
            if (!(!it2.getDepartment().isInternal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DatabaseSessionClientWithFile[] databaseSessionClientWithFileArray = thisCollection$iv.toArray(new DatabaseSessionClientWithFile[0]);
        if (databaseSessionClientWithFileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return databaseSessionClientWithFileArray;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean value2) {
        this.isConnected = value2;
        DatabaseSessionStateListener listener2 = MessageBusSession.Companion.syncPublisher();
        if (value2) {
            listener2.connected(this);
        } else {
            listener2.disconnected(this);
        }
    }

    @Override
    @NotNull
    public MessageBusSessionState getState() {
        return this.state;
    }

    public void setState(@NotNull MessageBusSessionState value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ApplicationManager.getApplication().assertIsDispatchThread();
        DatabaseSessionStateListener.ChangeEvent.EventType eventType = this.state.isIdle() == value2.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.CHANGED : (this.state.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.STARTED : DatabaseSessionStateListener.ChangeEvent.EventType.STOPPED);
        this.state = value2;
        MessageBusSession.Companion.syncPublisher().stateChanged(new MessageBusSessionChangeEvent(this, eventType));
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        return this.kernel.getTxMarker();
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.kernel.setTxMarker(marker);
    }

    @Override
    public int getTxIsolation() {
        return this.kernel.getIsolation();
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.kernel.setIsolation(isolation);
    }

    @Override
    public boolean isIdle() {
        return this.kernel.getIdle();
    }

    @Override
    @NotNull
    public LocalDataSource getTarget() {
        return this.dataSource;
    }

    @Override
    public boolean isValid() {
        DatabaseSessionLogView view2 = DatabaseLogViewService.getViewIfAny(this);
        return (view2 == null || view2.isValid()) && !this.wallet.getDisposed() && JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), this.getTarget());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.getTitle();
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        return this.messageBus;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        DataRequest.TxMarker txMarker;
        if (autoCommit) {
            DataRequest.TxMarker txMarker2 = DataRequest.AUTO_COMMIT;
            txMarker = txMarker2;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker2, (String)"DataRequest.AUTO_COMMIT");
        } else {
            DataRequest.TxMarker txMarker3 = DataRequest.START_NEW;
            txMarker = txMarker3;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker3, (String)"DataRequest.START_NEW");
        }
        this.setCurrentTx(txMarker);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformDataKeys.HELP_ID.is(dataId) ? "reference.runToolWindow.jdbcTab" : (Session.SESSION_KEY.is(dataId) ? this : null);
    }

    public void dispose() {
    }

    public void beforeTreeDispose() {
        this.wallet.setDisposed(true);
    }

    @Override
    public void attach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.wallet.contains(client)) {
            return;
        }
        boolean wasInternal = this.isInternal();
        boolean bl = this.wasPublicClient = this.wasPublicClient || !client.getDepartment().isInternal();
        if (!this.isInternal()) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                DbUIUtil.invokeLaterIfNeeded(new Runnable(this){
                    final /* synthetic */ MessageBusSession this$0;

                    public final void run() {
                        DatabaseLogViewService.initView(this.this$0);
                    }
                    {
                        this.this$0 = messageBusSession;
                    }
                });
            }
        }
        if (wasInternal && !this.isInternal()) {
            DbUIUtil.invokeLaterIfNeeded(new Runnable(this){
                final /* synthetic */ MessageBusSession this$0;

                public final void run() {
                    MessageBusSessionChangeEvent event = new MessageBusSessionChangeEvent(this.this$0, DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED);
                    com.intellij.database.console.session.MessageBusSession$Companion.access$syncPublisher(MessageBusSession.Companion).stateChanged(event);
                }
                {
                    this.this$0 = messageBusSession;
                }
            });
        }
        this.wallet.attach(client);
    }

    @Override
    public void detach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.USER_REQUEST);
    }

    @Override
    public void exchange(@NotNull DatabaseSessionClient client, @NotNull DatabaseSession to) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            if (this.wallet.contains(client)) {
                this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.SESSION_SWITCH);
            }
            to.attach(client);
            DatabaseSessionClient databaseSessionClient = client;
            if (!(databaseSessionClient instanceof VisibleDatabaseSessionClient)) {
                databaseSessionClient = null;
            }
            VisibleDatabaseSessionClient visibleDatabaseSessionClient = (VisibleDatabaseSessionClient)databaseSessionClient;
            if (visibleDatabaseSessionClient == null) break block2;
            VisibleDatabaseSessionClient visibleDatabaseSessionClient2 = visibleDatabaseSessionClient;
            boolean bl = false;
            boolean bl2 = false;
            VisibleDatabaseSessionClient it2 = visibleDatabaseSessionClient2;
            boolean bl3 = false;
            MessageBusSession.Companion.syncPublisher().clientReattached(it2, this, to);
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    protected final SessionKernel getKernel() {
        return this.kernel;
    }

    public MessageBusSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull SessionKernel kernel, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.project = project;
        this.dataSource = dataSource2;
        this.kernel = kernel;
        this.title = name;
        this.auditService = new SessionAuditService(this);
        CharSequence charSequence = name;
        boolean bl = false;
        this.isService = charSequence.length() == 0;
        this.state = new MessageBusSessionState();
        DataBus.Consuming consuming = this.kernel.getConsuming().filterFor(this);
        Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"kernel.consuming.filterFor(this)");
        this.messageBus = consuming;
        this.wallet = new Wallet(this);
        this.kernel.init(this.getProject(), this);
        Disposer.register((Disposable)((Disposable)this.getProject()), (Disposable)this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "(Lcom/intellij/database/console/session/MessageBusSession;)V", "attached", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getAttached", "()Ljava/util/List;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "attach", "", "client", "canClose", "contains", "detach", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "disposeIfPossible", "intellij.database.impl"})
    private static final class Wallet {
        @NotNull
        private final List<DatabaseSessionClient> attached;
        private volatile boolean disposed;
        private final MessageBusSession session;

        @NotNull
        public final List<DatabaseSessionClient> getAttached() {
            return this.attached;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        public final boolean contains(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return this.attached.contains(client);
        }

        public final void attach(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, client){
                final /* synthetic */ Wallet this$0;
                final /* synthetic */ DatabaseSessionClient $client;

                public final void run() {
                    Collection collection = this.this$0.getAttached();
                    DatabaseSessionClient databaseSessionClient = this.$client;
                    boolean bl = false;
                    collection.add(databaseSessionClient);
                    if (this.$client instanceof VisibleDatabaseSessionClient) {
                        com.intellij.database.console.session.MessageBusSession$Companion.access$syncPublisher(MessageBusSession.Companion).clientAttached((VisibleDatabaseSessionClient)this.$client);
                    }
                }
                {
                    this.this$0 = wallet;
                    this.$client = databaseSessionClient;
                }
            });
            Disposer.register((Disposable)client, (Disposable)new Disposable(this, client){
                final /* synthetic */ Wallet this$0;
                final /* synthetic */ DatabaseSessionClient $client;

                public final void dispose() {
                    Wallet.access$disposeIfPossible(this.this$0, this.$client);
                }
                {
                    this.this$0 = wallet;
                    this.$client = databaseSessionClient;
                }
            });
        }

        public final void detach(@NotNull DatabaseSessionClient client, @NotNull DatabaseSessionClient.DetachTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
            this.disposeIfPossible(client);
            client.detached(trigger);
        }

        private final void disposeIfPossible(DatabaseSessionClient client) {
            DbUIUtil.invokeLaterIfNeeded(new Runnable(this, client){
                final /* synthetic */ Wallet this$0;
                final /* synthetic */ DatabaseSessionClient $client;

                public final void run() {
                    Collection collection = this.this$0.getAttached();
                    DatabaseSessionClient databaseSessionClient = this.$client;
                    boolean bl = false;
                    collection.remove(databaseSessionClient);
                    if (this.$client instanceof VisibleDatabaseSessionClient) {
                        com.intellij.database.console.session.MessageBusSession$Companion.access$syncPublisher(MessageBusSession.Companion).clientDetached((VisibleDatabaseSessionClient)this.$client);
                    }
                    if (this.this$0.getAttached().isEmpty() && Wallet.access$canClose(this.this$0, this.$client)) {
                        Disposer.dispose((Disposable)Wallet.access$getSession$p(this.this$0));
                    }
                }
                {
                    this.this$0 = wallet;
                    this.$client = databaseSessionClient;
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canClose(DatabaseSessionClient client) {
            if (this.session.isService()) return false;
            if (this.session.isInternal()) return true;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) return true;
            if (this.session.getCurrentTx().isTransactionInProgress()) return false;
            if (!(client instanceof DatabaseSessionClientWithFile)) return false;
            if (!((DatabaseSessionClientWithFile)client).getAutoClose()) return false;
            return true;
        }

        public Wallet(@NotNull MessageBusSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"ContainerUtil.createConcurrentList()");
            this.attached = (List)concurrentList;
        }

        public static final /* synthetic */ void access$disposeIfPossible(Wallet $this, DatabaseSessionClient client) {
            $this.disposeIfPossible(client);
        }

        public static final /* synthetic */ boolean access$canClose(Wallet $this, DatabaseSessionClient client) {
            return $this.canClose(client);
        }

        public static final /* synthetic */ MessageBusSession access$getSession$p(Wallet $this) {
            return $this.session;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "idle", "", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "intellij.database.impl"})
    public static interface SessionKernel {
        @NotNull
        public DataBus.Consuming getConsuming();

        @NotNull
        public DataRequest.TxMarker getTxMarker();

        public void setTxMarker(@NotNull DataRequest.TxMarker var1);

        public int getIsolation();

        public void setIsolation(int var1);

        public boolean getIdle();

        public void init(@NotNull Project var1, @NotNull MessageBusSession var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010+\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020/H\u0014J\u0018\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u000202H\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$NaturalKernel;", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Z)V", "broker", "Lcom/intellij/database/SimpleRequestBroker;", "kotlin.jvm.PlatformType", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "engine", "Lcom/intellij/database/console/AbstractEngine;", "getEngine", "()Lcom/intellij/database/console/AbstractEngine;", "setEngine", "(Lcom/intellij/database/console/AbstractEngine;)V", "idle", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "watcher", "Lcom/intellij/database/run/session/StateWatcher;", "createEngine", "bus", "Lcom/intellij/database/DataBus$Producing;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "init", "", "Lcom/intellij/database/console/session/MessageBusSession;", "intellij.database.impl"})
    public static class NaturalKernel
    implements SessionKernel {
        private final SimpleRequestBroker broker;
        private StateWatcher watcher;
        private volatile int isolation;
        @NotNull
        private volatile DataRequest.TxMarker txMarker;
        @NotNull
        public AbstractEngine engine;
        private final LocalDataSource dataSource;
        private final DatabaseCredentials credentialsStore;
        private final boolean silent;

        @Override
        public int getIsolation() {
            return this.isolation;
        }

        @Override
        public void setIsolation(int n) {
            this.isolation = n;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getTxMarker() {
            return this.txMarker;
        }

        @Override
        public void setTxMarker(@NotNull DataRequest.TxMarker txMarker) {
            Intrinsics.checkNotNullParameter((Object)txMarker, (String)"<set-?>");
            this.txMarker = txMarker;
        }

        @Override
        @NotNull
        public DataBus.Consuming getConsuming() {
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            return simpleRequestBroker;
        }

        @Override
        public boolean getIdle() {
            StateWatcher stateWatcher = this.watcher;
            if (stateWatcher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watcher");
            }
            return stateWatcher.isIdle();
        }

        @NotNull
        public final AbstractEngine getEngine() {
            AbstractEngine abstractEngine = this.engine;
            if (abstractEngine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            }
            return abstractEngine;
        }

        public final void setEngine(@NotNull AbstractEngine abstractEngine) {
            Intrinsics.checkNotNullParameter((Object)abstractEngine, (String)"<set-?>");
            this.engine = abstractEngine;
        }

        @Override
        public void init(@NotNull Project project, @NotNull MessageBusSession session2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            this.engine = this.createEngine(project, simpleRequestBroker, this.dataSource, this.credentialsStore, session2);
            session2.messageBus.addAuditor(new AuditorChain(new TxIsolationAuditor(session2), new TxMarkerAuditor(session2)));
            Disposable disposable2 = session2;
            AbstractEngine abstractEngine = this.engine;
            if (abstractEngine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            }
            Disposer.register((Disposable)disposable2, (Disposable)abstractEngine);
            this.watcher = new StateWatcher.DatabaseSessionWatcher(session2);
        }

        @NotNull
        protected AbstractEngine createEngine(@NotNull Project project, @NotNull DataBus.Producing bus, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, @NotNull DatabaseSession session2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            JdbcEngine jdbcEngine = new JdbcEngine(project, bus, dataSource2, credentialsStore, session2);
            boolean bl = false;
            boolean bl2 = false;
            JdbcEngine $this$apply = jdbcEngine;
            boolean bl3 = false;
            $this$apply.setAskPassword(!this.silent);
            return jdbcEngine;
        }

        public NaturalKernel(@NotNull Project project, @NotNull String title, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, boolean silent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            this.dataSource = dataSource2;
            this.credentialsStore = credentialsStore;
            this.silent = silent;
            this.broker = SimpleRequestBroker.newInstance(project, title);
            this.isolation = this.dataSource.getTxIsolation();
            DataRequest.TxMarker txMarker = DataRequest.getInitialTxMarker(this.dataSource.isAutoCommit());
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"DataRequest.getInitialTx\u2026(dataSource.isAutoCommit)");
            this.txMarker = txMarker;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$MessageBusSessionChangeEvent;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "eventType", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;)V", "getSession", "getType", "intellij.database.impl"})
    private static final class MessageBusSessionChangeEvent
    implements DatabaseSessionStateListener.ChangeEvent {
        private final DatabaseSession session;
        private final DatabaseSessionStateListener.ChangeEvent.EventType eventType;

        @Override
        @NotNull
        public DatabaseSessionStateListener.ChangeEvent.EventType getType() {
            return this.eventType;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }

        public MessageBusSessionChangeEvent(@NotNull DatabaseSession session2, @NotNull DatabaseSessionStateListener.ChangeEvent.EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.session = session2;
            this.eventType = eventType;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Companion;", "", "()V", "DEFAULT_SESSION_NAME", "", "syncPublisher", "Lcom/intellij/database/console/session/DatabaseSessionStateListener;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
    public static final class Companion {
        private final DatabaseSessionStateListener syncPublisher() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            Object object = application.getMessageBus().syncPublisher(DatabaseSession.Companion.getTopic());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026er(DatabaseSession.topic)");
            return (DatabaseSessionStateListener)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

