/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManager$sam$com_intellij_openapi_util_Computable$0;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.GlobalSessionStateListener;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.actions.CloseSessionAction;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b3456789:;<=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007JH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J$\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010$\u001a\u0004\u0018\u00010#H\u0003J\"\u0010%\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010&\u001a\u00020#H\u0007J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J@\u0010'\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0003\u0010&\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010(\u001a\u00020)H\u0003J$\u0010'\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010&\u001a\u0004\u0018\u00010#H\u0007J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J!\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0002\u00a2\u0006\u0002\u00100J$\u00101\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010&\u001a\u0004\u0018\u00010#H\u0007J\u0010\u00102\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006>"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager;", "", "()V", "projectSessions", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/console/session/DatabaseSessionManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTopic$annotations", "getTopic", "()Lcom/intellij/util/messages/Topic;", "facade", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "project", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "path", "Lcom/intellij/database/util/SearchPath;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "silent", "", "findSession", "Lcom/intellij/database/console/session/DatabaseSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateNameForSession", "", "prefix", "getExactSession", "title", "getSession", "type", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "getSessions", "", "onEdt", "T", "computable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "openSession", "projectScopedSessions", "ConnectionWithClient", "Facade", "Factories", "Factory", "Indexer", "MultiConnection", "ProjectSessions", "SessionType", "SingleConnection", "TemporaryAuditor", "TemporaryClient", "intellij.database.impl"})
public final class DatabaseSessionManager {
    @NotNull
    private static final Topic<DatabaseSessionManagerListener> topic;
    private static final ConcurrentMap<Project, ProjectSessions> projectSessions;
    public static final DatabaseSessionManager INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getTopic$annotations() {
    }

    @NotNull
    public static final Topic<DatabaseSessionManagerListener> getTopic() {
        return topic;
    }

    @Nls
    private final String generateNameForSession(Project project, LocalDataSource dataSource2) {
        return this.generateNameForSession(project, dataSource2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String generateNameForSession(Project project, LocalDataSource dataSource2, @Nls String prefix) {
        Object object;
        void $this$mapTo$iv$iv;
        DatabaseSession it2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project, dataSource2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!(prefix == null && StringUtil.isNotNegativeNumber((CharSequence)it2.getTitle()) || prefix != null && StringsKt.startsWith$default((String)it2.getTitle(), (String)prefix, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (DatabaseSession)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it2.getTitle();
            collection.add(string);
        }
        List sessions = (List)destination$iv$iv;
        Long idx = Indexer.INSTANCE.generateIndex(CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)sessions, (Object)"default")), prefix);
        if (prefix == null) {
            object = idx;
            if (object == null || (object = String.valueOf((Long)object)) == null) {
                object = "1";
            }
        } else {
            object = idx == null ? prefix : prefix + ' ' + idx;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final DatabaseSession findSession(@NotNull AnActionEvent e) {
        DataGridSessionClient hookUp;
        DatabaseSession session2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return null");
        Project project2 = project;
        Object object = e.getData(Session.SESSION_KEY);
        if (!(object instanceof DatabaseSession)) {
            object = null;
        }
        if ((session2 = (DatabaseSession)object) != null) {
            return session2;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console != null) {
            return console.getSession();
        }
        DataGridSessionClient dataGridSessionClient = hookUp = (DataGridSessionClient)GridDataHookUpManager.getInstance(project2).getClient(e);
        return dataGridSessionClient != null ? dataGridSessionClient.getSession() : null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = INSTANCE.projectScopedSessions(project).getSessions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it2 = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isInternal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b2) {
                boolean bl = false;
                DatabaseSession it2 = (DatabaseSession)a;
                boolean bl2 = false;
                int n = it2.isService() ? 0 : 1;
                it2 = (DatabaseSession)b2;
                Comparable comparable = Integer.valueOf(n);
                bl2 = false;
                Integer n2 = it2.isService() ? 0 : 1;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it2 = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getTarget(), (Object)dataSource2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        return DatabaseSessionManager.getSession$default(project, dataSource2, null, false, null, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nls @Nullable String title) {
        DatabaseSession databaseSession;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Iterable iterable = DatabaseSessionManager.getSessions(project, dataSource2);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DatabaseSession it2 = (DatabaseSession)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it2.getTitle(), (Object)title)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((databaseSession = (DatabaseSession)v0) == null) {
            databaseSession = DatabaseSessionManager.getSession$default(project, dataSource2, null, false, title, null, 32, null);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getExactSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nls @NotNull String title) {
        DatabaseSession databaseSession;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Iterable iterable = DatabaseSessionManager.getSessions(project, dataSource2);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DatabaseSession it2 = (DatabaseSession)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it2.getTitle(), (Object)title)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((databaseSession = (DatabaseSession)v0) == null) {
            databaseSession = DatabaseSessionManager.getSession(project, dataSource2, null, false, title, SessionType.NEW);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession openSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nls @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        return DatabaseSessionManager.getSession(project, dataSource2, null, false, INSTANCE.generateNameForSession(project, dataSource2, title), SessionType.NEW);
    }

    @JvmStatic
    @NotNull
    public static final Facade facade(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return DatabaseSessionManager.facade(project, dataSource2, credentialsStore, path, false, handler, department);
    }

    public static /* synthetic */ Facade facade$default(Project project, LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, SearchPath searchPath, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 8) != 0) {
            searchPath = null;
        }
        if ((n & 0x10) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.facade(project, localDataSource, databaseCredentials, searchPath, errorHandler, databaseDepartment);
    }

    @JvmStatic
    @NotNull
    public static final Facade facade(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return new Facade(dataSource2, credentialsStore, project, path, silent, handler, department);
    }

    public static /* synthetic */ Facade facade$default(Project project, LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 0x20) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.facade(project, localDataSource, databaseCredentials, searchPath, bl, errorHandler, databaseDepartment);
    }

    @JvmStatic
    private static final DatabaseSession getSession(Project project, LocalDataSource dataSource2, DatabaseCredentials credentialsStore, boolean silent, @Nls String title, SessionType type) {
        String sessionTitle = Intrinsics.areEqual((Object)title, (Object)"default") ? INSTANCE.generateNameForSession(project, dataSource2, "default") : title;
        return INSTANCE.projectScopedSessions(project).getSession(project, dataSource2, credentialsStore, silent, sessionTitle, type);
    }

    static /* synthetic */ DatabaseSession getSession$default(Project project, LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            sessionType = SessionType.NOT_IMPORTANT;
        }
        return DatabaseSessionManager.getSession(project, localDataSource, databaseCredentials, bl, string, sessionType);
    }

    private final ProjectSessions projectScopedSessions(Project project) {
        ProjectSessions projectSessions;
        ProjectSessions sessions = new ProjectSessions(project);
        ProjectSessions result = DatabaseSessionManager.projectSessions.putIfAbsent(project, sessions);
        if (result == null) {
            Disposer.register((Disposable)((Disposable)project), (Disposable)new Disposable(project){
                final /* synthetic */ Project $project;

                public final void dispose() {
                    DatabaseSessionManager.access$getProjectSessions$p(DatabaseSessionManager.INSTANCE).remove(this.$project);
                }
                {
                    this.$project = project;
                }
            });
            sessions.init();
        }
        if ((projectSessions = result) == null) {
            projectSessions = sessions;
        }
        return projectSessions;
    }

    private final <T> T onEdt(Function0<? extends T> computable) {
        Object object = computable;
        if (object != null) {
            Function0<? extends T> function0 = object;
            object = new DatabaseSessionManager$sam$com_intellij_openapi_util_Computable$0(function0);
        }
        return (T)UIUtil.invokeAndWaitIfNeeded((Computable)((Computable)object));
    }

    private DatabaseSessionManager() {
    }

    static {
        DatabaseSessionManager databaseSessionManager;
        INSTANCE = databaseSessionManager = new DatabaseSessionManager();
        Topic topic = Topic.create((String)"database session manager topic", DatabaseSessionManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"Topic.create(\"database s\u2026agerListener::class.java)");
        DatabaseSessionManager.topic = topic;
        DatabaseServiceViewContributor.listenSessions();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(DatabaseSession.Companion.getTopic(), (Object)new GlobalSessionStateListener());
        projectSessions = new ConcurrentHashMap();
    }

    public static final /* synthetic */ ConcurrentMap access$getProjectSessions$p(DatabaseSessionManager $this) {
        DatabaseSessionManager databaseSessionManager = $this;
        return projectSessions;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J>\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u001f\u0010\u0019\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u000b2\u0006\u0010\u001b\u001a\u0002H\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "sessions", "", "Lcom/intellij/database/console/session/DatabaseSession;", "getSessions", "()Ljava/util/Set;", "getFactories", "dataSource", "getSession", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "index", "T", "session", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "init", "", "remember", "intellij.database.impl"})
    private static final class ProjectSessions {
        private final Map<LocalDataSource, Factories> map;
        @NotNull
        private final Set<DatabaseSession> sessions;
        private final Project project;

        @NotNull
        public final Set<DatabaseSession> getSessions() {
            return this.sessions;
        }

        @NotNull
        public final DatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return (DatabaseSession)INSTANCE.onEdt((Function0)new Function0<DatabaseSession>(this, dataSource2, sessionType, project, credentialsStore, silent, title){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ SessionType $sessionType;
                final /* synthetic */ Project $project;
                final /* synthetic */ DatabaseCredentials $credentialsStore;
                final /* synthetic */ boolean $silent;
                final /* synthetic */ String $title;

                @NotNull
                public final DatabaseSession invoke() {
                    return ProjectSessions.access$remember(this.this$0, ProjectSessions.access$index(this.this$0, ProjectSessions.access$getFactories(this.this$0, this.$dataSource).chooseOneFor(this.$dataSource, this.$sessionType).instance(this.$project, this.$dataSource, this.$credentialsStore, this.$silent, this.$title)));
                }
                {
                    this.this$0 = projectSessions;
                    this.$dataSource = localDataSource;
                    this.$sessionType = sessionType;
                    this.$project = project;
                    this.$credentialsStore = databaseCredentials;
                    this.$silent = bl;
                    this.$title = string;
                    super(0);
                }
            });
        }

        public static /* synthetic */ DatabaseSession getSession$default(ProjectSessions projectSessions, Project project, LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
            if ((n & 0x20) != 0) {
                sessionType = SessionType.NOT_IMPORTANT;
            }
            return projectSessions.getSession(project, localDataSource, databaseCredentials, bl, string, sessionType);
        }

        public final void init() {
            this.project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(this){
                final /* synthetic */ ProjectSessions this$0;

                public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                    Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                    DatabaseSessionManager.access$onEdt(DatabaseSessionManager.INSTANCE, (Function0)new Function0<Factories>(this, dataSource2){
                        final /* synthetic */ init.1 this$0;
                        final /* synthetic */ LocalDataSource $dataSource;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final Factories invoke() {
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv = this.this$0.this$0.getSessions();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                DatabaseSession it2 = (DatabaseSession)element$iv$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it2.getTarget(), (Object)this.$dataSource)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                DatabaseSession it3 = (DatabaseSession)element$iv;
                                boolean bl = false;
                                CloseSessionAction.close(it3);
                            }
                            return (Factories)ProjectSessions.access$getMap$p(this.this$0.this$0).remove(this.$dataSource);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dataSource = localDataSource;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = this$0;
                }
            });
        }

        private final DatabaseSession remember(DatabaseSession session2) {
            if (this.sessions.contains(session2)) {
                return session2;
            }
            Disposer.register((Disposable)session2, (Disposable)new Disposable(this, session2){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ DatabaseSession $session;

                public final void dispose() {
                    Collection collection = this.this$0.getSessions();
                    DatabaseSession databaseSession = this.$session;
                    boolean bl = false;
                    collection.remove(databaseSession);
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    ((DatabaseSessionManagerListener)application.getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionClosed(this.$session);
                }
                {
                    this.this$0 = projectSessions;
                    this.$session = databaseSession;
                }
            });
            Collection collection = this.sessions;
            boolean bl = false;
            collection.add(session2);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((DatabaseSessionManagerListener)application.getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionOpened(session2);
            return session2;
        }

        private final Factories getFactories(LocalDataSource dataSource2) {
            Factories factories;
            Map<LocalDataSource, Factories> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            Factories value$iv = $this$getOrPut$iv.get(dataSource2);
            if (value$iv == null) {
                boolean bl = false;
                Factories answer$iv = new Factories();
                $this$getOrPut$iv.put(dataSource2, answer$iv);
                factories = answer$iv;
            } else {
                factories = value$iv;
            }
            return factories;
        }

        private final <T extends DatabaseSession> T index(T session2) {
            if (this.sessions.contains(session2)) {
                return session2;
            }
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)session2);
            return session2;
        }

        public ProjectSessions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.map = new HashMap();
            Set set = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
            this.sessions = set;
        }

        public static final /* synthetic */ DatabaseSession access$remember(ProjectSessions $this, DatabaseSession session2) {
            return $this.remember(session2);
        }

        public static final /* synthetic */ DatabaseSession access$index(ProjectSessions $this, DatabaseSession session2) {
            return $this.index(session2);
        }

        public static final /* synthetic */ Factories access$getFactories(ProjectSessions $this, LocalDataSource dataSource2) {
            return $this.getFactories(dataSource2);
        }

        public static final /* synthetic */ Map access$getMap$p(ProjectSessions $this) {
            return $this.map;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "", "()V", "singleConnection", "Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "chooseOneFor", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "intellij.database.impl"})
    private static final class Factories {
        private final SingleConnection singleConnection = new SingleConnection(MultiConnection.INSTANCE);

        @NotNull
        public final Factory chooseOneFor(@NotNull LocalDataSource dataSource2, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return sessionType == SessionType.SERVICE || dataSource2.isSingleConnection() && sessionType == SessionType.NOT_IMPORTANT ? (Factory)this.singleConnection : (Factory)MultiConnection.INSTANCE;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J6\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\rH&J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\rH&\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.impl"})
    public static interface Factory {
        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull LocalDataSource var2, @Nls @Nullable String var3);

        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull LocalDataSource var2, @Nullable DatabaseCredentials var3, boolean var4, @Nls @Nullable String var5);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, LocalDataSource localDataSource, String string, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
                }
                if ((n & 4) != 0) {
                    string = null;
                }
                return factory.instance(project, localDataSource, string);
            }

            public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, boolean bl, String string, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
                }
                if ((n & 0x10) != 0) {
                    string = null;
                }
                return factory.instance(project, localDataSource, databaseCredentials, bl, string);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$MultiConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "()V", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.impl"})
    private static final class MultiConnection
    implements Factory {
        public static final MultiConnection INSTANCE;

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, dataSource2);
            }
            String resultTitle = string;
            return new MessageBusSession(project, dataSource2, new MessageBusSession.NaturalKernel(project, resultTitle, dataSource2, null, false), resultTitle);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, dataSource2);
            }
            String resultTitle = string;
            return new MessageBusSession(project, dataSource2, new MessageBusSession.NaturalKernel(project, resultTitle, dataSource2, credentialsStore, silent), resultTitle);
        }

        private MultiConnection() {
        }

        static {
            MultiConnection multiConnection;
            INSTANCE = multiConnection = new MultiConnection();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "honestFactory", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;)V", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "instance", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.impl"})
    private static final class SingleConnection
    implements Factory {
        private DatabaseSession session;
        private final Factory honestFactory;

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            return this.session(project, dataSource2, null, false);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            return this.session(project, dataSource2, credentialsStore, silent);
        }

        private final DatabaseSession session(Project project, LocalDataSource dataSource2, DatabaseCredentials credentialsStore, boolean silent) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.session == null) {
                DatabaseSession databaseSession = this.session = this.honestFactory.instance(project, dataSource2, credentialsStore, silent, "");
                Intrinsics.checkNotNull((Object)databaseSession);
                Disposer.register((Disposable)databaseSession, (Disposable)new Disposable(this){
                    final /* synthetic */ SingleConnection this$0;

                    public final void dispose() {
                        DatabaseSessionManager.access$onEdt(DatabaseSessionManager.INSTANCE, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ session.1 this$0;

                            public final void invoke() {
                                SingleConnection.access$setSession$p(this.this$0.this$0, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = singleConnection;
                    }
                });
            }
            DatabaseSession databaseSession = this.session;
            Intrinsics.checkNotNull((Object)databaseSession);
            return databaseSession;
        }

        public SingleConnection(@NotNull Factory honestFactory) {
            Intrinsics.checkNotNullParameter((Object)honestFactory, (String)"honestFactory");
            this.honestFactory = honestFactory;
        }

        public static final /* synthetic */ DatabaseSession access$getSession$p(SingleConnection $this) {
            return $this.session;
        }

        public static final /* synthetic */ void access$setSession$p(SingleConnection $this, DatabaseSession databaseSession) {
            $this.session = databaseSession;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\b01234567BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJA\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d\"\b\b\u0001\u0010\u001e*\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\u001d0!2\u0006\u0010\"\u001a\u0002H\u001e2\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160'H\u0002J6\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0)\"\u0004\b\u0000\u0010\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001d0)2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u001d0!H\u0002J&\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001d0,\"\u0004\b\u0000\u0010\u001d2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u001d0!J%\u0010-\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H\u001d0!\u00a2\u0006\u0002\u0010/R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/database/util/SearchPath;", "silent", "", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "(Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/util/SearchPath;ZLcom/intellij/database/util/ErrorHandler;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "checkBounds", "", "info", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "compute", "T", "C", "Lcom/intellij/database/dataSource/DatabaseConnection;", "work", "Lkotlin/Function1;", "connection", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)Ljava/lang/Object;", "connect", "Lcom/intellij/database/util/GuardedRef;", "perform", "Ljava/util/concurrent/CompletableFuture;", "future", "runAsync", "Ljava/util/concurrent/CompletionStage;", "runSync", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ConnectionInfo", "ConnectionReference", "ConnectionsRouter", "Lockpick", "MultipleSessionsRouter", "Routers", "SingleSessionRouter", "intellij.database.impl"})
    public static final class Facade {
        @NotNull
        private final LocalDataSource dataSource;
        private final DatabaseCredentials credentialsStore;
        private final Project project;
        private final SearchPath path;
        private final boolean silent;
        private final ErrorHandler handler;
        private final DatabaseDepartment department;
        @NotNull
        private static final Routers routers;
        private static final Companion Companion;

        @NotNull
        public final <T> CompletionStage<T> runAsync(@NotNull Function1<? super DatabaseConnection, ? extends T> work) {
            Intrinsics.checkNotNullParameter(work, (String)"work");
            CompletableFuture future = new CompletableFuture();
            return this.perform(future, (Function1)new Function1<ConnectionInfo, T>(this, work){
                final /* synthetic */ Facade this$0;
                final /* synthetic */ Function1 $work;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T invoke(@NotNull ConnectionInfo info) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    ConnectionReference reference = new ConnectionReference(info, null, 2, null);
                    ConnectionsRouter router = Facade.access$Companion().getRouters().choose(this.this$0.getDataSource());
                    router.save(reference);
                    try {
                        object = Facade.access$compute(this.this$0, this.$work, info.getConnection(), info.getContext());
                    }
                    finally {
                        router.remove();
                    }
                    return (T)object;
                }
                {
                    this.this$0 = facade;
                    this.$work = function1;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runSync(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            T t;
            Intrinsics.checkNotNullParameter(work, (String)"work");
            AutoCloseable autoCloseable = this.connection();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                GuardedRef it2 = (GuardedRef)autoCloseable;
                boolean bl3 = false;
                Object t2 = it2.get();
                Intrinsics.checkNotNullExpressionValue(t2, (String)"it.get()");
                ConnectionInfo info = (ConnectionInfo)t2;
                t = this.compute(work, (DatabaseConnection)info.getConnection(), info.getContext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return t;
        }

        @NotNull
        public final GuardedRef<DatabaseConnection> connect() throws Exception {
            GuardedRef<ConnectionInfo> infoRef = this.connection();
            return new GuardedRef<DatabaseConnection>(infoRef, (Object)infoRef.get().getConnection()){
                final /* synthetic */ GuardedRef $infoRef;

                protected void close(@NotNull DatabaseConnection ref) {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    this.$infoRef.close();
                }
                {
                    this.$infoRef = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }

        private final GuardedRef<ConnectionInfo> connection() {
            ConnectionsRouter router = routers.choose(this.dataSource);
            ConnectionReference current = router.getCurrent();
            if (current != null) {
                this.checkBounds(current.getResource());
                return new Lockpick(current, router);
            }
            CountDownLatch latch = new CountDownLatch(1);
            CompletableFuture emptyFuture = new CompletableFuture();
            CompletableFuture resultFuture = new CompletableFuture();
            emptyFuture.exceptionally(new Function<Throwable, Unit>(resultFuture){
                final /* synthetic */ CompletableFuture $resultFuture;

                public final void apply(Throwable it2) {
                    this.$resultFuture.completeExceptionally(it2);
                }
                {
                    this.$resultFuture = completableFuture;
                }
            });
            this.perform(emptyFuture, (Function1)new Function1<ConnectionInfo, Unit>(resultFuture, latch){
                final /* synthetic */ CompletableFuture $resultFuture;
                final /* synthetic */ CountDownLatch $latch;

                public final void invoke(@NotNull ConnectionInfo it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    this.$resultFuture.complete(it2);
                    this.$latch.await();
                }
                {
                    this.$resultFuture = completableFuture;
                    this.$latch = countDownLatch;
                    super(1);
                }
            });
            try {
                ConnectionInfo result;
                ConnectionInfo connectionInfo = result = (ConnectionInfo)resultFuture.get();
                Intrinsics.checkNotNullExpressionValue((Object)connectionInfo, (String)"result");
                ConnectionReference reference = new ConnectionReference(connectionInfo, latch);
                router.save(reference);
                return new Lockpick(reference, router);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
                throw throwable;
            }
        }

        private final void checkBounds(ConnectionInfo info) {
            if (this.path == null) {
                return;
            }
            SearchPath searchPath = info.getContext().getSearchPath();
            if (!JdbcUrlParserUtil.outOfBounds(info.getConnection().getConnectionPoint(), (ObjectPath)(searchPath != null ? searchPath.getCurrent() : null), this.path.getCurrent())) {
                return;
            }
            throw (Throwable)new IllegalStateException("Cannot switch a database. The connection is used by another client. Disable the single connection mode and try again");
        }

        @NotNull
        public final DatabaseSessionClient client() {
            SessionType sessionType = this.department.isService() ? SessionType.SERVICE : SessionType.NOT_IMPORTANT;
            DatabaseSession session2 = DatabaseSessionManager.getSession(this.project, this.dataSource, this.credentialsStore, this.silent, null, sessionType);
            return this.client(session2);
        }

        @NotNull
        public final VisibleDatabaseSessionClient client(@NotNull DatabaseSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            TemporaryClient client = new TemporaryClient(session2, this.department, this.path);
            session2.attach(client);
            return client;
        }

        private final <T, C extends DatabaseConnection> T compute(Function1<? super C, ? extends T> work, C connection2, DataRequest.Context context) {
            Object object;
            try {
                object = work.invoke(connection2);
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation(e)) {
                    context.reportException(e, null);
                }
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final <T> CompletableFuture<T> perform(CompletableFuture<T> future, Function1<? super ConnectionInfo, ? extends T> work) {
            void client;
            boolean submitted = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            try {
                client.element = this.client();
                TemporaryAuditor<T> auditor = new TemporaryAuditor<T>(future, (DatabaseSessionClient)client.element, this.handler);
                ((DatabaseSessionClient)client.element).getMessageBus().addAuditor(auditor);
                ((DatabaseSessionClient)client.element).getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(auditor, future, work, (Ref.ObjectRef)client, (DatabaseSessionClient)client.element){
                    final /* synthetic */ TemporaryAuditor $auditor;
                    final /* synthetic */ CompletableFuture $future;
                    final /* synthetic */ Function1 $work;
                    final /* synthetic */ Ref.ObjectRef $client;

                    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
                        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                        if (this.$auditor.hasErrors()) {
                            return;
                        }
                        try {
                            this.$future.complete(this.$work.invoke((Object)new ConnectionInfo(new ConnectionWithClient(connection2, (DatabaseSessionClient)this.$client.element), context)));
                        }
                        catch (InterruptedException e) {
                            ProcessCanceledException ex = new ProcessCanceledException((Throwable)e);
                            this.$future.completeExceptionally(ex);
                            throw (Throwable)ex;
                        }
                        catch (ProcessCanceledException e) {
                            this.$future.completeExceptionally(e);
                            throw (Throwable)e;
                        }
                        catch (Throwable t) {
                            this.$future.completeExceptionally(t);
                            throw (Throwable)new ProcessCanceledException(t);
                        }
                    }
                    {
                        this.$auditor = $captured_local_variable$0;
                        this.$future = $captured_local_variable$1;
                        this.$work = $captured_local_variable$2;
                        this.$client = $captured_local_variable$3;
                        super($super_call_param$4);
                    }
                });
                submitted = auditor.getSubmitted();
                if (submitted) return future;
            }
            catch (Throwable throwable) {
                if ((DatabaseSessionClient)client.element != null) {
                    Disposer.dispose((Disposable)((DatabaseSessionClient)client.element));
                }
                future.completeExceptionally(new ProcessCanceledException());
                throw throwable;
            }
            if ((DatabaseSessionClient)client.element != null) {
                Disposer.dispose((Disposable)((DatabaseSessionClient)client.element));
            }
            future.completeExceptionally(new ProcessCanceledException());
            return future;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        public Facade(@NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialsStore, @NotNull Project project, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.dataSource = dataSource2;
            this.credentialsStore = credentialsStore;
            this.project = project;
            this.path = path;
            this.silent = silent;
            this.handler = handler;
            this.department = department;
        }

        public /* synthetic */ Facade(LocalDataSource localDataSource, DatabaseCredentials databaseCredentials, Project project, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                searchPath = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                errorHandler = null;
            }
            this(localDataSource, databaseCredentials, project, searchPath, bl, errorHandler, databaseDepartment);
        }

        static {
            Companion = new Companion(null);
            routers = new Routers(MultipleSessionsRouter.INSTANCE, new SingleSessionRouter());
        }

        public static final /* synthetic */ Object access$compute(Facade $this, Function1 work, DatabaseConnection connection2, DataRequest.Context context) {
            return $this.compute(work, connection2, context);
        }

        public static final /* synthetic */ Companion access$Companion() {
            return Companion;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "", "connection", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)V", "getConnection", "()Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "getContext", "()Lcom/intellij/database/datagrid/DataRequest$Context;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
        private static final class ConnectionInfo {
            @NotNull
            private final InterruptibleDatabaseConnection connection;
            @NotNull
            private final DataRequest.Context context;

            @NotNull
            public final InterruptibleDatabaseConnection getConnection() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context getContext() {
                return this.context;
            }

            public ConnectionInfo(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                this.connection = connection2;
                this.context = context;
            }

            @NotNull
            public final InterruptibleDatabaseConnection component1() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context component2() {
                return this.context;
            }

            @NotNull
            public final ConnectionInfo copy(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                return new ConnectionInfo(connection2, context);
            }

            public static /* synthetic */ ConnectionInfo copy$default(ConnectionInfo connectionInfo, InterruptibleDatabaseConnection interruptibleDatabaseConnection, DataRequest.Context context, int n, Object object) {
                if ((n & 1) != 0) {
                    interruptibleDatabaseConnection = connectionInfo.connection;
                }
                if ((n & 2) != 0) {
                    context = connectionInfo.context;
                }
                return connectionInfo.copy(interruptibleDatabaseConnection, context);
            }

            @NotNull
            public String toString() {
                return "ConnectionInfo(connection=" + this.connection + ", context=" + (Object)((Object)this.context) + ")";
            }

            public int hashCode() {
                InterruptibleDatabaseConnection interruptibleDatabaseConnection = this.connection;
                DataRequest.Context context = this.context;
                return (interruptibleDatabaseConnection != null ? interruptibleDatabaseConnection.hashCode() : 0) * 31 + (context != null ? ((Object)((Object)context)).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ConnectionInfo)) break block3;
                        ConnectionInfo connectionInfo = (ConnectionInfo)object;
                        if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionInfo.connection) || !Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)connectionInfo.context))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "", "resource", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "engineLatch", "Ljava/util/concurrent/CountDownLatch;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Ljava/util/concurrent/CountDownLatch;)V", "getEngineLatch", "()Ljava/util/concurrent/CountDownLatch;", "referenced", "", "getReferenced", "()I", "setReferenced", "(I)V", "getResource", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.database.impl"})
        private static final class ConnectionReference {
            private int referenced;
            @NotNull
            private final ConnectionInfo resource;
            @Nullable
            private final CountDownLatch engineLatch;

            public final int getReferenced() {
                return this.referenced;
            }

            public final void setReferenced(int n) {
                this.referenced = n;
            }

            @NotNull
            public final ConnectionInfo getResource() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch getEngineLatch() {
                return this.engineLatch;
            }

            public ConnectionReference(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.resource = resource;
                this.engineLatch = engineLatch;
            }

            public /* synthetic */ ConnectionReference(ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    countDownLatch = null;
                }
                this(connectionInfo, countDownLatch);
            }

            @NotNull
            public final ConnectionInfo component1() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch component2() {
                return this.engineLatch;
            }

            @NotNull
            public final ConnectionReference copy(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                return new ConnectionReference(resource, engineLatch);
            }

            public static /* synthetic */ ConnectionReference copy$default(ConnectionReference connectionReference, ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionInfo = connectionReference.resource;
                }
                if ((n & 2) != 0) {
                    countDownLatch = connectionReference.engineLatch;
                }
                return connectionReference.copy(connectionInfo, countDownLatch);
            }

            @NotNull
            public String toString() {
                return "ConnectionReference(resource=" + this.resource + ", engineLatch=" + this.engineLatch + ")";
            }

            public int hashCode() {
                ConnectionInfo connectionInfo = this.resource;
                CountDownLatch countDownLatch = this.engineLatch;
                return (connectionInfo != null ? ((Object)connectionInfo).hashCode() : 0) * 31 + (countDownLatch != null ? countDownLatch.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ConnectionReference)) break block3;
                        ConnectionReference connectionReference = (ConnectionReference)object;
                        if (!Intrinsics.areEqual((Object)this.resource, (Object)connectionReference.resource) || !Intrinsics.areEqual((Object)this.engineLatch, (Object)connectionReference.engineLatch)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Lockpick;", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "reference", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "router", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;)V", "getReference", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "close", "", "info", "intellij.database.impl"})
        private static final class Lockpick
        extends GuardedRef<ConnectionInfo> {
            @NotNull
            private final ConnectionReference reference;
            private final ConnectionsRouter router;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void close(@NotNull ConnectionInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + -1);
                if (this.reference.getReferenced() != 0) {
                    return;
                }
                try {
                    this.router.remove();
                }
                finally {
                    CountDownLatch countDownLatch = this.reference.getEngineLatch();
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            }

            @NotNull
            public final ConnectionReference getReference() {
                return this.reference;
            }

            public Lockpick(@NotNull ConnectionReference reference, @NotNull ConnectionsRouter router) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                super(reference.getResource());
                this.reference = reference;
                this.router = router;
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + 1);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static interface ConnectionsRouter {
            @Nullable
            public ConnectionReference getCurrent();

            public void save(@NotNull ConnectionReference var1);

            public void remove();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "localRefs", "Ljava/lang/ThreadLocal;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static final class SingleSessionRouter
        implements ConnectionsRouter {
            private final ThreadLocal<ConnectionReference> localRefs = new ThreadLocal();

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return this.localRefs.get();
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.localRefs.set(reference);
            }

            @Override
            public void remove() {
                this.localRefs.remove();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static final class MultipleSessionsRouter
        implements ConnectionsRouter {
            @Nullable
            private static final ConnectionReference current;
            public static final MultipleSessionsRouter INSTANCE;

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return current;
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            }

            @Override
            public void remove() {
            }

            private MultipleSessionsRouter() {
            }

            static {
                MultipleSessionsRouter multipleSessionsRouter;
                INSTANCE = multipleSessionsRouter = new MultipleSessionsRouter();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "", "multi", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "single", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;)V", "choose", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
        private static final class Routers {
            private final MultipleSessionsRouter multi;
            private final SingleSessionRouter single;

            @NotNull
            public final ConnectionsRouter choose(@NotNull LocalDataSource dataSource2) {
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                return dataSource2.isSingleConnection() ? (ConnectionsRouter)this.single : (ConnectionsRouter)this.multi;
            }

            public Routers(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                this.multi = multi;
                this.single = single;
            }

            private final MultipleSessionsRouter component1() {
                return this.multi;
            }

            private final SingleSessionRouter component2() {
                return this.single;
            }

            @NotNull
            public final Routers copy(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                return new Routers(multi, single);
            }

            public static /* synthetic */ Routers copy$default(Routers routers, MultipleSessionsRouter multipleSessionsRouter, SingleSessionRouter singleSessionRouter, int n, Object object) {
                if ((n & 1) != 0) {
                    multipleSessionsRouter = routers.multi;
                }
                if ((n & 2) != 0) {
                    singleSessionRouter = routers.single;
                }
                return routers.copy(multipleSessionsRouter, singleSessionRouter);
            }

            @NotNull
            public String toString() {
                return "Routers(multi=" + this.multi + ", single=" + this.single + ")";
            }

            public int hashCode() {
                MultipleSessionsRouter multipleSessionsRouter = this.multi;
                SingleSessionRouter singleSessionRouter = this.single;
                return (multipleSessionsRouter != null ? multipleSessionsRouter.hashCode() : 0) * 31 + (singleSessionRouter != null ? singleSessionRouter.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Routers)) break block3;
                        Routers routers = (Routers)object;
                        if (!Intrinsics.areEqual((Object)this.multi, (Object)routers.multi) || !Intrinsics.areEqual((Object)this.single, (Object)routers.single)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Companion;", "", "()V", "routers", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "getRouters", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "intellij.database.impl"})
        private static final class Companion {
            @NotNull
            public final Routers getRouters() {
                return routers;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryAuditor;", "T", "Lcom/intellij/database/datagrid/DataAuditor$Adapter;", "stage", "Ljava/util/concurrent/CompletableFuture;", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "(Ljava/util/concurrent/CompletableFuture;Lcom/intellij/database/console/client/DatabaseSessionClient;Lcom/intellij/database/util/ErrorHandler;)V", "connected", "", "submitted", "getSubmitted", "()Z", "setSubmitted", "(Z)V", "wasError", "error", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "message", "", "th", "", "hasErrors", "jobFinished", "request", "Lcom/intellij/database/datagrid/DataRequest;", "producer", "Lcom/intellij/database/datagrid/DataProducer;", "jobSubmitted", "intellij.database.impl"})
    private static final class TemporaryAuditor<T>
    extends DataAuditor.Adapter {
        private volatile boolean connected;
        private volatile boolean wasError;
        private boolean submitted;
        private final CompletableFuture<T> stage;
        private final DatabaseSessionClient client;
        private final ErrorHandler handler;

        public final boolean getSubmitted() {
            return this.submitted;
        }

        public final void setSubmitted(boolean bl) {
            this.submitted = bl;
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            ErrorHandler errorHandler = this.handler;
            if (errorHandler != null) {
                errorHandler.addError(message2, th);
            }
            this.wasError = true;
            if (this.connected) {
                return;
            }
            if (this.handler != null) {
                throwable = new ProcessCanceledException();
            } else if (message2 == null) {
                throwable = th;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
            } else {
                throwable = new RuntimeException(message2);
            }
            this.stage.completeExceptionally(throwable);
        }

        public final boolean hasErrors() {
            this.connected = true;
            return this.wasError;
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
            this.submitted = true;
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
            if (!this.stage.isDone()) {
                this.stage.completeExceptionally(new ProcessCanceledException());
            }
            Disposer.dispose((Disposable)this.client);
        }

        public TemporaryAuditor(@NotNull CompletableFuture<T> stage, @NotNull DatabaseSessionClient client, @Nullable ErrorHandler handler) {
            Intrinsics.checkNotNullParameter(stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.stage = stage;
            this.client = client;
            this.handler = handler;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J\b\u0010(\u001a\u00020\u0011H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u000bH\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020\u000bH\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020+H\u0016J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "Lcom/intellij/database/datagrid/DataRequest$CustomSearchPathOwner;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "path", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Lcom/intellij/database/util/SearchPath;)V", "disposed", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "kotlin.jvm.PlatformType", "getSession", "()Lcom/intellij/database/console/session/DatabaseSession;", "showOnActivity", "getShowOnActivity", "()Z", "title", "", "getTitle", "()Ljava/lang/String;", "detached", "", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "dispose", "focusOnError", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDepartment", "getDisplayName", "getMessageBus", "getSearchPath", "getTxIsolation", "", "isActive", "isEphemeral", "isValid", "setAutoCommit", "autoCommit", "setTxIsolation", "isolation", "showOnAttention", "intellij.database.impl"})
    private static final class TemporaryClient
    implements VisibleDatabaseSessionClient,
    DataRequest.CustomSearchPathOwner {
        @NotNull
        private final String title;
        private volatile boolean disposed;
        private final DataBus.Consuming messageBus;
        @NotNull
        private final DatabaseSession session;
        private final DatabaseDepartment department;
        private final SearchPath path;

        @Override
        @Nullable
        public Icon getIcon() {
            return this.department.getIcon();
        }

        @Override
        public boolean getShowOnActivity() {
            return false;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        public int getTxIsolation() {
            return this.getSession().getTxIsolation();
        }

        @Override
        public void setTxIsolation(int isolation) {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        public boolean showOnAttention(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            return false;
        }

        @Override
        public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
        }

        @Override
        public boolean focusOnError(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            return false;
        }

        @Override
        public boolean isActive() {
            return !this.disposed;
        }

        @Override
        public boolean isValid() {
            return !this.disposed;
        }

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            return this.department;
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.path;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getCurrentTx() {
            DataRequest.TxMarker txMarker = this.getSession().getCurrentTx();
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"session.currentTx");
            return txMarker;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.getTitle();
        }

        @Override
        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = this.messageBus;
            Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"messageBus");
            return consuming;
        }

        @Override
        public boolean isEphemeral() {
            return true;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            this.getSession().setAutoCommit(autoCommit);
        }

        public void dispose() {
            this.disposed = true;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }

        public TemporaryClient(@NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @Nullable SearchPath path) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.session = session2;
            this.department = department;
            this.path = path;
            this.title = this.department.getDepartmentName();
            this.messageBus = this.getSession().getMessageBus().filterFor(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Indexer;", "", "()V", "generateIndex", "", "sessions", "", "", "prefix", "(Ljava/util/List;Ljava/lang/String;)Ljava/lang/Long;", "retrieveIndex", "session", "intellij.database.impl"})
    private static final class Indexer {
        public static final Indexer INSTANCE;

        @Nullable
        public final Long generateIndex(@NotNull List<String> sessions, @Nullable String prefix) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
                        if (sessions.isEmpty()) break block10;
                        if (prefix == null) break block11;
                        Iterable $this$none$iv = sessions;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String it2 = (String)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it2, (Object)prefix)) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block11;
                }
                return null;
            }
            List sortedSessions2 = CollectionsKt.sortedWith((Iterable)sessions, (Comparator)generateIndex.sortedSessions.1.INSTANCE);
            long index2 = 1L;
            for (String session2 : sortedSessions2) {
                long idxOfSession = this.retrieveIndex(session2, prefix);
                if (idxOfSession == -1L) continue;
                if (idxOfSession == index2) {
                    long l = index2;
                    index2 = l + 1L;
                }
                if (idxOfSession <= index2) continue;
                return index2;
            }
            return index2;
        }

        public static /* synthetic */ Long generateIndex$default(Indexer indexer, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return indexer.generateIndex(list, string);
        }

        private final long retrieveIndex(String session2, String prefix) {
            int idx;
            String string = session2;
            char c2 = '\u0000';
            boolean bl = false;
            String it2 = string;
            boolean bl2 = false;
            string = prefix != null ? StringsKt.substringAfter$default((String)it2, (String)prefix, null, (int)2, null) : it2;
            c2 = '\u0000';
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] title = cArray;
            for (idx = title.length - 1; idx > -1 && idx < title.length; --idx) {
                c2 = title[idx];
                bl = false;
                if (!Character.isDigit(c2)) break;
            }
            int shift = prefix != null && StringsKt.startsWith$default((String)session2, (String)prefix, (boolean)false, (int)2, null) ? prefix.length() : 0;
            String string3 = session2;
            int n = shift + idx + 1;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String numericSuffix = string5;
            Long l = StringsKt.toLongOrNull((String)numericSuffix);
            return l != null ? l : -1L;
        }

        private Indexer() {
        }

        static {
            Indexer indexer;
            INSTANCE = indexer = new Indexer();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "", "(Ljava/lang/String;I)V", "SERVICE", "NOT_IMPORTANT", "NEW", "intellij.database.impl"})
    public static final class SessionType
    extends Enum<SessionType> {
        public static final /* enum */ SessionType SERVICE;
        public static final /* enum */ SessionType NOT_IMPORTANT;
        public static final /* enum */ SessionType NEW;
        private static final /* synthetic */ SessionType[] $VALUES;

        static {
            SessionType[] sessionTypeArray = new SessionType[3];
            SessionType[] sessionTypeArray2 = sessionTypeArray;
            sessionTypeArray[0] = SERVICE = new SessionType();
            sessionTypeArray[1] = NOT_IMPORTANT = new SessionType();
            sessionTypeArray[2] = NEW = new SessionType();
            $VALUES = sessionTypeArray;
        }

        public static SessionType[] values() {
            return (SessionType[])$VALUES.clone();
        }

        public static SessionType valueOf(String string) {
            return Enum.valueOf(SessionType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\rH\u0096\u0001J\t\u0010\u000e\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u000e\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\t\u0010\u0018\u001a\u00020\u0012H\u0096\u0001J\u000e\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u0010\u0010#\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b%H\u0097\u0001J\u000e\u0010&\u001a\u00070'\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010(\u001a\u00070 \u00a2\u0006\u0002\b\u0017H\u0097\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\rH\u0016J\t\u0010,\u001a\u00020\u0012H\u0096\u0001J\u0018\u0010-\u001a\u00020\r2\r\b\u0001\u0010.\u001a\u00070/\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\t\u00100\u001a\u00020\rH\u0096\u0001J\u0018\u00100\u001a\u00020\r2\r\b\u0001\u0010.\u001a\u00070/\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\u0011\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u0012H\u0096\u0001J\u0011\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\u0012H\u0096\u0001J\u0011\u00105\u001a\n 6*\u0004\u0018\u00010/0/H\u0096\u0001J\t\u00107\u001a\u000208H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00069"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ConnectionWithClient;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatements$PurposedConnection;", "connection", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/console/client/DatabaseSessionClient;)V", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "commit", "", "component1", "component2", "copy", "equals", "", "other", "", "getAuditService", "Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "Lorg/jetbrains/annotations/NotNull;", "getAutoCommit", "getConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConnectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getDbms", "Lcom/intellij/database/Dbms;", "getDriverVersion", "Lcom/intellij/database/util/Version;", "getRemoteConnection", "Lcom/intellij/database/remote/jdbc/RemoteConnection;", "getRemoteMetaData", "Lcom/intellij/database/remote/jdbc/RemoteDatabaseMetaData;", "Lorg/jetbrains/annotations/Nullable;", "getRequestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "getVersion", "hashCode", "", "interrupt", "isReadOnly", "releaseSavepoint", "savepoint", "Lcom/intellij/database/remote/jdbc/RemoteSavepoint;", "rollback", "setAutoCommit", "autoCommit", "setReadOnly", "only", "setSavepoint", "kotlin.jvm.PlatformType", "toString", "", "intellij.database.impl"})
    private static final class ConnectionWithClient
    implements DatabaseConnection,
    InterruptibleDatabaseConnection,
    SmartStatements.PurposedConnection {
        private final DatabaseConnection connection;
        private final DatabaseSessionClient client;

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            DatabaseDepartment databaseDepartment = this.client.getDepartment();
            Intrinsics.checkNotNullExpressionValue((Object)databaseDepartment, (String)"client.department");
            return databaseDepartment;
        }

        @Override
        public void interrupt() {
            this.client.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(this.client));
        }

        public ConnectionWithClient(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.connection = connection2;
            this.client = client;
        }

        @Override
        public void commit() {
            this.connection.commit();
        }

        @Override
        @NotNull
        public AdvancedAuditService getAuditService() {
            return this.connection.getAuditService();
        }

        @Override
        public boolean getAutoCommit() {
            return this.connection.getAutoCommit();
        }

        @Override
        @NotNull
        public ConsoleRunConfiguration getConfiguration() {
            return this.connection.getConfiguration();
        }

        @Override
        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            return this.connection.getConnectionPoint();
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            return this.connection.getDbms();
        }

        @Override
        @NotNull
        public Version getDriverVersion() {
            return this.connection.getDriverVersion();
        }

        @Override
        @NotNull
        public RemoteConnection getRemoteConnection() {
            return this.connection.getRemoteConnection();
        }

        @Override
        @Nullable
        public RemoteDatabaseMetaData getRemoteMetaData() {
            return this.connection.getRemoteMetaData();
        }

        @Override
        @NotNull
        public ConnectionRequestor getRequestor() {
            return this.connection.getRequestor();
        }

        @Override
        @NotNull
        public Version getVersion() {
            return this.connection.getVersion();
        }

        @Override
        public boolean isReadOnly() {
            return this.connection.isReadOnly();
        }

        @Override
        public void releaseSavepoint(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() {
            this.connection.rollback();
        }

        @Override
        public void rollback(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            this.connection.setAutoCommit(autoCommit);
        }

        @Override
        public void setReadOnly(boolean only) {
            this.connection.setReadOnly(only);
        }

        @Override
        public RemoteSavepoint setSavepoint() {
            return this.connection.setSavepoint();
        }

        private final DatabaseConnection component1() {
            return this.connection;
        }

        private final DatabaseSessionClient component2() {
            return this.client;
        }

        @NotNull
        public final ConnectionWithClient copy(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return new ConnectionWithClient(connection2, client);
        }

        public static /* synthetic */ ConnectionWithClient copy$default(ConnectionWithClient connectionWithClient, DatabaseConnection databaseConnection, DatabaseSessionClient databaseSessionClient, int n, Object object) {
            if ((n & 1) != 0) {
                databaseConnection = connectionWithClient.connection;
            }
            if ((n & 2) != 0) {
                databaseSessionClient = connectionWithClient.client;
            }
            return connectionWithClient.copy(databaseConnection, databaseSessionClient);
        }

        @NotNull
        public String toString() {
            return "ConnectionWithClient(connection=" + this.connection + ", client=" + this.client + ")";
        }

        public int hashCode() {
            DatabaseConnection databaseConnection = this.connection;
            DatabaseSessionClient databaseSessionClient = this.client;
            return (databaseConnection != null ? databaseConnection.hashCode() : 0) * 31 + (databaseSessionClient != null ? databaseSessionClient.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConnectionWithClient)) break block3;
                    ConnectionWithClient connectionWithClient = (ConnectionWithClient)object;
                    if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionWithClient.connection) || !Intrinsics.areEqual((Object)this.client, (Object)connectionWithClient.client)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

