/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.SqlNotebookModel;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlNotebookManager;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseInEditorResults {
    private static final int MAX_ROWS = 7;
    private final MultiMap<Editor, ContainerWeakRef> myContainers = new MultiMap();

    @Nullable
    public ResultConstructor getOrCreateResult(@NotNull Arguments args) {
        ScriptModel<PsiElement> sm;
        if (args == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(0);
        }
        if (args.editor.isDisposed() || !EditorUtil.isRealFileEditor((Editor)args.editor)) {
            return null;
        }
        PsiFile file = args.console.getFile();
        SqlNotebookModel.CellsAccessor accessor = (SqlNotebookModel.CellsAccessor)ReadAction.compute(() -> DatabaseInEditorResults.lambda$getOrCreateResult$0(file, sm = args.console.getScriptModel()));
        SqlNotebookManager.Cell cell = this.getCell(accessor, args);
        return cell == null ? null : this.getContainer(args, cell);
    }

    public void scrollTo(@NotNull Result result, @NotNull Editor editor) {
        if (result == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(2);
        }
        Document document = editor.getDocument();
        int line = document.getLineNumber(result.getOffset());
        int lStart = document.getLineStartOffset(line);
        editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(lStart), ScrollType.MAKE_VISIBLE);
    }

    @NotNull
    public Collection<? extends RunnerLayoutUi> getUis() {
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(this.getUncollectedResults(), Result::isShown), Result::getUi);
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void show(@NotNull Result result, @NotNull Content content, @NotNull Editor editor) {
        if (result == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(4);
        }
        if (content == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(6);
        }
        result.show();
        UIUtil.uiTraverser((Component)content.getComponent()).filter(EditorHeaderComponent.class).forEach(t -> t.addMouseWheelListener(event -> MouseEventAdapter.redispatch((MouseEvent)event, (Component)editor.getContentComponent())));
    }

    @Nullable
    private SqlNotebookManager.Cell getCell(@NotNull SqlNotebookModel.CellsAccessor accessor, @NotNull Arguments arguments) {
        if (accessor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(8);
        }
        if (arguments.editor.isDisposed() || !EditorUtil.isRealFileEditor((Editor)arguments.editor)) {
            return null;
        }
        TextRange range = arguments.request.getRange();
        if (range == null) {
            return null;
        }
        int offset = Math.max(range.getStartOffset(), range.getEndOffset() - 1);
        SqlNotebookManager.Cell cell = accessor.getCell(new LayoutProvider((Editor)arguments.editor), offset);
        if (cell == null) {
            return null;
        }
        DocumentEx document = arguments.editor.getDocument();
        int lsOffset = document.getLineStartOffset(document.getLineNumber(cell.lastStatementEnd));
        return DatabaseInEditorResults.isVisibleVertically(arguments.editor, arguments.editor.offsetToXY(lsOffset)) ? cell : DatabaseInEditorResults.argsToCell(arguments, range);
    }

    private static boolean isVisibleVertically(@NotNull EditorEx editor, @NotNull Point point) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(9);
        }
        if (point == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(10);
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point areaXInlayY = new Point(visibleArea.x, point.y);
        return visibleArea.contains(areaXInlayY);
    }

    @NotNull
    private static SqlNotebookManager.Cell argsToCell(@NotNull Arguments arguments, @NotNull TextRange range) {
        if (arguments == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(11);
        }
        if (range == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(12);
        }
        int lineEnd = DatabaseInEditorResults.getLineEnd((Editor)arguments.editor, range.getEndOffset());
        TextRange finalRange = TextRange.create((int)range.getStartOffset(), (int)lineEnd);
        return new SqlNotebookManager.Cell(finalRange, Collections.singletonList(finalRange), lineEnd);
    }

    @NotNull
    private ResultConstructor getContainer(@NotNull Arguments args, @NotNull SqlNotebookManager.Cell cell) {
        EditorEx editor;
        ResultConstructor found;
        if (args == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(13);
        }
        if (cell == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(14);
        }
        if ((found = this.findContainer((Editor)(editor = args.editor), cell)) != null) {
            ResultConstructor resultConstructor = found;
            if (resultConstructor == null) {
                DatabaseInEditorResults.$$$reportNull$$$0(15);
            }
            return resultConstructor;
        }
        final Disposable parent2 = Disposer.newDisposable();
        Project project = args.console.getProject();
        BooleanFunction aliveChecker = c2 -> this.getUncollectedResults().contains(c2);
        int lse = cell.lastStatementEnd;
        EditorResultsContainer container = new EditorResultsContainer(parent2, project, args.editor, args.console, (BooleanFunction<EditorResultsContainer>)aliveChecker, lse);
        final RunnerLayoutUi ui = container.getUi();
        ui.addListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ui.getContents().length == 0) {
                    Disposer.dispose((Disposable)parent2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/session/DatabaseInEditorResults$1", "contentRemoved"));
            }
        }, parent2);
        ContainerWeakRef reference = container.getWeakRef();
        this.myContainers.putValue((Object)editor, (Object)reference);
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)parent2);
        Disposer.register((Disposable)parent2, () -> {
            this.myContainers.remove((Object)args.editor, (Object)reference);
            EditorResultsContainer c2 = (EditorResultsContainer)reference.get();
            if (c2 != null) {
                c2.clearStrongReferences();
            }
        });
        EditorResultsContainer editorResultsContainer = container;
        if (editorResultsContainer == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(16);
        }
        return editorResultsContainer;
    }

    @NotNull
    public Collection<? extends Result> getResults(@NotNull Editor editor) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(17);
        }
        return this.getUncollectedResults(editor);
    }

    @Nullable
    private ResultConstructor findContainer(@NotNull Editor editor, @NotNull SqlNotebookManager.Cell cell) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(18);
        }
        if (cell == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(19);
        }
        Collection<ResultConstructor> containers = this.getUncollectedResults(editor);
        for (ResultConstructor container : containers) {
            if (!container.isShown() || !cell.range.containsOffset(container.getOffset())) continue;
            return container;
        }
        return null;
    }

    @NotNull
    private Collection<ResultConstructor> getUncollectedResults(@NotNull Editor editor) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(20);
        }
        ArrayList refs = new ArrayList(this.myContainers.get((Object)editor));
        List list = ContainerUtil.filter((Collection)ContainerUtil.mapNotNull(refs, r -> DatabaseInEditorResults.asResult(r)), Result::isShown);
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private Collection<ResultConstructor> getUncollectedResults() {
        List list = ContainerUtil.mapNotNull(new ArrayList(this.myContainers.values()), r -> DatabaseInEditorResults.asResult(r));
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    private static ResultConstructor asResult(@NotNull ContainerWeakRef ref) {
        EditorResultsContainer container;
        if (ref == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(23);
        }
        if ((container = (EditorResultsContainer)ref.get()) == null || ref.isOutdated() && !container.isShown()) {
            ref.dispose();
            return null;
        }
        return container;
    }

    private static int getEditorTextWidth(@NotNull EditorImpl editor) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(24);
        }
        FontMetrics metrics = editor.getFontMetrics(0);
        float spaceWidth = FontLayoutService.getInstance().charWidth2D(metrics, 32);
        return (int)spaceWidth * editor.getSettings().getRightMargin(editor.getProject());
    }

    private static int getLineEnd(@NotNull Editor editor, int offset) {
        if (editor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(25);
        }
        return editor.getDocument().getLineEndOffset(editor.getDocument().getLineNumber(offset));
    }

    private static /* synthetic */ SqlNotebookModel.CellsAccessor lambda$getOrCreateResult$0(PsiFile file, ScriptModel sm) throws RuntimeException {
        return SqlNotebookModel.getCellAccessor(file, (ScriptModel<PsiElement>)sm, (Condition<? super TextRange>)Conditions.alwaysTrue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUis";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncollectedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCell";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleVertically";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "argsToCell";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUncollectedResults";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "asResult";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTextWidth";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLineEnd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContainerWeakRef
    extends WeakReference<EditorResultsContainer> {
        private static final long LIFETIME = TimeUnit.MINUTES.toMillis(5L);
        private final Disposable myParent;
        private long myHiddenTime;

        ContainerWeakRef(@NotNull EditorResultsContainer referent, @NotNull Disposable parent2) {
            if (referent == null) {
                ContainerWeakRef.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                ContainerWeakRef.$$$reportNull$$$0(1);
            }
            super(referent);
            this.myHiddenTime = -1L;
            this.myParent = parent2;
        }

        boolean isOutdated() {
            return this.myHiddenTime != -1L && System.currentTimeMillis() - this.myHiddenTime > LIFETIME;
        }

        void hidden() {
            this.myHiddenTime = System.currentTimeMillis();
        }

        void shown() {
            this.myHiddenTime = -1L;
        }

        void dispose() {
            Disposer.dispose((Disposable)this.myParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseInEditorResults$ContainerWeakRef";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LayoutProvider
    implements SqlNotebookModel.EditorLayoutProvider {
        private final Editor myEditor;

        LayoutProvider(Editor editor) {
            if (editor == null) {
                LayoutProvider.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        @Override
        public int[] getInlayOffsets(@NotNull TextRange range) {
            if (range == null) {
                LayoutProvider.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            TIntArrayList result = new TIntArrayList();
            for (Result result2 : DatabaseInEditorResults.this.getUncollectedResults(this.myEditor)) {
                if (result2 == null || !result2.isShown() || !range.contains(result2.getOffset())) continue;
                result.add(result2.getOffset());
            }
            return result.toNativeArray();
        }

        @Override
        public int getInlayLength() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$LayoutProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInlayOffsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RemoveCellAction
    extends AnAction {
        private final ResultConstructor myResult;

        RemoveCellAction(@NotNull ResultConstructor result) {
            if (result == null) {
                RemoveCellAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message((String)"console.close.embedded.results", (Object[])new Object[0]));
            this.myResult = result;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveCellAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(this.myResult.isStable());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveCellAction.$$$reportNull$$$0(2);
            }
            this.myResult.destroy();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$RemoveCellAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CloseRenderer
    extends GutterIconRenderer {
        private final ResultConstructor myResult;
        private final RemoveCellAction myAction;
        private final Icon myIcon;

        CloseRenderer(@NotNull ResultConstructor result, int height) {
            if (result == null) {
                CloseRenderer.$$$reportNull$$$0(0);
            }
            this.myResult = result;
            this.myAction = new RemoveCellAction(this.myResult);
            this.myIcon = new MyIcon(height);
        }

        @Nullable
        public AnAction getClickAction() {
            return this.myAction;
        }

        @Nullable
        public String getTooltipText() {
            return this.myAction.getTemplateText();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CloseRenderer renderer = (CloseRenderer)((Object)o);
            return this.myResult.equals(renderer.myResult);
        }

        public int hashCode() {
            return this.myResult.hashCode();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myResult.isStable() ? this.myIcon : EmptyIcon.ICON_0;
            if (icon == null) {
                CloseRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$CloseRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$CloseRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyIcon
        implements Icon {
            private static final Icon CLOSE = AllIcons.Actions.Close;
            private final int myOffset;

            MyIcon(int offset) {
                this.myOffset = offset;
            }

            @Override
            public int getIconHeight() {
                return CLOSE.getIconHeight() + this.myOffset;
            }

            @Override
            public int getIconWidth() {
                return CLOSE.getIconWidth();
            }

            @Override
            public void paintIcon(Component c2, Graphics g, int x, int y) {
                CLOSE.paintIcon(c2, g, x, y + this.myOffset);
            }
        }
    }

    private static class PanelBorder
    extends CustomLineBorder {
        private final Editor myEditor;

        PanelBorder(@NotNull Editor editor) {
            if (editor == null) {
                PanelBorder.$$$reportNull$$$0(0);
            }
            super((Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
            this.myEditor = editor;
        }

        protected Color getColor() {
            return this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/session/DatabaseInEditorResults$PanelBorder", "<init>"));
        }
    }

    static class EditorResultsContainer
    implements ResultConstructor {
        private final Disposable myParent;
        private final BooleanFunction<EditorResultsContainer> myIsAlive;
        private final ContainerWeakRef myWeakRef;
        private final AtomicLong myLastScrollEvent;
        private final MyScrollBarListener myScrollBarListener;
        private EditorEx myEditor;
        private JdbcConsole myConsole;
        private RunnerLayoutUi myUi;
        private boolean myShown;
        private Inlay<?> myInlay;
        private int myInitialOffset;
        private ParentDisposalController myParentController;
        private boolean myInProgress;

        EditorResultsContainer(@NotNull Disposable parent2, @NotNull Project project, @NotNull EditorEx editor, @NotNull JdbcConsole console, @NotNull BooleanFunction<EditorResultsContainer> isAlive, int initialOffset) {
            if (parent2 == null) {
                EditorResultsContainer.$$$reportNull$$$0(0);
            }
            if (project == null) {
                EditorResultsContainer.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                EditorResultsContainer.$$$reportNull$$$0(2);
            }
            if (console == null) {
                EditorResultsContainer.$$$reportNull$$$0(3);
            }
            if (isAlive == null) {
                EditorResultsContainer.$$$reportNull$$$0(4);
            }
            this.myParent = parent2;
            this.myEditor = editor;
            this.myConsole = console;
            this.myIsAlive = isAlive;
            this.myInitialOffset = initialOffset;
            this.myLastScrollEvent = new AtomicLong();
            this.myScrollBarListener = new MyScrollBarListener(this.myLastScrollEvent);
            String title = console.getTitle();
            this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("not_persistent_id", title, title, parent2);
            this.myUi.getDefaults().initTabDefaults(0, "not_persistent_id", null);
            this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false).setTabPopupActions((ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup.Embedded"));
            this.myShown = true;
            this.myWeakRef = new ContainerWeakRef(this, parent2);
        }

        @Override
        public int getOffset() {
            return this.myInlay != null ? this.myInlay.getOffset() : this.myInitialOffset;
        }

        @Override
        public void setInProgress(boolean progress) {
            this.myInProgress = progress;
        }

        @Override
        public void hide() {
            if (this.myInlay == null) {
                return;
            }
            this.justHide();
            this.perform((UndoableAction)new BasicUndoableAction(new Document[]{this.myEditor.getDocument()}){

                public void undo() {
                    this.justShow();
                }

                public void redo() {
                    this.justHide();
                }
            }, DatabaseBundle.message((String)"console.notebook.mode.hide.results", (Object[])new Object[0]));
        }

        @Override
        public void show() {
            if (this.myInlay != null) {
                return;
            }
            this.justShow();
            this.perform((UndoableAction)new BasicUndoableAction(new Document[]{this.myEditor.getDocument()}){

                public void redo() {
                    this.justShow();
                }

                public void undo() {
                    this.justHide();
                }
            }, DatabaseBundle.message((String)"console.notebook.mode.show.results", (Object[])new Object[0]));
        }

        @Override
        public void saveBeforeChanges() {
            this.justHide();
        }

        @Override
        public void restoreAfterChanges() {
            this.justShow();
        }

        @Override
        public void destroy() {
            this.myParentController.run(() -> Disposer.dispose((Disposable)this.myParent));
        }

        @NotNull
        ContainerWeakRef getWeakRef() {
            ContainerWeakRef containerWeakRef = this.myWeakRef;
            if (containerWeakRef == null) {
                EditorResultsContainer.$$$reportNull$$$0(5);
            }
            return containerWeakRef;
        }

        private void perform(@NotNull UndoableAction action2, @Nls @NotNull String name) {
            if (action2 == null) {
                EditorResultsContainer.$$$reportNull$$$0(6);
            }
            if (name == null) {
                EditorResultsContainer.$$$reportNull$$$0(7);
            }
            CommandProcessor instance = CommandProcessor.getInstance();
            Project project = this.myConsole.getProject();
            instance.executeCommand(project, () -> UndoManager.getInstance((Project)project).undoableActionPerformed(action2), name, null);
        }

        private void justHide() {
            if (!this.myIsAlive.fun((Object)this) || this.myInlay == null) {
                return;
            }
            this.myEditor.getScrollPane().getVerticalScrollBar().removeAdjustmentListener(this.myScrollBarListener);
            this.myInitialOffset = this.myInlay.getOffset();
            this.myParentController.run(() -> Disposer.dispose(this.myInlay));
            this.myParentController = null;
            this.myInlay = null;
            this.myShown = false;
            this.myWeakRef.hidden();
        }

        private void justShow() {
            if (!this.myIsAlive.fun((Object)this) || this.myInlay != null) {
                return;
            }
            JComponent component = this.myUi.getComponent();
            component.setBorder((Border)((Object)new PanelBorder((Editor)this.myEditor)));
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)component, "Center");
            MyJLayeredPane pane = new MyJLayeredPane();
            ResultViewWithRows resultView = (ResultViewWithRows)UIUtil.uiTraverser((Component)component).filter(ResultViewWithRows.class).first();
            if (this.myEditor instanceof EditorImpl && resultView != null) {
                int height = resultView.getRowHeight() * 7;
                pane.setPreferredSize(new Dimension(DatabaseInEditorResults.getEditorTextWidth((EditorImpl)this.myEditor) + 1, height));
            }
            pane.add(panel2);
            pane.setLayer(panel2, JLayeredPane.DEFAULT_LAYER);
            EventTransparentPanel transparentPanel = new EventTransparentPanel(this.myLastScrollEvent);
            pane.add(transparentPanel);
            pane.setLayer(transparentPanel, JLayeredPane.DEFAULT_LAYER + 1);
            int rowHeight = (int)((double)this.myEditor.getLineHeight() * 0.35);
            panel2.add(Box.createVerticalStrut(rowHeight), "North");
            panel2.setOpaque(false);
            transparentPanel.addMouseWheelListener(new MyMouseWheelListener(transparentPanel, panel2, (Editor)this.myEditor, this.myLastScrollEvent));
            this.myEditor.getScrollPane().getVerticalScrollBar().addAdjustmentListener(this.myScrollBarListener);
            int leOffset = DatabaseInEditorResults.getLineEnd((Editor)this.myEditor, this.myInitialOffset);
            EditorEmbeddedComponentManager.Properties properties = new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.any(), __ -> new CloseRenderer(this, rowHeight), true, false, 0, leOffset);
            Inlay inlay = Objects.requireNonNull(EditorEmbeddedComponentManager.getInstance().addComponent(this.myEditor, (JComponent)pane, properties));
            this.setInlay(inlay);
        }

        @Override
        public boolean isStable() {
            return !this.myInProgress;
        }

        @Override
        public boolean isShown() {
            return this.myShown;
        }

        @Override
        @NotNull
        public RunnerLayoutUi getUi() {
            RunnerLayoutUi runnerLayoutUi = this.myUi;
            if (runnerLayoutUi == null) {
                EditorResultsContainer.$$$reportNull$$$0(8);
            }
            return runnerLayoutUi;
        }

        @Override
        @Nullable
        public Inlay<?> getInlay() {
            return this.myInlay;
        }

        private void setInlay(@NotNull Inlay<?> inlay) {
            if (inlay == null) {
                EditorResultsContainer.$$$reportNull$$$0(9);
            }
            this.myInlay = inlay;
            this.myShown = true;
            this.myParentController = new ParentDisposalController(this.myParent);
            Disposer.register((Disposable)this.myParent, this.myInlay);
            Disposer.register(this.myInlay, (Disposable)this.myParentController);
            this.myWeakRef.shown();
        }

        void clearStrongReferences() {
            this.myUi = null;
            this.myInlay = null;
            this.myConsole = null;
            this.myEditor = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isAlive";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWeakRef";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setInlay";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class EventTransparentPanel
        extends JPanel {
            private final AtomicLong myTime;

            EventTransparentPanel(@NotNull AtomicLong time) {
                if (time == null) {
                    EventTransparentPanel.$$$reportNull$$$0(0);
                }
                this.myTime = time;
                this.setOpaque(false);
            }

            @Override
            public boolean contains(int x, int y) {
                return System.currentTimeMillis() - this.myTime.get() < 100L && super.contains(x, y);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "time", "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$EventTransparentPanel", "<init>"));
            }
        }

        private static class MyMouseWheelListener
        implements MouseWheelListener {
            private final JPanel myGlassPane;
            private final JPanel myPanel;
            private final Editor myEditor;
            private final AtomicLong myTime;

            MyMouseWheelListener(@NotNull JPanel glassPane, @NotNull JPanel panel2, @NotNull Editor editor, @NotNull AtomicLong time) {
                if (glassPane == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(0);
                }
                if (panel2 == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(1);
                }
                if (editor == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(2);
                }
                if (time == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(3);
                }
                this.myGlassPane = glassPane;
                this.myPanel = panel2;
                this.myEditor = editor;
                this.myTime = time;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (System.currentTimeMillis() - this.myTime.get() > 100L && MyMouseWheelListener.redispatch(e, this.myGlassPane, this.myPanel)) {
                    return;
                }
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)this.myEditor.getContentComponent());
            }

            static boolean redispatch(@NotNull MouseEvent e, @NotNull JComponent from, @NotNull JComponent to) {
                if (e == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(4);
                }
                if (from == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(5);
                }
                if (to == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(6);
                }
                Point converted = SwingUtilities.convertPoint(from, e.getPoint(), to);
                Component deepest = UIUtil.getDeepestComponentAt((Component)to, (int)converted.x, (int)converted.y);
                if (deepest == null) {
                    return false;
                }
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)deepest);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "glassPane";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "time";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$MyMouseWheelListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "redispatch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class MyScrollBarListener
        implements AdjustmentListener {
            private final AtomicLong myValue;

            MyScrollBarListener(@NotNull AtomicLong value2) {
                if (value2 == null) {
                    MyScrollBarListener.$$$reportNull$$$0(0);
                }
                this.myValue = value2;
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    this.myValue.set(System.currentTimeMillis());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$MyScrollBarListener", "<init>"));
            }
        }

        private static class MyJLayeredPane
        extends JLayeredPane {
            private MyJLayeredPane() {
            }

            @Override
            public void doLayout() {
                Component[] components;
                for (Component component : components = this.getComponents()) {
                    component.setBounds(this.getBounds());
                }
            }
        }

        private static class ParentDisposalController
        implements Disposable {
            private final Disposable myParent;
            private boolean myDisposalInProgress;

            ParentDisposalController(@NotNull Disposable parent2) {
                if (parent2 == null) {
                    ParentDisposalController.$$$reportNull$$$0(0);
                }
                this.myParent = parent2;
            }

            void run(@NotNull Runnable runnable) {
                if (runnable == null) {
                    ParentDisposalController.$$$reportNull$$$0(1);
                }
                if (this.myDisposalInProgress) {
                    return;
                }
                this.myDisposalInProgress = true;
                try {
                    runnable.run();
                }
                finally {
                    this.myDisposalInProgress = false;
                }
            }

            public void dispose() {
                if (!this.myDisposalInProgress) {
                    Disposer.dispose((Disposable)this.myParent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$ParentDisposalController";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class Arguments {
        final EditorEx editor;
        final DataRequest.CoupledWithEditor request;
        final JdbcConsole console;

        public Arguments(@NotNull EditorEx editor, @NotNull DataRequest.CoupledWithEditor request, @NotNull JdbcConsole console) {
            if (editor == null) {
                Arguments.$$$reportNull$$$0(0);
            }
            if (request == null) {
                Arguments.$$$reportNull$$$0(1);
            }
            if (console == null) {
                Arguments.$$$reportNull$$$0(2);
            }
            this.editor = editor;
            this.request = request;
            this.console = console;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseInEditorResults$Arguments";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface ResultConstructor
    extends Result {
        public void setInProgress(boolean var1);
    }

    public static interface Result {
        public void hide();

        public void show();

        public void destroy();

        public boolean isShown();

        public boolean isStable();

        public int getOffset();

        public void saveBeforeChanges();

        public void restoreAfterChanges();

        @NotNull
        public RunnerLayoutUi getUi();

        @Nullable
        public Inlay<?> getInlay();
    }
}

