/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEngine
extends DataRequest.Visitor
implements DataProducer,
Disposable {
    protected static final Logger LOG = Logger.getInstance(AbstractEngine.class);
    private final ThreadPoolExecutor myExecutorService;
    private final Project myProject;
    private final DataBus.Producing myMessageBus;
    private final DataAuditor myDataAuditor;
    private final DataConsumer myDataConsumer;
    private final AtomicReference<DataRequest.Context> myRequestContext;
    private final AtomicBoolean myCancelled;

    protected AbstractEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus) {
        if (project == null) {
            AbstractEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            AbstractEngine.$$$reportNull$$$0(1);
        }
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)StringUtil.getShortName((String)this.getClass().getName()));
        this.myRequestContext = new AtomicReference();
        this.myCancelled = new AtomicBoolean(false);
        this.myProject = project;
        this.myMessageBus = messageBus;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDataAuditor = messageBus.getDataAuditor();
        this.myDataConsumer = messageBus.getDataConsumer();
        messageBus.addProducer(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractEngine.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    protected DataAuditor getDataAuditor() {
        DataAuditor dataAuditor = this.myDataAuditor;
        if (dataAuditor == null) {
            AbstractEngine.$$$reportNull$$$0(3);
        }
        return dataAuditor;
    }

    @NotNull
    protected DataConsumer getDataConsumer() {
        DataConsumer dataConsumer = this.myDataConsumer;
        if (dataConsumer == null) {
            AbstractEngine.$$$reportNull$$$0(4);
        }
        return dataConsumer;
    }

    @NotNull
    protected DataRequest.Context getRequestContext() {
        DataRequest.Context context = this.myRequestContext.get();
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(5);
        }
        return context;
    }

    @Nullable
    protected DataRequest.Context getRequestContextIfAny() {
        return this.myRequestContext.get();
    }

    @Override
    public void processRequest(@NotNull DataRequest request) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(6);
        }
        request.accept(this);
    }

    @Override
    public void visitCancel(DataRequest.Cancel r) {
        if (!this.cancelPendingRequests()) {
            this.terminate();
        }
    }

    @Override
    public void visitRequest(DataRequest r) {
        LOG.error("unknown request: " + r);
    }

    public final void dispose() {
        this.myMessageBus.beforeProducerRemove(this);
        this.submitRunnable(this::releaseConnection);
        this.submitRunnable(() -> this.myMessageBus.afterProducerRemove(this));
        this.cancelAndPassThroughRemainingRequests();
        this.myExecutorService.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutorService.awaitTermination(120L, TimeUnit.SECONDS);
                LOG.info("Engine execution service termination completed");
            }
            catch (InterruptedException e) {
                LOG.warn("Engine execution service termination interrupted");
            }
        }
    }

    protected void releaseConnection() {
    }

    public boolean isDisposed() {
        return this.myExecutorService.isShutdown();
    }

    public void terminate() {
        this.cancelPendingRequests();
    }

    protected boolean cancelPendingRequests() {
        this.cancelAndPassThroughRemainingRequests();
        return true;
    }

    private void cancelAndPassThroughRemainingRequests() {
        if (this.myCancelled.compareAndSet(false, true)) {
            this.submitRunnable(() -> this.myCancelled.compareAndSet(true, false));
        }
    }

    @NotNull
    protected abstract DataRequest.Context createRequestContext(@NotNull DataRequest var1);

    protected void submitRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractEngine.$$$reportNull$$$0(7);
        }
        AsyncTask.currentFrame().compute(this.myExecutorService, () -> {
            runnable.run();
            return null;
        });
    }

    private void submitRunnable(DataRequest request, Computable<Boolean> runnable) {
        ProgressIndicator indicator = request.isAsyncFriendly() ? AsyncUtil.getAsyncFriendlyIndicator() : new EmptyProgressIndicator();
        this.getDataAuditor().jobSubmitted(request, this);
        this.submitRunnable(() -> {
            Ref result = Ref.create((Object)false);
            try {
                AsyncUtil.underProgress(() -> {
                    if (this.myCancelled.get()) {
                        return;
                    }
                    result.set((Object)((Boolean)runnable.compute()));
                }, indicator);
            }
            finally {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                try {
                    this.getDataAuditor().jobFinished(request, this);
                }
                finally {
                    DbImplUtil.setActionCallbackDone(request.getPromise(), (Boolean)result.get());
                }
            }
        });
    }

    protected void submitRequest(@NotNull DataRequest request, @NotNull ThrowableComputable<Boolean, Exception> computable) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(8);
        }
        if (computable == null) {
            AbstractEngine.$$$reportNull$$$0(9);
        }
        this.submitRunnable(request, (Computable<Boolean>)((Computable)() -> {
            boolean result = false;
            DataRequest.Context context = null;
            try {
                context = this.createRequestContext(request);
                this.myRequestContext.set(context);
                try {
                    this.onRequestStarted(context);
                    result = (Boolean)computable.compute();
                }
                finally {
                    this.onRequestFinished(context);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                if (context == null) {
                    LOG.error(e);
                } else if (!this.myCancelled.get()) {
                    try {
                        context.reportException(e, null);
                    }
                    catch (Exception e1) {
                        LOG.error((Throwable)new CompoundRuntimeException(Arrays.asList(e, e1)));
                    }
                }
            }
            finally {
                this.myRequestContext.compareAndSet(context, null);
            }
            return result;
        }));
    }

    protected void onRequestFinished(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(10);
        }
        this.getDataAuditor().requestFinished(context);
    }

    protected void onRequestStarted(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(11);
        }
        this.getDataAuditor().requestStarted(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/AbstractEngine";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/AbstractEngine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAuditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataConsumer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "submitRunnable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "submitRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinished";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStarted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

