/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.util.NameTemplate;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CliConfigurationBase
implements CliConfiguration {
    private final List<CliArgumentGroup<?>> myGroups;
    private final String[] myHostArgs;
    private final String[] myPortArgs;
    private final String[] myUsernameArgs;
    private final String[] myPasswordArgs;
    private final String[] myFileArgs;
    private final String[] mySslCaArgs;
    private final String[] mySslCertArgs;
    private final String[] mySslKeyArgs;
    private final String myEnvironmentVarName;
    private final String myPropertyKey;
    private final String myName;

    protected CliConfigurationBase(@NotNull List<CliArgumentGroup<?>> groups, String @NotNull [] hostArgs, String @NotNull [] portArgs, String @NotNull [] usernameArgs, String @NotNull [] passwordArgs, String @NotNull [] fileArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name) {
        if (groups == null) {
            CliConfigurationBase.$$$reportNull$$$0(0);
        }
        if (environmentVarName == null) {
            CliConfigurationBase.$$$reportNull$$$0(1);
        }
        if (propertyKey == null) {
            CliConfigurationBase.$$$reportNull$$$0(2);
        }
        if (name == null) {
            CliConfigurationBase.$$$reportNull$$$0(3);
        }
        if (hostArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(4);
        }
        if (portArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(5);
        }
        if (usernameArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(6);
        }
        if (passwordArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(7);
        }
        if (fileArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(8);
        }
        this(groups, hostArgs, portArgs, usernameArgs, passwordArgs, fileArgs, null, null, null, environmentVarName, propertyKey, name);
    }

    protected CliConfigurationBase(@NotNull List<CliArgumentGroup<?>> groups, String @NotNull [] hostArgs, String @NotNull [] portArgs, String @NotNull [] usernameArgs, String @NotNull [] passwordArgs, String @NotNull [] fileArgs, String @Nullable [] sslCaArgs, String @Nullable [] sslCertArgs, String @Nullable [] sslKeyArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name) {
        if (groups == null) {
            CliConfigurationBase.$$$reportNull$$$0(9);
        }
        if (environmentVarName == null) {
            CliConfigurationBase.$$$reportNull$$$0(10);
        }
        if (propertyKey == null) {
            CliConfigurationBase.$$$reportNull$$$0(11);
        }
        if (name == null) {
            CliConfigurationBase.$$$reportNull$$$0(12);
        }
        if (hostArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(13);
        }
        if (portArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(14);
        }
        if (usernameArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(15);
        }
        if (passwordArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(16);
        }
        if (fileArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(17);
        }
        this.myGroups = groups;
        this.myHostArgs = hostArgs;
        this.myPortArgs = portArgs;
        this.myUsernameArgs = usernameArgs;
        this.myPasswordArgs = passwordArgs;
        this.myFileArgs = fileArgs;
        this.mySslCaArgs = sslCaArgs;
        this.mySslCertArgs = sslCertArgs;
        this.mySslKeyArgs = sslKeyArgs;
        this.myEnvironmentVarName = environmentVarName;
        this.myPropertyKey = propertyKey;
        this.myName = name;
    }

    @Override
    @NotNull
    public CliPanelDecorator getDecorator() {
        return new CliPanelDecorator.DefaultCliPanelDecorator(this.getName());
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            CliConfigurationBase.$$$reportNull$$$0(18);
        }
        List<String> list = variants;
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text2) {
        if (elements == null) {
            CliConfigurationBase.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(21);
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(text2);
        List mapped = ContainerUtil.map(lexemes, CliLexeme::convertLineWrapToWhitespace);
        String string = StringUtil.join((Collection)mapped, CliLexeme::getText, (String)"");
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @NotNull CliConfiguration.Parameters parameters) {
        if (command == null) {
            CliConfigurationBase.$$$reportNull$$$0(23);
        }
        if (parameters == null) {
            CliConfigurationBase.$$$reportNull$$$0(24);
        }
        String string = command + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myUsernameArgs), parameters.username) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myHostArgs), parameters.host) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myPortArgs), parameters.port) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCaArgs), parameters.sslCa) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCertArgs), parameters.sslCert) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslKeyArgs), parameters.sslKey);
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        if (SystemInfo.isLinux) {
            return "/usr/bin";
        }
        if (SystemInfo.isMac) {
            return "/usr/local/bin";
        }
        return null;
    }

    @Override
    @NotNull
    public List<CliComponent> getComponents() {
        List<CliComponent> list = this.myGroups.stream().flatMap(group -> group.createComponents().stream()).collect(Collectors.toList());
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPropertyKey() {
        String string = this.myPropertyKey;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterSearcher getFileParameterSearcher() {
        return new CliParameterSearcherImpl(this.myFileArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        return new LexemeIndicators(this.myPasswordArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getUsernameIndicators() {
        return new LexemeIndicators(this.myUsernameArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getHostIndicators() {
        return new LexemeIndicators(this.myHostArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getPortIndicators() {
        return new LexemeIndicators(this.myPortArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCertIndicators() {
        return this.mySslCertArgs == null ? null : new LexemeIndicators(this.mySslCertArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslKeyIndicators() {
        return this.mySslKeyArgs == null ? null : new LexemeIndicators(this.mySslKeyArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCaIndicators() {
        return this.mySslCaArgs == null ? null : new LexemeIndicators(this.mySslCaArgs);
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        return "--help";
    }

    @Override
    @NotNull
    public String getValidationCommand() {
        return "--version";
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        CliConfiguration.CliParameterProcessor cliParameterProcessor = CliParameterProcessorBase.INSTANCE;
        if (cliParameterProcessor == null) {
            CliConfigurationBase.$$$reportNull$$$0(29);
        }
        return cliParameterProcessor;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            CliConfigurationBase.$$$reportNull$$$0(30);
        }
        return new CliBuilderBase(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.myEnvironmentVarName, this.getSubstitutor());
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = DatabaseObjectsPreparer.idle().onlyIf((Condition<Collection<DbElement>>)((Condition)collection -> JBIterable.from((Iterable)collection).map(e -> e.getDataSource()).unique().size() == 1)).filter((Condition<DbElement>)((Condition)e -> ArrayUtil.contains((Object)e.getKind(), (Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.SCHEMA}) || e instanceof DbDataSource || DbImplUtil.isDataTable((DasTable)ObjectUtils.tryCast((Object)e, DasTable.class)))).requireNotEmpty();
        if (databaseObjectsPreparer == null) {
            CliConfigurationBase.$$$reportNull$$$0(31);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    protected String getEnvironmentVarName() {
        String string = this.myEnvironmentVarName;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @Nullable
    public CliConfiguration.CliSubstitutor getSubstitutor() {
        return null;
    }

    @NotNull
    protected abstract StringCliArgument getDatabaseArgument();

    @NotNull
    private static String notNullPair(@NotNull String argument, @Nullable String parameter) {
        if (argument == null) {
            CliConfigurationBase.$$$reportNull$$$0(33);
        }
        Object object = parameter == null || argument.isEmpty() ? "" : " " + argument + parameter;
        if (object == null) {
            CliConfigurationBase.$$$reportNull$$$0(34);
        }
        return object;
    }

    protected static void put(@NotNull Map<String, String> map2, @NotNull String text2, String ... args) {
        if (map2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(35);
        }
        if (text2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(36);
        }
        if (args == null) {
            CliConfigurationBase.$$$reportNull$$$0(37);
        }
        for (String arg : args) {
            map2.put(arg, text2);
        }
    }

    @NotNull
    protected static List<CliLexeme> removeAll(@NotNull List<CliLexeme> lexemes, String ... args) {
        if (lexemes == null) {
            CliConfigurationBase.$$$reportNull$$$0(38);
        }
        if (args == null) {
            CliConfigurationBase.$$$reportNull$$$0(39);
        }
        return new ArrayList<CliLexeme>(ContainerUtil.filter(lexemes, (Condition)Conditions.not(DbCliUtil.lexemeFinder(args))));
    }

    @NotNull
    protected static List<CliLexeme> addAll(@NotNull List<CliLexeme> lexemes, @NotNull String command, String ... args) {
        if (lexemes == null) {
            CliConfigurationBase.$$$reportNull$$$0(40);
        }
        if (command == null) {
            CliConfigurationBase.$$$reportNull$$$0(41);
        }
        if (args == null) {
            CliConfigurationBase.$$$reportNull$$$0(42);
        }
        int offset = 0;
        for (String arg : args) {
            int spaceLength;
            int end2 = command.length() + offset;
            CliLexeme last = (CliLexeme)ContainerUtil.getLastItem(lexemes);
            boolean isSpace = last != null && last.isWhitespace();
            int n = spaceLength = isSpace ? 0 : 1;
            if (!isSpace) {
                lexemes.add(new CliLexeme(" ", DbCliTokenType.BAD, end2, end2 + 1));
            }
            CliLexeme lexeme = new CliLexeme(arg, DbCliTokenType.LONG_PARAMETER, end2 + spaceLength, end2 + arg.length() + spaceLength);
            offset += arg.length() + spaceLength;
            lexemes.add(lexeme);
        }
        List<CliLexeme> list = lexemes;
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(43);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVarName";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostArgs";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portArgs";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usernameArgs";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordArgs";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeArguments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyKey";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterProcessor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVarName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullPair";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 43: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeArguments";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notNullPair";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class CliSubstitutorBase
    implements CliConfiguration.CliSubstitutor {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final NameTemplate.Placeholder TIMESTAMP_PLACEHOLDER = new NameTemplate.Placeholder("{timestamp}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.current.timestamp", (Object[])new Object[0]), "2019-11-19 21:34:51");
        private static final NameTemplate.Placeholder DATA_SOURCE_PLACEHOLDER = new NameTemplate.Placeholder("{data_source}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.data.source", (Object[])new Object[0]), "Postgres local");
        private static final NameTemplate.Placeholder DATABASE_PLACEHOLDER = new NameTemplate.Placeholder("{database}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.database", (Object[])new Object[0]), "postgres");
        private final CliConfigurationBase myConfiguration;

        public CliSubstitutorBase(@NotNull CliConfigurationBase configuration) {
            if (configuration == null) {
                CliSubstitutorBase.$$$reportNull$$$0(0);
            }
            this.myConfiguration = configuration;
        }

        @Override
        @NotNull
        public String substitute(@NotNull LocalDataSource dataSource2, @NotNull List<String> parameterizable, @NotNull String command) {
            TextRange fileRange;
            if (dataSource2 == null) {
                CliSubstitutorBase.$$$reportNull$$$0(1);
            }
            if (parameterizable == null) {
                CliSubstitutorBase.$$$reportNull$$$0(2);
            }
            if (command == null) {
                CliSubstitutorBase.$$$reportNull$$$0(3);
            }
            if ((fileRange = this.myConfiguration.getFileParameterSearcher().searchRange(command, parameterizable)) == null) {
                String string = command;
                if (string == null) {
                    CliSubstitutorBase.$$$reportNull$$$0(4);
                }
                return string;
            }
            String database = this.search(command, parameterizable);
            String file = fileRange.substring(command);
            LocalDateTime currentTime = LocalDateTime.now();
            String fileNameWithSubstitutions = new NameTemplate.SubstitutionBuilder(file).substitute(TIMESTAMP_PLACEHOLDER, FileUtil.sanitizeFileName((String)FORMATTER.format(currentTime))).substitute(DATA_SOURCE_PLACEHOLDER, FileUtil.sanitizeFileName((String)dataSource2.getName())).substitute(DATABASE_PLACEHOLDER, FileUtil.sanitizeFileName((String)(database == null ? "unknown_db" : database))).build();
            String string = command.substring(0, fileRange.getStartOffset()) + fileNameWithSubstitutions + command.substring(fileRange.getEndOffset());
            if (string == null) {
                CliSubstitutorBase.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDocumentation() {
            String string = DatabaseBundle.message((String)"database.cli.integration.substitution.pattern.message.pattern", (Object[])new Object[]{CliSubstitutorBase.TIMESTAMP_PLACEHOLDER.text, CliSubstitutorBase.DATABASE_PLACEHOLDER.text, CliSubstitutorBase.DATA_SOURCE_PLACEHOLDER.text});
            if (string == null) {
                CliSubstitutorBase.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        public Collection<String> getDefaultPatterns() {
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])new String[]{CliSubstitutorBase.DATA_SOURCE_PLACEHOLDER.text, CliSubstitutorBase.TIMESTAMP_PLACEHOLDER.text});
            if (immutableList == null) {
                CliSubstitutorBase.$$$reportNull$$$0(7);
            }
            return immutableList;
        }

        @Nullable
        private String search(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                CliSubstitutorBase.$$$reportNull$$$0(8);
            }
            if (parameterizable == null) {
                CliSubstitutorBase.$$$reportNull$$$0(9);
            }
            TextRange range = this.searchRange(command, parameterizable);
            StringCliArgument arg = this.myConfiguration.getDatabaseArgument();
            return range == null ? null : DbCliUtil.clearString(DbCliUtil.cutParameter(command, range), arg.getUnquoter());
        }

        @Nullable
        private TextRange searchRange(@NotNull String command, @NotNull List<String> parameterizable) {
            ArrayList<CliLexeme> lexemes;
            CliLexeme executable;
            if (command == null) {
                CliSubstitutorBase.$$$reportNull$$$0(10);
            }
            if (parameterizable == null) {
                CliSubstitutorBase.$$$reportNull$$$0(11);
            }
            if ((executable = (CliLexeme)ContainerUtil.getFirstItem(lexemes = new ArrayList<CliLexeme>(DbCliUtil.filteredLexemes(command, parameterizable)))) != null && executable.isParameter()) {
                lexemes.remove(executable);
            }
            CliContextDescriptor cd = new CliContextDescriptor(lexemes, CliContextDescriptor.Operation.UNKNOWN);
            ArrayList suitable = new ArrayList();
            StringCliArgument arg = this.myConfiguration.getDatabaseArgument();
            DbCliUtil.iterateOverLexemes(command, lexemes, (cur2, next) -> {
                if (arg.isMyLexeme(command, cur2, next, cd)) {
                    suitable.add(Pair.create((Object)cur2, (Object)next));
                }
            });
            if (suitable.size() != 1) {
                return null;
            }
            Pair param = Objects.requireNonNull((Pair)ContainerUtil.getFirstItem(suitable));
            return arg.getComponentValueRange(command, (CliLexeme)param.first, (CliLexeme)param.second, cd);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 3: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliSubstitutorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliSubstitutorBase";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocumentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "search";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "searchRange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class CliNotificationManagerBase
    implements CliConfiguration.CliNotificationManager {
        private static final int DELAY = 50;
        private final Alarm myQueue;
        private final Project myProject;
        private final CliConfiguration.Operation myOperation;
        private final String myName;
        private DasDataSource mySystem;
        private volatile boolean myFirst;

        public CliNotificationManagerBase(@NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name) {
            if (project == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(0);
            }
            if (operation == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(1);
            }
            if (name == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myOperation = operation;
            this.myName = name;
            this.myQueue = new Alarm();
            this.myFirst = true;
        }

        @Override
        public void start(@NotNull ProgressIndicator indicator, @NotNull DasDataSource system) {
            if (indicator == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(3);
            }
            if (system == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(4);
            }
            this.mySystem = system;
            indicator.setText(this.myOperation.getStartText(this.myName, system.getName()));
        }

        @Override
        public void update(@NotNull ProgressIndicator indicator, @NotNull DataAuditor.PrintingAdapter reporter, @NlsContexts.ProgressDetails @NotNull String text2, @NotNull Key outputType) {
            if (indicator == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(5);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(7);
            }
            if (outputType == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(8);
            }
            if (indicator.isCanceled()) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                return;
            }
            ConsoleViewContentType type = CliNotificationManagerBase.getType(outputType);
            this.notification(reporter, type, text2);
            indicator.setText2(text2);
        }

        @Override
        public void finished(@NotNull String path, @NotNull DataAuditor.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(9);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(10);
            }
            if (cancelled) {
                this.disposeQueue();
                this.notifyFinish(path, reporter, true);
                return;
            }
            this.myQueue.addRequest(() -> {
                this.notifyFinish(path, reporter, false);
                this.disposeQueue();
            }, 50);
        }

        private void disposeQueue() {
            Disposer.dispose((Disposable)this.myQueue);
        }

        private void notifyFinish(@NotNull String path, @NotNull DataAuditor.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(11);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(12);
            }
            String message2 = DatabaseBundle.message((String)"notification.content.choice.process.cancelled.process.finished", (Object[])new Object[]{this.myName, cancelled ? 0 : 1});
            reporter.println(message2, ConsoleViewContentType.NORMAL_OUTPUT);
            if (this.myOperation == CliConfiguration.Operation.RESTORE) {
                DbUIUtil.createNotification(this.mySystem, message2, NotificationType.INFORMATION).notify(this.myProject);
                return;
            }
            DbUIUtil.createFileLinkNotification(this.myProject, this.mySystem, message2, NotificationType.INFORMATION, path).notify(this.myProject);
        }

        @NotNull
        private static ConsoleViewContentType getType(Key outputType) {
            ConsoleViewContentType consoleViewContentType = outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT;
            if (consoleViewContentType == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(13);
            }
            return consoleViewContentType;
        }

        private void notification(@NotNull DataAuditor.PrintingAdapter reporter, @NotNull ConsoleViewContentType type, @NlsContexts.NotificationContent @NotNull String text2) {
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(14);
            }
            if (type == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(15);
            }
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(16);
            }
            if (this.myFirst) {
                this.myQueue.addRequest(() -> reporter.println(this.getCommandText(text2), type), 0);
                this.myFirst = false;
                return;
            }
            this.myQueue.addRequest(() -> reporter.rawPrint(text2, type), 50);
        }

        @NlsContexts.NotificationContent
        @NotNull
        protected String getCommandText(@NlsContexts.NotificationContent @NotNull String text2) {
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(17);
            }
            String string = text2;
            if (string == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(18);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 6: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 7: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "finished";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyFinish";
                    break;
                }
                case 13: 
                case 18: {
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "notification";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class CliParameterSearcherImpl
    implements CliConfiguration.CliParameterSearcher {
        private final String[] myArgs;

        private CliParameterSearcherImpl(String @NotNull [] args) {
            if (args == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(0);
            }
            this.myArgs = args;
        }

        @Override
        @Nullable
        public String search(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(1);
            }
            if (parameterizable == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(2);
            }
            return DbCliUtil.getArgumentValue(command, parameterizable, this.myArgs);
        }

        @Override
        @Nullable
        public TextRange searchRange(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(3);
            }
            if (parameterizable == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(4);
            }
            return DbCliUtil.getArgumentValueRange(command, parameterizable, this.myArgs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliParameterSearcherImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "search";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CliParameterProcessorBase
    implements CliConfiguration.CliParameterProcessor {
        private static final CliConfiguration.CliParameterProcessor INSTANCE = new CliParameterProcessorBase();

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(1);
            }
            String string = DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter));
            if (string == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexeme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CliBuilderBase
    implements CliConfiguration.CliBuilder {
        protected final Project myProject;
        protected final CliConfiguration.Operation myOperation;
        protected final String myName;
        private final CliConfiguration.CliParameterProcessor myProcessor;
        private final String myEnvName;
        private final CliConfiguration.CliSubstitutor mySubstitutor;

        public CliBuilderBase(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName, @Nullable CliConfiguration.CliSubstitutor substitutor) {
            if (processor == null) {
                CliBuilderBase.$$$reportNull$$$0(0);
            }
            if (project == null) {
                CliBuilderBase.$$$reportNull$$$0(1);
            }
            if (operation == null) {
                CliBuilderBase.$$$reportNull$$$0(2);
            }
            if (name == null) {
                CliBuilderBase.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                CliBuilderBase.$$$reportNull$$$0(4);
            }
            this.myProcessor = processor;
            this.myProject = project;
            this.myOperation = operation;
            this.myName = name;
            this.myEnvName = envName;
            this.mySubstitutor = substitutor;
        }

        @Override
        @NotNull
        public Pair<GeneralCommandLine, String> build(@NotNull LocalDataSource dataSource2, @NotNull List<String> parameterizable, @NotNull String command, @Nullable String password) {
            if (dataSource2 == null) {
                CliBuilderBase.$$$reportNull$$$0(5);
            }
            if (parameterizable == null) {
                CliBuilderBase.$$$reportNull$$$0(6);
            }
            if (command == null) {
                CliBuilderBase.$$$reportNull$$$0(7);
            }
            String finalCommand = this.mySubstitutor == null ? command : this.mySubstitutor.substitute(dataSource2, parameterizable, command);
            List<String> args = this.getArguments(parameterizable, finalCommand);
            GeneralCommandLine line = new GeneralCommandLine(args);
            Pair pair = Pair.create((Object)(password == null ? line : line.withEnvironment(this.myEnvName, password)), (Object)finalCommand);
            if (pair == null) {
                CliBuilderBase.$$$reportNull$$$0(8);
            }
            return pair;
        }

        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            if (parameterizable == null) {
                CliBuilderBase.$$$reportNull$$$0(9);
            }
            if (command == null) {
                CliBuilderBase.$$$reportNull$$$0(10);
            }
            List<String> list = DbCliUtil.getCommandLineArguments(this.myProcessor, command, parameterizable);
            if (list == null) {
                CliBuilderBase.$$$reportNull$$$0(11);
            }
            return list;
        }

        @Override
        @NotNull
        public CliConfiguration.CliNotificationManager getNotificationManager() {
            return new CliNotificationManagerBase(this.myProject, this.myOperation, this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 8: 
                case 11: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

