/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CliConfiguration {
    @NotNull
    public Map<String, String> getInfoMap();

    @NotNull
    public CliPanelDecorator getDecorator();

    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> var1);

    @NotNull
    public String getValidationCommand();

    @NotNull
    public String getPartOfValidationOut();

    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> var1, @NotNull String var2);

    @NotNull
    public String getCommand(@NotNull String var1, @NotNull Parameters var2);

    @NlsSafe
    @NotNull
    public String getName();

    @NotNull
    public List<CliComponent> getComponents();

    @NotNull
    public String getPropertyKey();

    @NotNull
    public CliParameterSearcher getFileParameterSearcher();

    @NotNull
    public LexemeIndicators getPasswordIndicators();

    @NotNull
    public LexemeIndicators getUsernameIndicators();

    @NotNull
    public LexemeIndicators getHostIndicators();

    @NotNull
    public LexemeIndicators getPortIndicators();

    @Nullable
    public LexemeIndicators getSslCaIndicators();

    @Nullable
    public LexemeIndicators getSslCertIndicators();

    @Nullable
    public LexemeIndicators getSslKeyIndicators();

    @NotNull
    public String getHelpCommand();

    @Nullable
    public String getDefaultSearchPath();

    @NotNull
    public CliDialogValidator getValidator();

    @NotNull
    public List<String> getParameterizableArguments();

    @NotNull
    public CliBuilder getCliBuilder(@NotNull Project var1);

    @NotNull
    public CliParameterProcessor getParameterProcessor();

    @NotNull
    public Operation getOperation();

    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer();

    @Nullable
    public CliSubstitutor getSubstitutor();

    public static enum Operation {
        DUMP{

            @Override
            @NotNull
            String getTaskTitle() {
                String string = DatabaseBundle.message((String)"progress.title.dumping", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NlsContexts.ProgressText
            public String getStartText(String name, String dsName) {
                return DatabaseBundle.message((String)"progress.text.dumping.with", (Object[])new Object[]{name, dsName});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$1", "getTaskTitle"));
            }
        }
        ,
        RESTORE{

            @Override
            @NotNull
            String getTaskTitle() {
                String string = DatabaseBundle.message((String)"progress.title.restoring", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NlsContexts.ProgressText
            public String getStartText(String name, String dsName) {
                return DatabaseBundle.message((String)"progress.text.restoring.with", (Object[])new Object[]{name, dsName});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$2", "getTaskTitle"));
            }
        };


        @NlsContexts.ProgressTitle
        @NotNull
        abstract String getTaskTitle();

        @NlsContexts.ProgressText
        @NotNull
        abstract String getStartText(String var1, String var2);
    }

    public static interface CliParameterSearcher {
        @Nullable
        public String search(@NotNull String var1, @NotNull List<String> var2);

        @Nullable
        public TextRange searchRange(@NotNull String var1, @NotNull List<String> var2);
    }

    public static interface CliNotificationManager {
        public void start(@NotNull ProgressIndicator var1, @NotNull DasDataSource var2);

        public void update(@NotNull ProgressIndicator var1, @NotNull DataAuditor.PrintingAdapter var2, @NlsContexts.ProgressDetails @NotNull String var3, @NotNull Key var4);

        public void finished(@NotNull String var1, @NotNull DataAuditor.PrintingAdapter var2, boolean var3);
    }

    public static interface CliParameterProcessor {
        @NotNull
        public String process(@NotNull CliLexeme var1, @NotNull String var2);
    }

    public static interface CliBuilder {
        @NotNull
        public Pair<GeneralCommandLine, String> build(@NotNull LocalDataSource var1, @NotNull List<String> var2, @NotNull String var3, @Nullable String var4);

        @NotNull
        public CliNotificationManager getNotificationManager();
    }

    public static class Parameters {
        public String username;
        public String host;
        public String port;
        public String sslCa;
        public String sslCert;
        public String sslKey;

        public Parameters(@Nullable String username, @Nullable String host, @Nullable String port, @Nullable String sslCa, @Nullable String sslCert, @Nullable String sslKey) {
            this.username = username;
            this.host = host;
            this.port = port;
            this.sslCa = sslCa;
            this.sslCert = sslCert;
            this.sslKey = sslKey;
        }

        @NotNull
        public Parameters withHost(@NotNull String host) {
            if (host == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            this.host = host;
            Parameters parameters = this;
            if (parameters == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            return parameters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfiguration$Parameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfiguration$Parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withHost";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface CliSubstitutor {
        @NotNull
        public String substitute(@NotNull LocalDataSource var1, @NotNull List<String> var2, @NotNull String var3);

        @NotNull
        @NlsContexts.DetailedDescription
        public String getDocumentation();

        @NotNull
        public Collection<String> getDefaultPatterns();
    }
}

