/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.script.translator.ToDatabaseScriptTranslator;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToDatabaseScriptTranslationAction
extends AnAction {
    @Nullable
    private static Editor getEditor(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        if (editor != null && project != null) {
            return (Editor)ObjectUtils.chooseNotNull((Object)BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor, (boolean)false), (Object)editor);
        }
        return editor;
    }

    @Nullable
    private static PsiElement getQueryRootPsiElement(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        int queryOffset;
        PsiElement caretPsiElement;
        if (editor == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(1);
        }
        if ((caretPsiElement = psiFile.findElementAt(queryOffset = editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)caretPsiElement, SqlStatement.class);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Editor editor = ToDatabaseScriptTranslationAction.getEditor(e);
        PsiFile psiFile = project == null || editor == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        SqlLanguageDialect sqlLanguageDialect = psiFile == null || !(psiFile.getLanguage() instanceof SqlLanguageDialect) ? null : (SqlLanguageDialect)psiFile.getLanguage();
        boolean isSupported = sqlLanguageDialect != null && ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect) != null;
        boolean isSqlStatement = editor != null && psiFile != null && ToDatabaseScriptTranslationAction.getQueryRootPsiElement(editor, psiFile) != null;
        Presentation presentation = e.getPresentation();
        boolean enabledAndVisible = isSupported && isSqlStatement;
        presentation.setEnabledAndVisible(enabledAndVisible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        SqlLanguageDialect sqlLanguageDialect;
        Project project;
        if (e == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor = ToDatabaseScriptTranslationAction.getEditor(e);
        if (editor == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return;
        }
        Language language = psiFile.getLanguage();
        SqlLanguageDialect sqlLanguageDialect2 = sqlLanguageDialect = !(language instanceof SqlLanguageDialect) ? null : (SqlLanguageDialect)language;
        if (sqlLanguageDialect == null) {
            return;
        }
        ToDatabaseScriptTranslator translator = (ToDatabaseScriptTranslator)ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect);
        if (translator == null) {
            return;
        }
        DatabaseErrorHandler errorHandler = (DatabaseErrorHandler)DatabaseErrorHandler.EP.forDbms(sqlLanguageDialect.getDbms());
        if (errorHandler == null) {
            return;
        }
        PsiElement psiRootElement = ToDatabaseScriptTranslationAction.getQueryRootPsiElement(editor, psiFile);
        if (psiRootElement == null) {
            return;
        }
        try {
            String translatedText = translator.translate(psiRootElement);
            PsiFile globalPsiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (globalPsiFile == null) {
                return;
            }
            Language translatedLanguage = globalPsiFile.getLanguage();
            this.handleTranslatedQueryText(e, project, translatedLanguage, translatedText);
        }
        catch (TranslateException exception) {
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint(editor, exception.getMessage()));
        }
    }

    abstract void handleTranslatedQueryText(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Language var3, @NotNull String var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/ToDatabaseScriptTranslationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getQueryRootPsiElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

