/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowEditMaximizedAction
extends DumbAwareAction {
    private static final String EDIT_MAXIMIZED_POSITION = "EditMaximizedView.POSITION";

    public void update(@NotNull AnActionEvent e) {
        boolean inCell;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Component contextComponent = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        boolean bl = inCell = contextComponent == grid.getResultView().getComponent();
        if (inCell) {
            ModelIndex row = grid.getSelectionModel().getLeadSelectionRow();
            ModelIndex column2 = grid.getSelectionModel().getLeadSelectionColumn();
            Object value2 = row.asInteger() == -1 || column2.asInteger() == -1 ? null : grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
            e.getPresentation().setText(value2 instanceof ObjectFormatter.ImageInfo ? DatabaseBundle.message((String)"action.Console.TableResult.EditValueMaximized.view.image", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.Console.TableResult.EditValueMaximized.maximize", (Object[])new Object[0]));
        } else {
            e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.TableResult.EditValueMaximized.text", (Object[])new Object[0]));
        }
        boolean visible = EditMaximizedViewKt.findEditMaximized(e.getDataContext()) != null;
        e.getPresentation().setEnabledAndVisible(inCell || !visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(1);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        EditMaximizedView view2 = EditMaximizedViewKt.findEditMaximized(e.getDataContext());
        if (view2 == null) {
            view2 = new EditMaximizedView(grid);
            Disposer.register((Disposable)grid, (Disposable)view2);
            ShowEditMaximizedAction.getPosition().set(grid, view2);
        }
        if (grid.isEditable()) {
            EditorCellViewer cellViewer;
            JComponent focusComponent = view2.getPreferedFocusComponent();
            if (focusComponent != null) {
                focusComponent.requestFocus();
            }
            if ((cellViewer = (EditorCellViewer)ObjectUtils.tryCast((Object)view2.getViewer(), EditorCellViewer.class)) != null) {
                cellViewer.selectAll();
            }
        }
    }

    public static void savePosition(@NotNull Position position) {
        if (position == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(2);
        }
        PropertiesComponent.getInstance().setValue(EDIT_MAXIMIZED_POSITION, position.name());
    }

    @NotNull
    public static Position getPosition() {
        String name;
        block6: {
            Position position;
            try {
                name = PropertiesComponent.getInstance().getValue(EDIT_MAXIMIZED_POSITION);
                if (name != null) break block6;
                position = Position.RIGHT;
            }
            catch (IllegalArgumentException e) {
                Position position2 = Position.RIGHT;
                if (position2 == null) {
                    ShowEditMaximizedAction.$$$reportNull$$$0(5);
                }
                return position2;
            }
            if (position == null) {
                ShowEditMaximizedAction.$$$reportNull$$$0(3);
            }
            return position;
        }
        Position position = Position.valueOf(name);
        if (position == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(4);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "savePosition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Position {
        RIGHT{

            @Override
            public void set(@NotNull DataGrid grid, @NotNull EditMaximizedView view2) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (view2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                grid.getComponent().setRightView(view2);
            }

            @Override
            @Nullable
            public EditMaximizedView get(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (EditMaximizedView)ObjectUtils.tryCast((Object)grid.getComponent().getRightView(), EditMaximizedView.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "view";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction$Position$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "set";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "get";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        BOTTOM{

            @Override
            public void set(@NotNull DataGrid grid, @NotNull EditMaximizedView view2) {
                if (grid == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (view2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                grid.getComponent().setBottomView(view2);
            }

            @Override
            @Nullable
            public EditMaximizedView get(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(2);
                }
                return (EditMaximizedView)ObjectUtils.tryCast((Object)grid.getComponent().getBottomView(), EditMaximizedView.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "view";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction$Position$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "set";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "get";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract void set(@NotNull DataGrid var1, @NotNull EditMaximizedView var2);

        @Nullable
        public abstract EditMaximizedView get(@NotNull DataGrid var1);
    }
}

