/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class PrepareIntrospectionDiagnostic
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(0);
        }
        JBIterable<DbElement> selected = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), false);
        e.getPresentation().setEnabledAndVisible(selected.isNotEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JBIterable<DbElement> selected;
        DbDataSource dataSource2;
        if (e == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(1);
        }
        if ((dataSource2 = (DbDataSource)(selected = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), false)).map(DbElement::getDataSource).unique().single()) == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.single", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource2);
        if (lds == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.database", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)lds.getModel(), BasicModModel.class);
        if (model == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.introspected", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        Set elements = selected.map(DbElement::getDelegate).filterMap(d2 -> d2 instanceof LocalDataSource ? (BasicElement)ObjectUtils.doIfCast((Object)((LocalDataSource)d2).getModel(), BasicModModel.class, BasicModel::getRoot) : (BasicElement)ObjectUtils.tryCast((Object)d2, BasicElement.class)).toSet();
        final Ref res2 = Ref.create();
        try {
            File dir = FileUtil.createTempDirectory((String)"introspection-diagnostic", (String)("-" + dataSource2.getName()), (boolean)true);
            res2.set((Object)new File(dir, "dataSource.txt"));
            PrepareIntrospectionDiagnostic.writeDataSourceInfo(lds, (File)res2.get());
            this.serialise(lds, model, elements, new File(dir, "model.xml"));
            this.writeIntrospectorInfo(dataSource2.getProject(), lds, elements, new File(dir, "introspector.txt"));
            RevealFileAction.openFile((File)((File)res2.get()));
        }
        catch (Throwable th) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(StringUtil.notNullize((String)th.getMessage(), (String)th.getClass().getSimpleName()), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.collected", (Object[])new Object[0]), "<a href=\"view\">" + ((File)res2.get()).getAbsolutePath() + "</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                RevealFileAction.openFile((File)((File)res2.get()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/actions/PrepareIntrospectionDiagnostic$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(dataSource2.getProject());
    }

    protected void writeIntrospectorInfo(Project project, LocalDataSource lds, Set<BasicElement> elements, File file) {
        SearchPath path = ObjectPaths.searchPathOf((DasObject)ContainerUtil.getFirstItem(elements));
        DatabaseSessionManager.facade(project, lds, DatabaseCredentials.getInstance(), path, false, new ErrorHandler(), DGDepartment.INTROSPECTION).runSync(connection2 -> {
            DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(project, ModelFactory.BLACK_HOLE, connection2, lds);
            try {
                introspector.attachToDB((DatabaseConnection)connection2);
                String info = introspector.collectDiagnosticInfo(elements);
                if (info != null) {
                    try {
                        FileUtil.writeToFile((File)file, (String)info);
                    }
                    catch (IOException exception) {
                        ExceptionUtil.rethrow((Throwable)exception);
                    }
                }
            }
            finally {
                introspector.detachFromDB();
            }
            return null;
        });
    }

    private static void writeDataSourceInfo(LocalDataSource dataSource2, File file) throws IOException {
        try (PrintWriter p2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CharsetToolkit.UTF8_CHARSET));){
            p2.println(DataSourceUiUtil.formatDataSourceInfoString(dataSource2));
            p2.println("JDBC Introspector: " + dataSource2.useLegacyIntrospector());
            p2.print("Driver properties set: " + StringUtil.join(dataSource2.getDriverProperties().keySet(), (String)", "));
            DatabaseDriver driver = dataSource2.getDatabaseDriver();
            if (driver != null) {
                p2.println("Driver id: " + driver.getId());
                p2.println("Class" + driver.getDriverClass());
                for (DatabaseDriver.ArtifactRef artifact : driver.getArtifacts()) {
                    p2.println("Artifact: " + artifact.getId() + ":" + artifact.getArtifactVersion() + "[" + artifact.getChannel() + "]");
                }
                for (SimpleClasspathElement element2 : driver.getAdditionalClasspathElements()) {
                    for (String url : element2.getClassesRootUrls()) {
                        p2.println("Lib: " + url);
                    }
                }
                for (SimpleClasspathElement element2 : driver.getNativeLibraryPaths()) {
                    for (String url : element2.getClassesRootUrls()) {
                        p2.println("Native Lib: " + url);
                    }
                }
            }
        }
    }

    private void serialise(LocalDataSource dataSource2, BasicModModel model, Set<BasicElement> elements, File file) throws IOException {
        Set paths = ContainerUtil.map2Set(elements, BasicPaths::of);
        BasicModModel target = ModelLightCopier.copy(model, ModelFactory.BLACK_HOLE, false);
        target.modify(BasicModRoot.class, r -> this.retain((BasicModElement)r, paths));
        DataSourceStorage.writeModel(file, target, dataSource2.getName(), dataSource2.getIntrospectionScope());
    }

    protected boolean retain(BasicModElement node, Set<ObjectPath> paths) {
        if (paths.contains(BasicPaths.of(node))) {
            return true;
        }
        for (ModFamily modFamily : node.getFamilies()) {
            modFamily.remove(c2 -> !this.retain((BasicModElement)c2, paths));
        }
        return node.hasChildren();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/PrepareIntrospectionDiagnostic";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

