/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GeoViewer;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GridGeoViewAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GridGeoViewAction.class);

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            GridGeoViewAction.$$$reportNull$$$0(0);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!JBCefApp.isSupported()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        boolean enabled = grid.getVisibleColumns().size() > 0;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GridGeoViewAction.$$$reportNull$$$0(1);
        }
        if (!JBCefApp.isSupported()) {
            GridGeoViewAction.suggestEnablingJCef(e);
            return;
        }
        GeoViewer.show(e);
    }

    private static void suggestEnablingJCef(@NotNull AnActionEvent e) {
        if (e == null) {
            GridGeoViewAction.$$$reportNull$$$0(2);
        }
        if (!PlatformUtils.isDataGrip()) {
            Messages.showWarningDialog((Project)e.getProject(), (String)DatabaseBundle.message((String)"jcef.not.available", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"jcef.not.available.text", (Object[])new Object[0]));
            return;
        }
        int res2 = Messages.showYesNoDialog((Project)e.getProject(), (String)DatabaseBundle.message((String)"enable.jcef.message", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"enable.jcef", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"enable.jcef", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (res2 == 0) {
            Registry.get((String)"ide.browser.jcef.enabled").setValue(true);
            RegistryBooleanOptionDescriptor.suggestRestart(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/GridGeoViewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestEnablingJCef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

