/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001a\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u001c\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0000\u001a\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"DATA_SOURCE_RAW_SETTINGS_BEGIN", "", "DATA_SOURCE_RAW_SETTINGS_END", "DATA_SOURCE_SETTINGS_BEGIN", "DATA_SOURCE_SETTINGS_END", "DATA_SOURCE_SETTINGS_HEADER", "addSuffixIfNeeded", "originalName", "project", "Lcom/intellij/openapi/project/Project;", "doCopySettings", "", "dss", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "exportSettings", "ds", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "focusOnDataSource", "getDataSourceNames", "importDataSourceFromSettings", "buffer", "importDataSourcesFromSettings", "text", "intellij.database.impl"})
public final class DataSourceSettingsHelperKt {
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_HEADER = "#DataSourceSettings#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_BEGIN = "#BEGIN#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_END = "#END#";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_BEGIN = "<data-source source=\"LOCAL\" ";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_END = "</data-source>";

    public static final void doCopySettings(@NotNull Collection<? extends LocalDataSource> dss) {
        Intrinsics.checkNotNullParameter(dss, (String)"dss");
        StringBuilder b2 = new StringBuilder(1024);
        b2.append(DATA_SOURCE_SETTINGS_HEADER).append('\n');
        for (LocalDataSource localDataSource : dss) {
            DataSourceSettingsHelperKt.exportSettings(localDataSource, b2);
        }
        CharSequence charSequence = b2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
        String string2 = string;
        DataSourceSerializedSettingsTransferable transferHandle = new DataSourceSerializedSettingsTransferable(string2);
        CopyPasteManager.getInstance().setContents((Transferable)transferHandle);
    }

    public static final void exportSettings(@NotNull LocalDataSource ds, @NotNull StringBuilder b2) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        b2.append("#LocalDataSource: ").append(ds.getName()).append('\n');
        StringBuffer text2 = ds.copySettings(null);
        b2.append(DATA_SOURCE_SETTINGS_BEGIN).append('\n');
        b2.append(text2);
        if (b2.charAt(b2.length() - 1) != '\n') {
            b2.append('\n');
        }
        StringBuilder stringBuilder = b2.append(DATA_SOURCE_SETTINGS_END);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"b.append(DATA_SOURCE_SETTINGS_END)");
        StringBuilder stringBuilder2 = stringBuilder;
        char c2 = '\n';
        boolean bl = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(c2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
    }

    public static final void importDataSourcesFromSettings(@NotNull Project project, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)0, (boolean)false, (int)6, null);
        if (p1 != -1) {
            int q1;
            int p2;
            while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_END, (int)(q1 = p1 + DATA_SOURCE_SETTINGS_BEGIN.length()), (boolean)false, (int)4, null)) >= 0) {
                p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)(p2 + DATA_SOURCE_SETTINGS_END.length()), (boolean)false, (int)4, null);
                String string = text2;
                boolean bl = false;
                String string2 = string.substring(q1, p2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                DataSourceSettingsHelperKt.importDataSourceFromSettings(string2, project);
            }
        } else {
            int p2;
            p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (int)0, (boolean)false, (int)6, null);
            while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_END, (int)p1, (boolean)false, (int)4, null)) >= 0) {
                int q2 = p2 + DATA_SOURCE_RAW_SETTINGS_END.length();
                String string = text2;
                boolean bl = false;
                String string3 = string.substring(p1, q2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                DataSourceSettingsHelperKt.importDataSourceFromSettings(string3, project);
                p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (int)q2, (boolean)false, (int)4, null);
            }
        }
    }

    public static final void importDataSourceFromSettings(@NotNull String buffer, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        LocalDataSource localDataSource = LocalDataSource.createDataSourceFromSettings(buffer, project, false);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"LocalDataSource.createDa\u2026s(buffer, project, false)");
        LocalDataSource ds = localDataSource;
        ds.resolveDriver();
        if (ds.getDatabaseDriver() == null) {
            ds.ensureDriverConfigured();
        }
        ds.setGlobal(project == null);
        String string = ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ds.name");
        ds.setName(DataSourceSettingsHelperKt.addSuffixIfNeeded(string, project));
        DataSourceStorage.getProjectStorage(project).addDataSource(ds);
        String string2 = ds.getAdditionalJdbcProperties().remove("test-user-password");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it2 = string3;
            boolean bl3 = false;
            DatabaseCredentials.getInstance().setPassword(ds, new OneTimeString(it2));
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(project, ds){
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $ds;

            public final void run() {
                DataSourceSettingsHelperKt.access$focusOnDataSource(this.$project, this.$ds);
            }
            {
                this.$project = project;
                this.$ds = localDataSource;
            }
        });
    }

    private static final String addSuffixIfNeeded(String originalName, Project project) {
        Collection<String> existentNames = DataSourceSettingsHelperKt.getDataSourceNames(project);
        String name = originalName;
        int k = 1;
        while (existentNames.contains(name)) {
            name = originalName + " [" + ++k + ']';
        }
        return name;
    }

    private static final Collection<String> getDataSourceNames(Project project) {
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dataSourceStorage), (String)"DataSourceStorage.getProjectStorage(project)");
        List list = dataSourceStorage.getDataSourcesImpl().map((Function)getDataSourceNames.1.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DataSourceStorage.getPro\u2026{ it.name }\n    .toList()");
        return list;
    }

    private static final void focusOnDataSource(Project project, LocalDataSource ds) {
        Project project2 = project;
        if (project2 == null) {
            DefaultProjectFactory defaultProjectFactory = DefaultProjectFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)defaultProjectFactory, (String)"DefaultProjectFactory.getInstance()");
            project2 = defaultProjectFactory.getDefaultProject();
        }
        Project p2 = project2;
        DbDataSource dsPsiElement = DbImplUtil.getDbDataSource(p2, ds);
        if (dsPsiElement != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(p2, dsPsiElement){
                final /* synthetic */ Project $p;
                final /* synthetic */ DbDataSource $dsPsiElement;

                public final void run() {
                    DatabaseView.refreshViewAndSelect(this.$p, CollectionsKt.listOf((Object)this.$dsPsiElement));
                }
                {
                    this.$p = project;
                    this.$dsPsiElement = dbDataSource;
                }
            });
        }
    }

    public static final /* synthetic */ void access$focusOnDataSource(Project project, LocalDataSource ds) {
        DataSourceSettingsHelperKt.focusOnDataSource(project, ds);
    }
}

