/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findOurFlavor", "Ljava/awt/datatransfer/DataFlavor;", "flavors", "", "([Ljava/awt/datatransfer/DataFlavor;)Ljava/awt/datatransfer/DataFlavor;", "getTextFromClipboard", "", "getTransferableFromClipboard", "Ljava/awt/datatransfer/Transferable;", "isDataSourceSettings", "", "text", "isTextImportEnabled", "update", "Companion", "intellij.database.impl"})
public final class CreateDataSourceFromSettings
extends DumbAwareAction {
    @NotNull
    public static final String ENABLE_TEXT_IMPORT_KEY = "database.import.datasource.from.text";
    @NotNull
    private static final String MIME_SUFFIX;
    private static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        Transferable t = this.getTransferableFromClipboard();
        if (t != null) {
            if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
                enabled = true;
            } else {
                DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
                Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"t.transferDataFlavors");
                if (this.findOurFlavor(dataFlavorArray) != null) {
                    enabled = true;
                } else if (!t.isDataFlavorSupported(DataFlavor.imageFlavor) && t.isDataFlavorSupported(DataFlavor.stringFlavor) && this.isTextImportEnabled()) {
                    String text2;
                    Object object = t.getTransferData(DataFlavor.stringFlavor);
                    if (!(object instanceof String)) {
                        object = null;
                    }
                    enabled = (text2 = (String)object) != null && this.isDataSourceSettings(text2);
                }
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(enabled);
    }

    private final DataFlavor findOurFlavor(DataFlavor[] flavors) {
        DataFlavor dataFlavor;
        block1: {
            DataFlavor[] $this$firstOrNull$iv = flavors;
            boolean $i$f$firstOrNull = false;
            DataFlavor[] dataFlavorArray = $this$firstOrNull$iv;
            int n = dataFlavorArray.length;
            for (int j = 0; j < n; ++j) {
                DataFlavor element$iv;
                DataFlavor it2 = element$iv = dataFlavorArray[j];
                boolean bl = false;
                String string = it2.getMimeType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.mimeType");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)MIME_SUFFIX, (boolean)false, (int)2, null)) continue;
                dataFlavor = element$iv;
                break block1;
            }
            dataFlavor = null;
        }
        return dataFlavor;
    }

    private final boolean isTextImportEnabled() {
        return Registry.is((String)ENABLE_TEXT_IMPORT_KEY, (boolean)true);
    }

    private final boolean isDataSourceSettings(String text2) {
        return StringsKt.startsWith$default((String)text2, (String)"#DataSourceSettings#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)"<data-source source=\"LOCAL\" ", (boolean)false, (int)2, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        String string = this.getTextFromClipboard();
        if (string == null) {
            return;
        }
        String text2 = string;
        if (this.isDataSourceSettings(text2)) {
            DataSourceSettingsHelperKt.importDataSourcesFromSettings(project2, text2);
        }
    }

    private final Transferable getTransferableFromClipboard() {
        CopyPasteManager cpm;
        CopyPasteManager copyPasteManager = cpm = CopyPasteManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)copyPasteManager, (String)"cpm");
        return copyPasteManager.getContents();
    }

    private final String getTextFromClipboard() {
        Transferable t = this.getTransferableFromClipboard();
        if (t == null) {
            return null;
        }
        if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
            Object object = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
            if (!(object instanceof DataSourceSettingsCapsule)) {
                object = null;
            }
            DataSourceSettingsCapsule dataSourceSettingsCapsule = (DataSourceSettingsCapsule)object;
            return dataSourceSettingsCapsule != null ? dataSourceSettingsCapsule.content : null;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            Object object = t.getTransferData(DataFlavor.stringFlavor);
            if (!(object instanceof String)) {
                object = null;
            }
            return (String)object;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        MIME_SUFFIX = "class=" + Reflection.getOrCreateKotlinClass(DataSourceSettingsCapsule.class).getQualifiedName();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings$Companion;", "", "()V", "ENABLE_TEXT_IMPORT_KEY", "", "MIME_SUFFIX", "getMIME_SUFFIX", "()Ljava/lang/String;", "intellij.database.impl"})
    private static final class Companion {
        @NotNull
        public final String getMIME_SUFFIX() {
            return MIME_SUFFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

