/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachDirectoryUtils {
    public static void chooseAndAddDirectoriesWithUndo(@NotNull Project project, @Nullable Consumer<? super List<VirtualFile>> callback) {
        Module[] modules;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(0);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length == 0) {
            return;
        }
        Module module = modules[0];
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, null, files -> {
            AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(module, files);
            if (callback != null) {
                callback.consume(files);
            }
        });
    }

    public static void addDirectoriesWithUndo(@NotNull Project project, @NotNull List<VirtualFile> roots) {
        Module[] modules;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(2);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length == 0) {
            return;
        }
        Module module = modules[0];
        AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(module, roots);
    }

    private static void addAndSelectDirectoriesWithUndo(@NotNull Module module, @NotNull List<VirtualFile> roots) {
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(4);
        }
        AttachDirectoryUtils.addRemoveEntriesWithUndo(module, roots, true);
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem(roots);
        if (file != null) {
            ProjectViewSelectInTarget.select((Project)module.getProject(), (Object)file, (String)"ProjectPane", null, (VirtualFile)file, (boolean)true);
        }
    }

    public static void addRemoveEntriesWithUndo(final @NotNull Module module, @NotNull List<VirtualFile> roots, final boolean add) {
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(6);
        }
        Project project = module.getProject();
        final ArrayList adjustedRoots = ContainerUtil.newArrayList((Iterable)JBIterable.from(roots).filter(o -> add == (ModuleUtilCore.findModuleForFile((VirtualFile)o, (Project)project) == null)).filterMap(o -> o.isDirectory() ? o : o.getParent()).unique());
        adjustedRoots.removeIf(r -> ContainerUtil.exists((Iterable)adjustedRoots, r2 -> VfsUtilCore.isAncestor((VirtualFile)r2, (VirtualFile)r, (boolean)true)));
        if (adjustedRoots.isEmpty()) {
            return;
        }
        String title = DatabaseBundle.message((String)"command.name.choice.attach.detach", (Object[])new Object[]{add ? 0 : 1, AttachDirectoryUtils.getDisplayName(adjustedRoots)});
        WriteCommandAction.writeCommandAction((Project)project).withName(title).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            class MyUndoable
            extends GlobalUndoableAction {
                MyUndoable() {
                }

                public void undo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(module, adjustedRoots, !add);
                }

                public void redo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(module, adjustedRoots, add);
                }
            }
            MyUndoable undoable = new MyUndoable();
            undoable.redo();
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoable);
        });
    }

    public static String getDisplayName(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(7);
        }
        return roots.size() == 1 ? "directory '" + roots.get(0).getName() + "'" : roots.size() + " " + StringUtil.pluralize((String)"directory", (int)roots.size());
    }

    private static void addRemoveEntriesInner(@NotNull Module module, @NotNull List<VirtualFile> files, boolean add) {
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(8);
        }
        if (files == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(9);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (add) {
                for (VirtualFile file : files) {
                    model.addContentEntry(file);
                }
            } else {
                for (ContentEntry entry : model.getContentEntries()) {
                    if (!files.contains(entry.getFile())) continue;
                    model.removeContentEntry(entry);
                }
            }
        });
    }

    @NotNull
    public static List<VirtualFile> getAttachedDirectories(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(10);
        }
        List<VirtualFile> list = (modules = ModuleManager.getInstance((Project)project).getModules()).length != 0 ? Arrays.asList(ModuleRootManager.getInstance((Module)modules[0]).getContentRoots()) : Collections.emptyList();
        if (list == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/AttachDirectoryUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/AttachDirectoryUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndAddDirectoriesWithUndo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoriesWithUndo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelectDirectoriesWithUndo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesWithUndo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesInner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedDirectories";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

