/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public abstract class LoginStateListener {
    private boolean myIsInBatch;
    private final Set<P4Connection> myConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public void reconnected(P4Connection connection) {
        if (this.myIsInBatch) {
            this.myConnections.add(connection);
        } else {
            this.notifyListeners(Collections.singleton(connection));
        }
    }

    public void startBatch() {
        this.myIsInBatch = true;
    }

    public void fireBatchFinished() {
        this.myIsInBatch = false;
        this.notifyListeners(this.myConnections);
        this.myConnections.clear();
    }

    protected abstract void notifyListeners(Set<P4Connection> var1);
}

