/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

class LoginNotifier
extends GenericNotifierImpl<P4Connection, ConnectionId> {
    private static final String INSPECT = "inspect";
    private static final String FIX = "fix";
    private final PerforceLoginManager myLoginManager;

    LoginNotifier(Project project, PerforceLoginManager loginManager) {
        super(project, "Perforce", PerforceBundle.message((String)"connection.problems", (Object[])new Object[0]), NotificationType.ERROR);
        this.myLoginManager = loginManager;
    }

    @NotNull
    @NlsContexts.NotificationContent
    protected String getNotificationContent(P4Connection connection) {
        String string = PerforceBundle.message((String)"connection.error.notification", (Object[])new Object[]{connection.getWorkingDirectory(), FIX, INSPECT});
        if (string == null) {
            LoginNotifier.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean ask(P4Connection obj, String description) {
        if (FIX.equals(description)) {
            PerforceSettings.getSettings((Project)this.myProject).USE_LOGIN = true;
            PerforceConnectionManager.getInstance(this.myProject).updateConnections();
            return this.myLoginManager.checkAndRepair(obj);
        }
        if (INSPECT.equals(description)) {
            PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
            return false;
        }
        return false;
    }

    @NotNull
    protected ConnectionId getKey(P4Connection obj) {
        ConnectionId connectionId = obj.getId();
        if (connectionId == null) {
            LoginNotifier.$$$reportNull$$$0(1);
        }
        return connectionId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/perforce/perforce/login/LoginNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

