/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import gnu.trove.TObjectLongHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceManager;

public abstract class P4HaveParser {
    private static final String HAVE_DELIMITER = " - ";
    private final PerforceManager myPerforceManager;

    public P4HaveParser(PerforceManager perforceManager) {
        this.myPerforceManager = perforceManager;
    }

    public void consumeLine(String haveLine) throws VcsException {
        int hashIndex = haveLine.indexOf(35);
        if (hashIndex < 0) {
            throw new VcsException(PerforceBundle.message((String)"error.unexpected.p4.have.output.format", (Object[])new Object[]{haveLine}));
        }
        int idx = haveLine.indexOf(HAVE_DELIMITER, hashIndex);
        if (idx < 0) {
            throw new VcsException(PerforceBundle.message((String)"error.unexpected.p4.have.output.format", (Object[])new Object[]{haveLine}));
        }
        String localPath = haveLine.substring(idx + HAVE_DELIMITER.length());
        localPath = this.myPerforceManager.convertP4ParsedPath(null, localPath);
        long revision = Long.parseLong(haveLine.substring(hashIndex + 1, idx));
        this.consumeRevision(FileUtil.toSystemDependentName((String)localPath), revision);
    }

    public abstract void consumeRevision(String var1, long var2);

    void readHaveOutput(InputStream inputStream) throws IOException, VcsException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null && line.length() != 0) {
            this.consumeLine(line);
        }
    }

    static class RevisionCollector
    extends P4HaveParser {
        private final TObjectLongHashMap<String> myHaveRevisions;

        RevisionCollector(PerforceManager perforceManager, @NotNull TObjectLongHashMap<String> haveRevisions) {
            if (haveRevisions == null) {
                RevisionCollector.$$$reportNull$$$0(0);
            }
            super(perforceManager);
            this.myHaveRevisions = haveRevisions;
        }

        @Override
        public void consumeRevision(String path, long revision) {
            this.myHaveRevisions.put((Object)path, revision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "haveRevisions", "org/jetbrains/idea/perforce/perforce/P4HaveParser$RevisionCollector", "<init>"));
        }
    }
}

