/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public abstract class VcsOperation
implements Cloneable {
    protected String myChangeList;
    private static final Key<Map<P4Connection, Map<Long, Boolean>>> PENDING_CACHE = Key.create((String)"PENDING_CACHE");

    @TestOnly
    public final void execute(Project project) throws VcsException {
        this.execute(project, new ProcessingContext());
    }

    public abstract void execute(Project var1, ProcessingContext var2) throws VcsException;

    protected VcsOperation() {
    }

    protected VcsOperation(String changeList) {
        this.myChangeList = changeList;
    }

    @NotNull
    abstract String getInputPath();

    @NotNull
    abstract String getOutputPath();

    public String getChangeList() {
        return this.myChangeList;
    }

    public void setChangeList(String changeList) {
        this.myChangeList = changeList;
    }

    @Nullable
    public Change getChange(Project project, ChangeListManagerGate addGate) {
        return null;
    }

    public void fillReopenedPaths(Map<String, String> result) {
    }

    @Nullable
    public VcsOperation checkMerge(VcsOperation oldOp) {
        return oldOp;
    }

    protected long getPerforceChangeList(Project project, P4File p4File, ProcessingContext context) throws VcsException {
        P4Connection connection;
        ChangeListManager listManager = ChangeListManager.getInstance((Project)project);
        LocalChangeList list = listManager.findChangeList(this.myChangeList);
        if (list == null) {
            list = listManager.getDefaultChangeList();
        }
        if ((connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(p4File)) == null) {
            return -1L;
        }
        for (Long number : PerforceNumberNameSynchronizer.getInstance(project).findOrCreate(connection, list)) {
            if (number <= 0L || !VcsOperation.isValidPendingNumber(project, connection, number, context)) continue;
            return number;
        }
        return -1L;
    }

    private static boolean isValidPendingNumber(Project project, P4Connection connection, long number, ProcessingContext context) {
        Boolean valid;
        HashMap<Long, Boolean> cache;
        HashMap map = (HashMap)context.get(PENDING_CACHE);
        if (map == null) {
            map = new HashMap();
            context.put(PENDING_CACHE, map);
        }
        if ((cache = (HashMap<Long, Boolean>)map.get(connection)) == null) {
            cache = new HashMap<Long, Boolean>();
            map.put(connection, cache);
        }
        if ((valid = (Boolean)cache.get(number)) == null) {
            valid = PerforceRunner.getInstance(project).isValidPendingNumber(connection, number);
            cache.put(number, valid);
        }
        return valid;
    }

    public void prepareOffline(Project project) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract List<String> getAffectedPaths();
}

