/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;

public class PerforceOfflineRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final Logger LOG = Logger.getInstance(PerforceOfflineRollbackEnvironment.class);
    private final Project myProject;

    public PerforceOfflineRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        String string = PerforceBundle.message((String)"operation.name.revert", (Object[])new Object[0]);
        if (string == null) {
            PerforceOfflineRollbackEnvironment.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void rollbackChanges(List<? extends Change> changes, List<VcsException> _exceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            PerforceOfflineRollbackEnvironment.$$$reportNull$$$0(1);
        }
        List<VcsException> exceptions = Collections.synchronizedList(_exceptions);
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision != null) {
                try {
                    String content;
                    boolean isRenameOrMove;
                    VirtualFile file;
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision != null && !afterRevision.getFile().equals(beforeRevision.getFile())) {
                        file = afterRevision.getFile().getVirtualFile();
                        isRenameOrMove = true;
                    } else {
                        file = beforeRevision.getFile().getVirtualFile();
                        isRenameOrMove = false;
                    }
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("before rollback " + change + "; " + beforeRevision);
                        if (file != null) {
                            this.LOG.debug("has last content " + (LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)file) != null));
                        }
                    }
                    if ((content = beforeRevision.getContent()) != null && file != null) {
                        actions.add(() -> {
                            if (this.myProject.isDisposed()) {
                                return;
                            }
                            listener.accept(c);
                            VcsOperationLog.getInstance(this.myProject).addToLog(new P4RevertOperation(c));
                            try {
                                file.setWritable(true);
                                VfsUtil.saveText((VirtualFile)file, (String)content);
                                if (isRenameOrMove) {
                                    this.handleMoveRename(beforeRevision, file, afterRevision);
                                }
                                file.setWritable(false);
                            }
                            catch (IOException e) {
                                exceptions.add(new VcsException((Throwable)e));
                            }
                        });
                        continue;
                    }
                    this.LOG.debug("contentUnavailable: content " + (content != null) + ", file " + file);
                    exceptions.add(PerforceOfflineRollbackEnvironment.contentUnavailable(beforeRevision.getFile().getPath()));
                }
                catch (VcsException ex) {
                    exceptions.add(ex);
                }
                continue;
            }
            VcsOperationLog.getInstance(this.myProject).addToLog(new P4RevertOperation(change));
        }
        PerforceOfflineRollbackEnvironment.executeActions(listener, exceptions, actions);
    }

    private static void executeActions(RollbackProgressListener listener, List<? super VcsException> exceptions, List<? extends Runnable> actions) {
        if (!exceptions.isEmpty()) {
            return;
        }
        listener.determinate();
        for (Runnable runnable : actions) {
            WriteAction.runAndWait(runnable::run);
        }
    }

    private static VcsException contentUnavailable(String file) {
        return new VcsException(PerforceBundle.message((String)"error.cannot.revert.file.original.content.is.not.available.offline", (Object[])new Object[]{file}));
    }

    private void handleMoveRename(ContentRevision beforeRevision, VirtualFile file, ContentRevision afterRevision) throws IOException {
        String oldName = beforeRevision.getFile().getName();
        FilePath oldParentPath = beforeRevision.getFile().getParentPath();
        VirtualFile newParent = file.getParent();
        if (oldParentPath != null && newParent != null && !FileUtil.toSystemIndependentName((String)oldParentPath.getPath()).equals(newParent.getPath())) {
            File oldParentFile = new File(oldParentPath.getPath());
            oldParentFile.mkdirs();
            VirtualFile oldParentVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(oldParentFile);
            if (oldParentVFile != null) {
                file.move((Object)this, oldParentVFile);
            }
        }
        if (!file.getName().equals(oldName)) {
            file.rename((Object)this, oldName);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(beforeRevision.getFile());
        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(afterRevision.getFile());
    }

    public void rollbackMissingFileDeletion(List<? extends FilePath> files, List<? super VcsException> exceptions, RollbackProgressListener listener) {
        throw new UnsupportedOperationException();
    }

    public void rollbackModifiedWithoutCheckout(List<? extends VirtualFile> files, List<? super VcsException> _exceptions, RollbackProgressListener listener) {
        List<? super VcsException> exceptions = Collections.synchronizedList(_exceptions);
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (VirtualFile virtualFile : files) {
            byte[] content = LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)virtualFile);
            if (content == null) {
                exceptions.add(PerforceOfflineRollbackEnvironment.contentUnavailable(virtualFile.getPath()));
                continue;
            }
            actions.add(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.LOG.debug("rollbackModifiedWithoutCheckout file = " + file);
                listener.accept(file);
                try {
                    file.setWritable(true);
                    file.setBinaryContent(content);
                    file.setWritable(false);
                    VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(file);
                }
                catch (IOException e) {
                    exceptions.add(new VcsException((Throwable)e));
                }
            });
        }
        PerforceOfflineRollbackEnvironment.executeActions(listener, exceptions, actions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceOfflineRollbackEnvironment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceOfflineRollbackEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

