/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;

public class PerforceLocalChangeListDecorator
implements ChangeListDecorator {
    private final Project myProject;

    public PerforceLocalChangeListDecorator(Project project) {
        this.myProject = project;
    }

    public void decorateChangeList(@NotNull LocalChangeList changeList, @NotNull ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (changeList == null) {
            PerforceLocalChangeListDecorator.$$$reportNull$$$0(0);
        }
        if (cellRenderer == null) {
            PerforceLocalChangeListDecorator.$$$reportNull$$$0(1);
        }
        if (changeList.hasDefaultName()) {
            return;
        }
        Collection collNumbers = PerforceNumberNameSynchronizer.getInstance(this.myProject).getAllNumbers(changeList.getName()).values();
        if (collNumbers.isEmpty()) {
            return;
        }
        Object text = PerforceBundle.message((String)"change.list.decoration", (Object[])new Object[]{StringUtil.join((Iterable)ContainerUtil.sorted((Collection)collNumbers), (String)", ")});
        int shelved = PerforceManager.getInstance(this.myProject).getShelf().getShelvedChanges(changeList).size();
        if (shelved > 0) {
            text = (String)text + PerforceBundle.message((String)"change.list.decoration.suffix", (Object[])new Object[]{shelved});
        }
        cellRenderer.append((String)text, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "changeList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cellRenderer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/application/PerforceLocalChangeListDecorator";
        objectArray[2] = "decorateChangeList";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

