/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.WaitForProgressToShow;
import javax.swing.Icon;

public class MessageManager {
    private static final Logger LOG = Logger.getInstance((String)MessageManager.class.getName());

    public static void showMessageDialog(Project project, @NlsContexts.DialogMessage String msg, @NlsContexts.DialogTitle String title, Icon icon) {
        Runnable runnable = () -> Messages.showMessageDialog((Project)project, (String)msg, (String)title, (Icon)icon);
        MessageManager.runShowAction(runnable);
    }

    public static void runShowAction(Runnable runnable) {
        try {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)runnable);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static int showDialog(Project project, @NlsContexts.DialogMessage String msg, @NlsContexts.DialogTitle String title, String[] options, int defaultOptionIndex, Icon icon) {
        int[] result = new int[1];
        Runnable runnable = () -> {
            result[0] = Messages.showDialog((Project)project, (String)msg, (String)title, (String[])options, (int)defaultOptionIndex, (Icon)icon);
        };
        MessageManager.runShowAction(runnable);
        return result[0];
    }
}

