/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.jasper2;

import com.intellij.rt.jasper2.CompilerNotifier;
import com.intellij.rt.jasper2.JasperOutputFormatter;
import com.intellij.rt.jasper2.LineReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jasper.JspC;

public class Jasper2Runner {
    private static final boolean DEBUG = true;

    public static void main(String[] args) {
        System.err.println("-- JasperRunner: starting args = " + Arrays.asList(args));
        Jasper2Runner.validate(args);
    }

    private static void validate(String[] args) {
        try {
            String fileName;
            ArrayList<String> jspFilesList = new ArrayList<String>();
            LineReader lineReader = new LineReader(System.in);
            String classPath = lineReader.getNextLine();
            while ((fileName = lineReader.getNextLine()) != null && fileName.length() != 0) {
                jspFilesList.add(fileName);
            }
            String[] jspFiles = jspFilesList.toArray(new String[0]);
            ArrayList<String> jspArgs = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("\"") && arg.endsWith("\"")) {
                    arg = arg.substring(1, arg.length() - 1);
                }
                jspArgs.add(arg);
            }
            jspArgs.addAll(Arrays.asList(jspFiles));
            JspC jspC = new JspC(){

                public boolean getDevelopment() {
                    return true;
                }
            };
            jspC.setArgs(jspArgs.toArray(new String[0]));
            jspC.setClassPath(classPath);
            jspC.execute();
        }
        catch (Throwable e) {
            try {
                CompilerNotifier.reportException(e);
            }
            catch (Throwable ex) {
                JasperOutputFormatter.printError(null, 0, 0, "Failed to report exception \"" + e.getMessage() + "\" properly: " + ex.getMessage(), System.out);
            }
        }
    }
}

