/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.jasper2;

import com.intellij.rt.jasper2.JasperOutputFormatter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;

public class CompilerNotifier
implements ErrorHandler {
    private static final boolean DEBUG = true;
    private int myErrors;
    private static final CompilerNotifier instance = new CompilerNotifier();
    private String myJspFile;

    public static CompilerNotifier getInstance() {
        return instance;
    }

    public void beforeCompile(String jspFile) {
        JasperOutputFormatter.printBeforeValidation(jspFile, System.out);
        JasperOutputFormatter.printBeforeValidation(jspFile, System.err);
    }

    public void compiledOk(String jspFile, String classFilePath, String[] pathsToIncludedFiles) {
        JasperOutputFormatter.printValidatedSuccessfully(jspFile, classFilePath, pathsToIncludedFiles, System.out);
        JasperOutputFormatter.printValidatedSuccessfully(jspFile, classFilePath, pathsToIncludedFiles, System.err);
    }

    public void jspError(String fname, int line, int column, String msg, Exception exception) {
        this.printError(fname, line, column, msg, System.out);
        this.printError(fname, line, column, "jsperr: msg " + msg, System.err);
        ++this.myErrors;
    }

    public void jspError(String msg, Exception exception) {
        String s;
        if ("org.apache.jasper.JasperException".equals(msg)) {
            msg = null;
        }
        String message = msg;
        Throwable rootException = exception;
        while (rootException instanceof ServletException && ((ServletException)rootException).getRootCause() != null) {
            rootException = ((ServletException)rootException).getRootCause();
        }
        String string = s = rootException == null ? null : rootException.getLocalizedMessage();
        if (s != null) {
            message = message == null ? s : message + " " + s;
        }
        this.printError("", -1, -1, message, System.out);
        String errorMessage = "jsperr: exc orig:" + (exception == null ? null : exception.getClass());
        errorMessage = errorMessage + "; root=" + (rootException == null ? null : rootException.getClass()) + "; msg=" + msg + ";" + message;
        this.printError("", -1, -1, errorMessage, System.err);
        ++this.myErrors;
    }

    public void javacError(JavacErrorDetail[] errorDetails) {
        for (JavacErrorDetail errorDetail : errorDetails) {
            this.printError(errorDetail.getJspFileName(), errorDetail.getJspBeginLineNumber(), 0, errorDetail.getErrorMessage(), System.out);
            this.printError(errorDetail.getJspFileName(), errorDetail.getJspBeginLineNumber(), 0, "jsperr: errdetail " + errorDetail.getErrorMessage(), System.err);
            ++this.myErrors;
        }
    }

    public void javacError(String string, Exception exception) {
        this.jspError(string, exception);
    }

    private void printError(String jspFilePath, int line, int column, String errorMessage, PrintStream out) {
        JasperOutputFormatter.printError(jspFilePath != null ? jspFilePath : this.myJspFile, line, column, errorMessage, out);
    }

    public int getErrorCount() {
        return this.myErrors;
    }

    public void setCompilingFile(String jspFile) {
        this.myJspFile = jspFile;
    }

    static void reportException(Throwable e) {
        Throwable root = e;
        while (e != null && !(e instanceof Exception)) {
            e = CompilerNotifier.getCause(e);
        }
        CompilerNotifier compilerNotifier = CompilerNotifier.getInstance();
        if (e == null) {
            root.printStackTrace(System.err);
            compilerNotifier.jspError(root.getMessage(), null);
        } else {
            compilerNotifier.jspError(null, (Exception)e);
        }
    }

    private static Throwable getCause(Throwable e) {
        Throwable cause;
        try {
            Method method = Throwable.class.getMethod("getCause", new Class[0]);
            cause = (Throwable)method.invoke((Object)e, new Object[0]);
        }
        catch (Exception ee) {
            return null;
        }
        return cause != e ? cause : null;
    }
}

