/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.platform;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor;
import org.jetbrains.kotlin.idea.platform.TestRunningUtilsKt;
import org.jetbrains.kotlin.idea.platform.TestRunningUtilsKt$getGenericTestIcon$;
import org.jetbrains.kotlin.idea.util.string.StringUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a.\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\n\u001a\r\u0010\r\u001a\u00020\u000e*\u00020\bH\u0082\u0010\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"IGNORE_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TEST_FQ_NAME", "getGenericTestIcon", "Ljavax/swing/Icon;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initialLocations", "Lkotlin/Function0;", "", "", "isIgnored", "", "isKotlinTestDeclaration", "kotlin.jvm"})
public final class TestRunningUtilsKt {
    private static final FqName TEST_FQ_NAME = new FqName("kotlin.test.Test");
    private static final FqName IGNORE_FQ_NAME = new FqName("kotlin.test.Ignore");

    @Nullable
    public static final Icon getGenericTestIcon(@NotNull KtNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull Function0<? extends List<String>> initialLocations) {
        String testName;
        KtClassOrObject ktClassOrObject;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(initialLocations, (String)"initialLocations");
        if (!TestRunningUtilsKt.isKotlinTestDeclaration(descriptor2)) {
            return null;
        }
        List list = (List)initialLocations.invoke();
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            return null;
        }
        List locations = list;
        Object object = declaration;
        if (object instanceof KtClassOrObject) {
            ktClassOrObject = (KtClassOrObject)declaration;
        } else if (object instanceof KtNamedFunction) {
            ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (ktClassOrObject == null) {
                return null;
            }
        } else {
            return null;
        }
        KtClassOrObject clazz = ktClassOrObject;
        object = locations;
        Object $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)clazz));
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getGenericTestIcon$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $this$filterIsInstance$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)getGenericTestIcon.1.INSTANCE)));
        $i$f$filterIsInstance2 = false;
        CollectionsKt.addAll((Collection)object, (Iterable)$this$filterIsInstance$iv);
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (!(ktNamedDeclaration instanceof KtNamedFunction)) {
            ktNamedDeclaration = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)ktNamedDeclaration;
        String string = testName = ktNamedFunction != null ? ktNamedFunction.getName() : null;
        if (testName != null) {
            $this$filterIsInstance$iv = locations;
            String $i$f$filterIsInstance2 = String.valueOf(testName);
            boolean bl = false;
            $this$filterIsInstance$iv.add($i$f$filterIsInstance2);
        }
        String prefix = testName != null ? "test://" : "suite://";
        String url = prefix + StringUtilKt.joinWithEscape((Collection)locations, (char)'.');
        String javaUrl = "java:" + url;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"declaration.project");
        Project project2 = project;
        Icon icon = KotlinTestRunLineMarkerContributor.Companion.getTestStateIcon(javaUrl, project2, true);
        if (icon == null) {
            icon = KotlinTestRunLineMarkerContributor.Companion.getTestStateIcon(url, project2, false);
        }
        return icon;
    }

    private static final boolean isIgnored(DeclarationDescriptor $this$isIgnored) {
        while (true) {
            ClassDescriptor containingClass;
            boolean bl;
            block7: {
                Iterable $this$any$iv = (Iterable)$this$isIgnored.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)IGNORE_FQ_NAME)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            DeclarationDescriptor declarationDescriptor = $this$isIgnored.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                return false;
            }
            $this$isIgnored = (DeclarationDescriptor)containingClass;
        }
    }

    public static final boolean isKotlinTestDeclaration(@NotNull DeclarationDescriptor $this$isKotlinTestDeclaration) {
        boolean bl;
        block11: {
            boolean bl2;
            block10: {
                Intrinsics.checkNotNullParameter((Object)$this$isKotlinTestDeclaration, (String)"$this$isKotlinTestDeclaration");
                if (TestRunningUtilsKt.isIgnored($this$isKotlinTestDeclaration)) {
                    return false;
                }
                Iterable $this$any$iv = (Iterable)$this$isKotlinTestDeclaration.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)TEST_FQ_NAME)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            DeclarationDescriptor declarationDescriptor = $this$isKotlinTestDeclaration;
            if (!(declarationDescriptor instanceof ClassDescriptorWithResolutionScopes)) {
                declarationDescriptor = null;
            }
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = (ClassDescriptorWithResolutionScopes)declarationDescriptor;
            if (classDescriptorWithResolutionScopes == null) {
                return false;
            }
            ClassDescriptorWithResolutionScopes classDescriptor = classDescriptorWithResolutionScopes;
            Collection collection = classDescriptor.getDeclaredCallableMembers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"classDescriptor.declaredCallableMembers");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl4 = false;
                    CallableMemberDescriptor callableMemberDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"it");
                    if (!TestRunningUtilsKt.isKotlinTestDeclaration((DeclarationDescriptor)callableMemberDescriptor)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }
}

