/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.Flag;
import com.android.flags.FlagOverrides;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Flags {
    private final Map<String, Flag<?>> registeredFlags = Collections.synchronizedMap(new HashMap());
    private final ImmutableFlagOverrides[] fallbackOverridesList;
    private final FlagOverrides mutableOverrides;

    public Flags(FlagOverrides mutableOverrides, ImmutableFlagOverrides ... fallbackOverridesList) {
        this.mutableOverrides = mutableOverrides;
        this.fallbackOverridesList = fallbackOverridesList;
    }

    public Flags(ImmutableFlagOverrides ... immutableOverrides) {
        this(new DefaultFlagOverrides(), immutableOverrides);
    }

    public FlagOverrides getOverrides() {
        return this.mutableOverrides;
    }

    String getOverriddenValue(Flag<?> flag) {
        String flagValue = this.mutableOverrides.get(flag);
        if (flagValue == null) {
            ImmutableFlagOverrides flagOverrides;
            ImmutableFlagOverrides[] immutableFlagOverridesArray = this.fallbackOverridesList;
            int n = immutableFlagOverridesArray.length;
            for (int i = 0; i < n && (flagValue = (flagOverrides = immutableFlagOverridesArray[i]).get(flag)) == null; ++i) {
            }
        }
        return flagValue;
    }

    void verifyUniqueId(Flag<?> flag) {
        Flag<?> existingFlag = this.registeredFlags.putIfAbsent(flag.getId(), flag);
        if (existingFlag != null) {
            throw new IllegalArgumentException(String.format("Flag \"%s\" shares duplicate ID \"%s\" with flag \"%s\"", flag.getDisplayName(), flag.getId(), existingFlag.getDisplayName()));
        }
    }
}

