/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityUtil {
    public static boolean isSpringSecurityUsed(DomFileElement<Beans> domFileElement) {
        return SpringSecurityUtil.isSpringSecurityNamespaceUsed(domFileElement) || SpringSecurityUtil.isFilterChainProxyDefined(domFileElement);
    }

    public static boolean isSpringSecurityNamespaceUsed(DomFileElement<Beans> domFileElement) {
        return SpringDomUtils.hasNamespace(domFileElement, (String)"Spring Security namespace key");
    }

    private static boolean isFilterChainProxyDefined(DomFileElement<Beans> domFileElement) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return false;
        }
        PsiClass filterChainProxy = DomJavaUtil.findClass((String)"org.springframework.security.web.FilterChainProxy", domFileElement);
        if (filterChainProxy == null) {
            return false;
        }
        Set springModels = SpringManager.getInstance((Project)module.getProject()).getSpringModelsByFile((PsiFile)domFileElement.getFile());
        for (CommonSpringModel model : springModels) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (PsiClass)filterChainProxy)) continue;
            return true;
        }
        return false;
    }

    public static SpringSecurityVersion getVersion(@NotNull DomElement element) {
        if (element == null) {
            SpringSecurityUtil.$$$reportNull$$$0(0);
        }
        Module module = element.getModule();
        Project project = element.getManager().getProject();
        SpringSecurityVersion version = module != null ? SpringSecurityUtil.getSpringSecurityVersion(module) : SpringSecurityUtil.getSpringSecurityVersion(project, GlobalSearchScope.allScope((Project)project));
        return version != null ? version : SpringSecurityVersion.V_2_0;
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringSecurityVersion version) {
        if (module == null) {
            return false;
        }
        SpringSecurityVersion cached = SpringSecurityUtil.getSpringSecurityVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    public static SpringSecurityVersion getSpringSecurityVersion(@NotNull Module module) {
        if (module == null) {
            SpringSecurityUtil.$$$reportNull$$$0(1);
        }
        Project project = module.getProject();
        return (SpringSecurityVersion)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SpringSecurityVersion detected = SpringSecurityUtil.getSpringSecurityVersion(project, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false));
            return CachedValueProvider.Result.create((Object)((Object)detected), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }));
    }

    @Nullable
    private static SpringSecurityVersion getSpringSecurityVersion(Project project, GlobalSearchScope scope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        SpringSecurityVersion detected = null;
        for (SpringSecurityVersion version : (SpringSecurityVersion[])ArrayUtil.reverseArray((Object[])SpringSecurityVersion.values())) {
            PsiClass psiClass = javaPsiFacade.findClass(version.getDetectionClassFqn(), scope);
            if (psiClass == null) continue;
            detected = version;
            break;
        }
        return detected;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/security/util/SpringSecurityUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringSecurityVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

