/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.model.jam.roles.SpringJamRolesHolder;
import com.intellij.spring.security.model.xml.SpringSecurityDomElement;
import com.intellij.spring.security.model.xml.SpringSecurityRolesHolderMarkup;
import com.intellij.spring.security.model.xml.converters.SpringSecurityRolesConverter;
import com.intellij.spring.security.references.extensions.SpringSecurityRolesProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRoleUtils {
    @NotNull
    public static Set<String> collectRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(0);
        }
        HashSet<String> roles = new HashSet<String>();
        for (SpringJamRolesHolder holder : SpringSecurityRoleUtils.collectJamRoles(module)) {
            ContainerUtil.addAllNotNull(roles, holder.getRoles());
        }
        ContainerUtil.addAllNotNull(roles, SpringSecurityRoleUtils.collectDomRoles(module));
        for (SpringSecurityRolesProvider provider : SpringSecurityRolesProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            ContainerUtil.addAllNotNull(roles, provider.getRoles(module));
        }
        HashSet<String> hashSet = roles;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static Set<SpringJamRolesHolder> collectJamRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(2);
        }
        HashSet<SpringJamRolesHolder> elements = new HashSet<SpringJamRolesHolder>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        elements.addAll(JamService.getJamService((Project)module.getProject()).getJamClassElements(SpringJamRolesHolder.JAM_KEY, "org.springframework.security.access.annotation.Secured", scope));
        elements.addAll(JamService.getJamService((Project)module.getProject()).getJamMethodElements(SpringJamRolesHolder.JAM_KEY, "org.springframework.security.access.annotation.Secured", scope));
        return elements;
    }

    public static Set<String> collectDomRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(3);
        }
        HashSet<String> roles = new HashSet<String>();
        for (SpringSecurityRolesHolderMarkup securityRolesMarkup : SpringSecurityRoleUtils.getDomSecurityRolesMarkups(module)) {
            for (DomElement domElement : DomUtil.getDefinedChildren((DomElement)securityRolesMarkup, (boolean)false, (boolean)true)) {
                Object domRoles;
                String stringValue;
                if (!(domElement instanceof GenericAttributeValue)) continue;
                GenericAttributeValue attributeValue = (GenericAttributeValue)domElement;
                Converter converter = attributeValue.getConverter();
                if (converter instanceof WrappingConverter) {
                    converter = WrappingConverter.getDeepestConverter((Converter)converter, (GenericDomValue)attributeValue);
                }
                if (!(converter instanceof SpringSecurityRolesConverter) || !StringUtil.isNotEmpty((String)(stringValue = attributeValue.getStringValue())) || (domRoles = ((SpringSecurityRolesConverter)converter).fromString(stringValue, ConvertContextFactory.createConvertContext((DomElement)attributeValue))) == null) continue;
                ContainerUtil.addAllNotNull(roles, (Iterable)domRoles);
            }
        }
        return roles;
    }

    @NotNull
    private static Set<SpringSecurityRolesHolderMarkup> getDomSecurityRolesMarkups(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(4);
        }
        final HashSet<SpringSecurityRolesHolderMarkup> markups = new HashSet<SpringSecurityRolesHolderMarkup>();
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        for (VirtualFile candidate : springXmlCandidates) {
            DomFileElement fileElement;
            PsiFile file = PsiManager.getInstance((Project)project).findFile(candidate);
            if (!(file instanceof XmlFile) || (fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)file))) == null) continue;
            for (SpringSecurityDomElement securityDomElement : DomUtil.getChildrenOf((DomElement)fileElement.getRootElement(), SpringSecurityDomElement.class)) {
                DomUtil.acceptAvailableChildren((DomElement)securityDomElement, (DomElementVisitor)new DomElementVisitor(){

                    public void visitDomElement(DomElement element) {
                        if (element instanceof SpringSecurityRolesHolderMarkup) {
                            markups.add((SpringSecurityRolesHolderMarkup)element);
                        }
                        element.acceptChildren((DomElementVisitor)this);
                    }
                });
            }
        }
        HashSet<SpringSecurityRolesHolderMarkup> hashSet = markups;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRoleUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRoleUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomSecurityRolesMarkups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectRoles";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectJamRoles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectDomRoles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDomSecurityRolesMarkups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

