/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.spring.security.model.jam.roles.SpringJamRolesHolder;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityPomTargetRole;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRolesFactory;
import com.intellij.spring.security.references.SpringSecurityRoleUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myRoleName;
    private final Module myModule;
    private final boolean myIncludePredefinedRoles;

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles) {
        if (element == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(0);
        }
        if (roleName == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(2);
        }
        super(element, SpringSecurityRolePsiReference.getTextRange(element, roleName));
        this.myRoleName = roleName;
        this.myModule = module;
        this.myIncludePredefinedRoles = includePredefinedRoles;
    }

    private static TextRange getTextRange(PsiElement element, String roleName) {
        if (roleName.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        int offset = element.getText().indexOf(roleName);
        if (offset == -1) {
            return TextRange.EMPTY_RANGE;
        }
        return TextRange.from((int)offset, (int)roleName.length());
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myRoleName)) {
            return null;
        }
        return this.createSpringSecurityRolePomTargetPsiElement();
    }

    @NotNull
    protected PomTargetPsiElementImpl createSpringSecurityRolePomTargetPsiElement() {
        return new PomTargetPsiElementImpl(this.getElement().getProject(), (PomTarget)SpringSecurityPomTargetRole.create(this.myRoleName)){

            public boolean canNavigate() {
                return true;
            }

            public void navigate(boolean requestFocus) {
                if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                    return;
                }
                Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
                if (editor == null) {
                    return;
                }
                ShowUsagesAction.startFindUsages((PsiElement)this, (RelativePoint)JBPopupFactory.getInstance().guessBestPopupLocation(editor), (Editor)editor);
            }
        };
    }

    public boolean isSoft() {
        return true;
    }

    public Object @NotNull [] getVariants() {
        HashSet<LookupElementBuilder> variants = new HashSet<LookupElementBuilder>();
        for (SpringJamRolesHolder holder : SpringSecurityRoleUtils.collectJamRoles(this.myModule)) {
            variants.addAll(SpringSecurityRolePsiReference.getLookupElements(holder.getRoles()));
        }
        variants.addAll(SpringSecurityRolePsiReference.getLookupElements(SpringSecurityRoleUtils.collectRoles(this.myModule)));
        SpringSecurityRolesFactory securityRolesFactory = SpringSecurityRolesFactory.getInstance(this.myModule);
        if (this.myIncludePredefinedRoles) {
            ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getPredefinedRolesVariants());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    private static Set<LookupElementBuilder> getLookupElements(@NotNull Set<String> roles) {
        if (roles == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(4);
        }
        Set<LookupElementBuilder> set = roles.stream().filter(s -> StringUtil.isNotEmpty((String)s)).map(s -> LookupElementBuilder.create((String)s).withIcon(SpringApiIcons.Spring).bold()).collect(Collectors.toSet());
        if (set == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

