/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters.roles;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRole;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesFactory
implements Disposable {
    private static final Function<SpringSecurityRole, Object> VARIANT_FUNCTION = role -> LookupElementBuilder.create((PsiNamedElement)role).withIcon(role.getIcon()).withTailText(" (" + role.getLocationString() + ")", true);
    private static final List<String> PREDEFINED_ROLES = Arrays.asList("IS_AUTHENTICATED_ANONYMOUSLY", "IS_AUTHENTICATED_FULLY", "IS_AUTHENTICATED_REMEMBERED");
    private static final Function<String, Object> PREDEFINED_VARIANT_FUNCTION = s -> LookupElementBuilder.create((String)s).withIcon(SpringApiIcons.Spring).bold();
    private final Set<SpringSecurityRole> myRoles = new CopyOnWriteArraySet<SpringSecurityRole>();
    private final Map<PsiFile, Long> myContributors = new ConcurrentHashMap<PsiFile, Long>();
    private final PsiFile myDummyFile;

    public static SpringSecurityRolesFactory getInstance(Module module) {
        return (SpringSecurityRolesFactory)module.getService(SpringSecurityRolesFactory.class);
    }

    public SpringSecurityRolesFactory(Module module) {
        this.myDummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("dummy_security_roles.java", "");
    }

    @NotNull
    public SpringSecurityRole getOrCreateRole(@NotNull String roleName, @NotNull PsiFile containingFile) {
        if (roleName == null) {
            SpringSecurityRolesFactory.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            SpringSecurityRolesFactory.$$$reportNull$$$0(1);
        }
        if (this.myContributors.containsKey(containingFile) && this.myContributors.get(containingFile).longValue() != containingFile.getModificationStamp()) {
            this.myRoles.clear();
            this.myContributors.clear();
        }
        for (SpringSecurityRole securityRole : this.myRoles) {
            if (!roleName.equals(securityRole.getName())) continue;
            SpringSecurityRole springSecurityRole = securityRole;
            if (springSecurityRole == null) {
                SpringSecurityRolesFactory.$$$reportNull$$$0(2);
            }
            return springSecurityRole;
        }
        SpringSecurityRole role = new SpringSecurityRole(roleName, containingFile.getName(), this.myDummyFile);
        this.myRoles.add(role);
        this.myContributors.put(containingFile, containingFile.getModificationStamp());
        SpringSecurityRole springSecurityRole = role;
        if (springSecurityRole == null) {
            SpringSecurityRolesFactory.$$$reportNull$$$0(3);
        }
        return springSecurityRole;
    }

    public Object[] getRolesVariants() {
        return ContainerUtil.map2Array(this.myRoles, VARIANT_FUNCTION);
    }

    public Object[] getPredefinedRolesVariants() {
        return ContainerUtil.map2Array(PREDEFINED_ROLES, PREDEFINED_VARIANT_FUNCTION);
    }

    public void dispose() {
        this.myRoles.clear();
        this.myContributors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/model/xml/converters/roles/SpringSecurityRolesFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/model/xml/converters/roles/SpringSecurityRolesFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRole";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

