/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesConverter
extends Converter<List<String>>
implements CustomReferenceConverter<List<String>> {
    public String toString(List<String> strings, ConvertContext context) {
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize((String)s, (String)";,");
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<List<String>> genericDomValue, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        String rolesRawText = genericDomValue.getStringValue();
        if (rolesRawText == null || module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringSecurityRolesConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List roleNames = StringUtil.split((String)rolesRawText, (String)",", (boolean)true, (boolean)false);
        int i = 0;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(roleNames.size());
        for (String roleName : roleNames) {
            String roleNameCleaned = roleName.trim();
            references.add(this.createReference(element, module, roleNameCleaned, i));
            ++i;
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    protected PsiReference createReference(PsiElement element, @NotNull Module module, @NotNull String roleName, int i) {
        if (module == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(2);
        }
        if (roleName == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(3);
        }
        return new SpringSecurityRolePsiReference(element, roleName, module, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

