/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationCoordinator;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationTypeUtil;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestNGConfigurationPanel;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArquillianTestNGRunConfiguration
extends TestNGConfiguration
implements ArquillianTestFrameworkRunConfiguration {
    public ArquillianRunConfiguration arquillianRunConfiguration;
    @NotNull
    private final ArquillianRunConfigurationCoordinator arquillianRunConfigurationCoordinator;

    public ArquillianTestNGRunConfiguration(@NotNull Project project, String containerStateName, @NotNull ConfigurationFactory configurationFactory) {
        if (project == null) {
            ArquillianTestNGRunConfiguration.$$$reportNull$$$0(0);
        }
        if (configurationFactory == null) {
            ArquillianTestNGRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, configurationFactory);
        this.setNameChangedByUser(false);
        this.arquillianRunConfiguration = ArquillianRunConfigurationTypeUtil.getInstance((Project)project).createArquillianRunConfiguration(containerStateName);
        this.arquillianRunConfigurationCoordinator = new ArquillianRunConfigurationCoordinator(project);
    }

    @Nullable
    public RemoteConnectionCreator getRemoteConnectionCreator() {
        return this.arquillianRunConfigurationCoordinator.getRemoteConnectionCreator(this.arquillianRunConfiguration);
    }

    public String suggestedName() {
        String containerName = this.arquillianRunConfiguration.getContainerStateName();
        String suggestedName = super.suggestedName();
        return Strings.isNullOrEmpty((String)containerName) ? suggestedName : containerName + ": " + suggestedName;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String containerStateName = this.arquillianRunConfiguration.getContainerStateName();
        if (Strings.isNullOrEmpty((String)containerStateName)) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.specified", (Object[])new Object[0]));
        }
        if (ArquillianContainersManager.getInstance((Project)this.getProject()).findStateByName(containerStateName) == null) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.found", (Object[])new Object[]{containerStateName}));
        }
    }

    @Nullable
    public Set<String> calculateGroupNames() {
        Set groupNames = super.calculateGroupNames();
        if (groupNames == null) {
            return null;
        }
        groupNames.add("arquillian");
        return groupNames;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ArquillianBundle.message((String)"arquillian.run.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ArquillianTestNGConfigurationPanel(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new TestNGConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            ArquillianTestNGRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    public ArquillianRunConfiguration getArquillianRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    public ArquillianRunConfiguration getRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianTestNGRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianTestNGRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

