/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.GenericValue;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ReadOnlyGenericValue<T>
implements GenericValue<T> {
    public static final GenericValue<?> NULL = ReadOnlyGenericValue.getInstance(null);

    public static <T> GenericValue<T> nullInstance() {
        return NULL;
    }

    @NotNull
    public static <T> GenericValue<T> getInstance(final T value) {
        return new ReadOnlyGenericValue<T>(){

            public T getValue() {
                return value;
            }
        };
    }

    @NotNull
    public static <T> GenericValue<T> getInstance(final T value, final String stringValue) {
        return new ReadOnlyGenericValue<T>(){

            @Override
            public String getStringValue() {
                return stringValue;
            }

            public T getValue() {
                return value;
            }
        };
    }

    public String getStringValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof PsiClass) {
            return ((PsiClass)value).getQualifiedName();
        }
        if (value instanceof PsiPackage) {
            return ((PsiPackage)value).getQualifiedName();
        }
        if (value instanceof PsiNamedElement) {
            return ((PsiNamedElement)value).getName();
        }
        return value.toString();
    }

    public String toString() {
        return this.getStringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.getValue(), ((ReadOnlyGenericValue)o).getValue()) && Objects.equals(this.getStringValue(), ((ReadOnlyGenericValue)o).getStringValue());
    }

    public int hashCode() {
        Object value = this.getValue();
        if (value != null) {
            return value.hashCode();
        }
        String str = this.getStringValue();
        return str != null ? str.hashCode() : 0;
    }
}

