/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamInstantiator;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamAnnotationAttributeMeta<T extends JamElement, JamType>
extends JamAttributeMeta<JamType> {
    protected final JamAnnotationMeta myAnnoMeta;
    protected final SemKey<T> myJamKey;
    protected final JamInstantiator<PsiAnnotation, T> myInstantiator;
    private final List<PairConsumer<T, Consumer<PomTarget>>> myPomTargetProducers = new ArrayList<PairConsumer<T, Consumer<PomTarget>>>();
    private final PsiAnnotationPattern myAnnoPattern;

    private JamAnnotationAttributeMeta(String attrName, JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
        super(attrName);
        this.myAnnoMeta = annoMeta;
        this.myInstantiator = instantiator;
        this.myJamKey = JamService.JAM_ELEMENT_KEY.subKey(attrName, new SemKey[0]);
        this.myAnnoPattern = PsiJavaPatterns.psiAnnotation().qName(this.myAnnoMeta.getAnnoName());
    }

    public JamAnnotationAttributeMeta<T, JamType> addPomTargetProducer(@NotNull PairConsumer<T, Consumer<PomTarget>> producer) {
        if (producer == null) {
            JamAnnotationAttributeMeta.$$$reportNull$$$0(0);
        }
        this.myPomTargetProducers.add(producer);
        return this;
    }

    public List<PomTarget> getAssociatedTargets(@NotNull T element) {
        if (element == null) {
            JamAnnotationAttributeMeta.$$$reportNull$$$0(1);
        }
        ArrayList<PomTarget> list = new ArrayList<PomTarget>();
        Consumer targetConsumer = target -> list.add((PomTarget)target);
        for (PairConsumer<T, Consumer<PomTarget>> function : this.myPomTargetProducers) {
            function.consume(element, (Object)targetConsumer);
        }
        return list;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JamAnnotationAttributeMeta that = (JamAnnotationAttributeMeta)o;
        if (this.myAnnoMeta != null ? !this.myAnnoMeta.equals(that.myAnnoMeta) : that.myAnnoMeta != null) {
            return false;
        }
        return !(this.myInstantiator != null ? !this.myInstantiator.equals(that.myInstantiator) : that.myInstantiator != null);
    }

    @Override
    public int hashCode() {
        int result = this.myAnnoMeta != null ? this.myAnnoMeta.hashCode() : 0;
        result = 31 * result + (this.myInstantiator != null ? this.myInstantiator.hashCode() : 0);
        return result;
    }

    public JamAnnotationMeta getAnnotationMeta() {
        return this.myAnnoMeta;
    }

    public JamInstantiator<PsiAnnotation, T> getInstantiator() {
        return this.myInstantiator;
    }

    public void registerSem(SemRegistrar registrar, ElementPattern<? extends PsiAnnotation> annotationPattern, JamAnnotationMeta parentMeta) {
        PsiAnnotationPattern annoPattern = this.myAnnoPattern.insideAnnotationAttribute(this.getAttributeLink().getAttributeName(), annotationPattern);
        registrar.registerSemElementProvider(this.myJamKey, (ElementPattern)annoPattern, (NullableFunction)new JamCreator(parentMeta));
        this.myAnnoMeta.registerNestedSem(registrar, (ElementPattern<PsiAnnotation>)annoPattern, parentMeta);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jam/reflect/JamAnnotationAttributeMeta";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addPomTargetProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssociatedTargets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected final class JamCreator
    implements NullableFunction<PsiAnnotation, T> {
        private final JamAnnotationMeta myParentMeta;

        private JamCreator(JamAnnotationMeta parentMeta) {
            this.myParentMeta = parentMeta;
        }

        public T fun(PsiAnnotation annotation) {
            PsiAnnotation parentAnno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiAnnotation.class, (boolean)true);
            assert (parentAnno != null);
            JamAnnotationMeta annotationMeta = (JamAnnotationMeta)SemService.getSemService((Project)parentAnno.getProject()).getSemElement(this.myParentMeta.getMetaKey(), (PsiElement)parentAnno);
            if (annotationMeta == this.myParentMeta) {
                return JamAnnotationAttributeMeta.this.myInstantiator.instantiate((PsiElementRef<PsiAnnotation>)PsiElementRef.real((PsiElement)annotation));
            }
            return null;
        }
    }

    public static final class Collection<T extends JamElement>
    extends JamAnnotationAttributeMeta<T, List<T>> {
        public Collection(String attrName, @NotNull JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
            if (annoMeta == null) {
                Collection.$$$reportNull$$$0(0);
            }
            super(attrName, annoMeta, instantiator);
        }

        @Override
        @NotNull
        public List<T> getJam(PsiElementRef<? extends PsiAnnotation> anno) {
            List list = this.getCollectionJam(anno, psiAnnotationMemberValue -> this.getJam((PsiAnnotationMemberValue)psiAnnotationMemberValue));
            if (list == null) {
                Collection.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        private T getJam(PsiAnnotationMemberValue element) {
            if (element instanceof PsiAnnotation) {
                return JamService.getJamService(element.getProject()).getJamElement(this.myJamKey, (PsiElement)element);
            }
            return null;
        }

        @NotNull
        public T addAttribute(PsiElementRef<PsiAnnotation> annoRef) {
            JamElement jamElement = (JamElement)Objects.requireNonNull(this.getJam(Collection.addAttribute(annoRef, "@" + this.myAnnoMeta.getAnnoName(), this.getAttributeLink())));
            if (jamElement == null) {
                Collection.$$$reportNull$$$0(2);
            }
            return (T)jamElement;
        }

        public Collection<T> addPomTargetProducer(@NotNull PairConsumer<T, Consumer<PomTarget>> producer) {
            if (producer == null) {
                Collection.$$$reportNull$$$0(3);
            }
            super.addPomTargetProducer(producer);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annoMeta";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJam";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addPomTargetProducer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Single<T extends JamElement>
    extends JamAnnotationAttributeMeta<T, T> {
        public Single(String attrName, JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
            super(attrName, annoMeta, instantiator);
        }

        @Override
        @NotNull
        public T getJam(PsiElementRef<? extends PsiAnnotation> anno) {
            JamElement jamElement = (JamElement)Objects.requireNonNull(this.getNestedJam(anno));
            if (jamElement == null) {
                Single.$$$reportNull$$$0(0);
            }
            return (T)jamElement;
        }

        @Nullable
        public T getNestedJam(PsiElementRef<? extends PsiAnnotation> anno) {
            PsiAnnotation psiElement = (PsiAnnotation)anno.getPsiElement();
            assert (psiElement != null);
            return JamService.getJamService(anno.getPsiManager().getProject()).getJamElement(this.myJamKey, (PsiElement)psiElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Single", "getJam"));
        }
    }
}

