/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.util;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JamAnnotationUtil {
    private static final NullableFunction<PsiClass, String> PSI_CLASS_FQN = PsiClass::getQualifiedName;

    private JamAnnotationUtil() {
    }

    private static Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(Module module, String annotationName) {
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotationName, (boolean)true);
    }

    public static Collection<String> getChildAnnotations(@Nullable Module module, @NotNull String annotation) {
        if (annotation == null) {
            JamAnnotationUtil.$$$reportNull$$$0(0);
        }
        if (module == null || module.isDisposed()) {
            return Collections.singleton(annotation);
        }
        Collection<PsiClass> classes = JamAnnotationUtil.getAnnotationTypesWithChildrenIncludingTests(module, annotation);
        return ContainerUtil.mapNotNull(classes, PSI_CLASS_FQN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/jam/model/util/JamAnnotationUtil", "getChildAnnotations"));
    }
}

