/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLibraryUtils {
    public static boolean hasLibraryClass(@Nullable Project project, @NotNull String classFqn) {
        if (classFqn == null) {
            JavaLibraryUtils.$$$reportNull$$$0(0);
        }
        if (project == null || project.isDisposed()) {
            return false;
        }
        return JavaLibraryUtils.getLibraryClassMap(project).getOrDefault(classFqn, false);
    }

    public static boolean hasLibraryClass(@Nullable Module module, @NotNull String classFqn) {
        if (classFqn == null) {
            JavaLibraryUtils.$$$reportNull$$$0(1);
        }
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtils.getLibraryClassMap(module).getOrDefault(classFqn, false);
    }

    private static Map<String, Boolean> getLibraryClassMap(@NotNull Project project) {
        if (project == null) {
            JavaLibraryUtils.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(classFqn -> JavaPsiFacade.getInstance((Project)project).findClass(classFqn, GlobalSearchScope.allScope((Project)project)) != null);
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        });
    }

    private static Map<String, Boolean> getLibraryClassMap(@NotNull Module module) {
        if (module == null) {
            JavaLibraryUtils.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(classFqn -> JavaPsiFacade.getInstance((Project)module.getProject()).findClass(classFqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null);
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jam/JavaLibraryUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLibraryClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryClassMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

