/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamService {
    private static final Map<SemKey, SemKey<JamMemberMeta>> ourMetaKeys = new HashMap<SemKey, SemKey<JamMemberMeta>>();
    public static final SemKey<JamMemberMeta> MEMBER_META_KEY = SemKey.createKey((String)"JamMemberMeta", (SemKey[])new SemKey[0]);
    public static final SemKey<JamAnnotationMeta> ANNO_META_KEY = SemKey.createKey((String)"JamAnnotationMeta", (SemKey[])new SemKey[0]);
    public static final SemKey<JamElement> JAM_ELEMENT_KEY = SemKey.createKey((String)"JamElement", (SemKey[])new SemKey[0]);
    public static final SemKey<JamElement> JAM_ALIASING_ELEMENT_KEY = SemKey.createKey((String)"JamAliasingElement", (SemKey[])new SemKey[0]);
    public static final SemKey<JamMemberMeta> ALIASING_MEMBER_META_KEY = JamService.getMetaKey(JAM_ALIASING_ELEMENT_KEY);
    private final PsiManager myPsiManager;
    private final SemService mySemService;
    public static final int CHECK_CLASS = 1;
    public static final int CHECK_METHOD = 2;
    public static final int CHECK_FIELD = 4;
    public static final int CHECK_DEEP = 8;
    public static final int CHECK_ALL_DEEP = 15;

    protected JamService(@NotNull Project project) {
        if (project == null) {
            JamService.$$$reportNull$$$0(0);
        }
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.mySemService = SemService.getSemService((Project)project);
    }

    public static JamService getJamService(Project p) {
        return (JamService)ServiceManager.getService((Project)p, JamService.class);
    }

    private static void processMembers(PsiClass psiClass, @Flags int flags, Processor<? super PsiMember> processor) {
        if (BitUtil.isSet((int)flags, (int)1)) {
            if (BitUtil.isSet((int)flags, (int)8)) {
                for (PsiClass curClass : JamCommonUtil.getSuperClassList(psiClass)) {
                    processor.process((Object)curClass);
                }
            } else {
                processor.process((Object)psiClass);
            }
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            ContainerUtil.process((Object[])(BitUtil.isSet((int)flags, (int)8) ? psiClass.getAllMethods() : psiClass.getMethods()), processor);
        }
        if (BitUtil.isSet((int)flags, (int)4)) {
            ContainerUtil.process((Object[])(BitUtil.isSet((int)flags, (int)8) ? psiClass.getAllFields() : psiClass.getFields()), processor);
        }
    }

    @Nullable
    public <T extends JamElement> T getJamElement(@NotNull PsiElement psi, JamMemberMeta<? extends PsiModifierListOwner, ? extends T> ... metas) {
        if (psi == null) {
            JamService.$$$reportNull$$$0(1);
        }
        for (JamMemberMeta<PsiModifierListOwner, T> jamMemberMeta : metas) {
            JamElement element = (JamElement)this.mySemService.getSemElement(jamMemberMeta.getJamKey(), psi);
            if (element == null) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public <T extends JamElement> T getJamElement(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            JamService.$$$reportNull$$$0(2);
        }
        if (!psi.isValid()) {
            throw new PsiInvalidElementAccessException(psi);
        }
        try {
            return (T)((JamElement)this.mySemService.getSemElement(key, psi));
        }
        catch (PsiInvalidElementAccessException e) {
            throw new RuntimeException("Element invalidated: old=" + psi + "; new=" + e.getPsiElement(), e);
        }
    }

    @NotNull
    public <T extends PsiModifierListOwner> List<JamMemberMeta> getMetas(@NotNull T psi) {
        if (psi == null) {
            JamService.$$$reportNull$$$0(3);
        }
        List list = this.mySemService.getSemElements(MEMBER_META_KEY, psi);
        if (list == null) {
            JamService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public <T extends PsiModifierListOwner> JamMemberMeta<T, ?> getMeta(@NotNull T psi, SemKey<? extends JamMemberMeta<T, ?>> key) {
        if (psi == null) {
            JamService.$$$reportNull$$$0(5);
        }
        return (JamMemberMeta)this.mySemService.getSemElement(key, psi);
    }

    @Nullable
    public JamAnnotationMeta getMeta(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            JamService.$$$reportNull$$$0(6);
        }
        return (JamAnnotationMeta)this.mySemService.getSemElement(ANNO_META_KEY, (PsiElement)anno);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamMemberMeta<? super PsiClass, ? extends T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamClassElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getJamMethodElements(JamMemberMeta<? super PsiMethod, ? extends T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamMethodElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getJamFieldElements(JamMemberMeta<? super PsiField, ? extends T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamFieldElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getAnnotatedMembersList(@NotNull PsiClass psiClass, @Flags int checkFlags, JamMemberMeta<? extends PsiMember, ? extends T> ... metas) {
        if (psiClass == null) {
            JamService.$$$reportNull$$$0(7);
        }
        ArrayList result = new ArrayList();
        JamService.processMembers(psiClass, checkFlags, (Processor<? super PsiMember>)((Processor)member -> {
            for (JamMemberMeta meta : metas) {
                JamElement element = (JamElement)this.mySemService.getSemElement(meta.getJamKey(), (PsiElement)member);
                ContainerUtil.addIfNotNull((Collection)result, (Object)element);
            }
            return true;
        }));
        return result;
    }

    public <T extends JamElement> List<T> getJamClassElements(SemKey<? extends T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = new ArrayList();
        JamCommonUtil.findAnnotatedElements(PsiClass.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamMethodElements(SemKey<? extends T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = new ArrayList();
        JamCommonUtil.findAnnotatedElements(PsiMethod.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamFieldElements(SemKey<? extends T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = new ArrayList();
        JamCommonUtil.findAnnotatedElements(PsiField.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamParameterElements(SemKey<? extends T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = new ArrayList();
        JamCommonUtil.findAnnotatedElements(PsiParameter.class, anno, this.myPsiManager, scope, psiParameter -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiParameter));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getAnnotatedMembersList(@NotNull PsiClass psiClass, SemKey<? extends T> clazz, @Flags int checkFlags) {
        if (psiClass == null) {
            JamService.$$$reportNull$$$0(8);
        }
        ArrayList result = new ArrayList();
        JamService.processMembers(psiClass, checkFlags, (Processor<? super PsiMember>)((Processor)member -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(clazz, (PsiElement)member));
            return true;
        }));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemKey<JamMemberMeta> getMetaKey(SemKey<? extends JamElement> jamKey) {
        Map<SemKey, SemKey<JamMemberMeta>> map = ourMetaKeys;
        synchronized (map) {
            SemKey result = ourMetaKeys.get(jamKey);
            if (result == null) {
                Object[] jamSupers = jamKey.getSupers();
                SemKey[] metaSupers = (SemKey[])ContainerUtil.map2Array((Object[])jamSupers, SemKey.class, key -> JamService.getMetaKey((SemKey<? extends JamElement>)key));
                result = MEMBER_META_KEY.subKey(jamKey + "Meta", metaSupers);
                ourMetaKeys.put(jamKey, (SemKey<JamMemberMeta>)result);
            }
            return result;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/JamService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/JamService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJamElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMetas";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMeta";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedMembersList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Flags {
    }
}

